/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class PositionBoundsResolver {
    private final DataObject dataObject;
    private final CloneableEditorSupport editorSupport;
    private final String elementName;

    public PositionBoundsResolver(DataObject dataObject, String string) {
        Parameters.notNull((CharSequence)"dataObject", (Object)dataObject);
        this.dataObject = dataObject;
        this.editorSupport = this.findCloneableEditorSupport();
        if (this.editorSupport == null) {
            throw new IllegalArgumentException("Couldn't get CloneableEditorSupport for " + dataObject);
        }
        this.elementName = string;
    }

    public PositionBounds getPositionBounds() {
        if (this.elementName != null) {
            try {
                BaseDocument baseDocument = this.getDocument();
                String string = baseDocument.getText(0, baseDocument.getLength());
                int n = string.indexOf(this.elementName);
                if (n > -1) {
                    PositionRef positionRef = this.editorSupport.createPositionRef(n, Position.Bias.Forward);
                    PositionRef positionRef2 = this.editorSupport.createPositionRef(n + this.elementName.length(), Position.Bias.Backward);
                    return new PositionBounds(positionRef, positionRef2);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return this.getDefaultPositionBounds();
    }

    private PositionBounds getDefaultPositionBounds() {
        PositionRef positionRef = this.editorSupport.createPositionRef(0, Position.Bias.Forward);
        PositionRef positionRef2 = this.editorSupport.createPositionRef(0, Position.Bias.Backward);
        return new PositionBounds(positionRef, positionRef2);
    }

    private CloneableEditorSupport findCloneableEditorSupport() {
        Node.Cookie cookie = this.dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = this.dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    private BaseDocument getDocument() {
        BaseDocument baseDocument = (BaseDocument)this.editorSupport.getDocument();
        if (baseDocument == null) {
            CreateXMLPane createXMLPane = new CreateXMLPane();
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    createXMLPane.run();
                } else {
                    SwingUtilities.invokeAndWait(createXMLPane);
                }
                baseDocument = new BaseDocument(createXMLPane.getPane().getEditorKit().getClass(), false);
                String string = this.readResource(this.dataObject.getPrimaryFile().getInputStream());
                baseDocument.remove(0, baseDocument.getLength());
                baseDocument.insertString(0, string, null);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Exceptions.printStackTrace((Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return baseDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string);
                string2 = bufferedReader.readLine();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return stringBuffer.toString();
    }

    private static class CreateXMLPane
    implements Runnable {
        JEditorPane pane;

        private CreateXMLPane() {
        }

        public void run() {
            this.pane = new JEditorPane("text/xml", "");
        }

        public JEditorPane getPane() {
            return this.pane;
        }
    }
}

