/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

public class Config
implements Cloneable {
    public static final String KEY_PREFIX = "org.ini4j.config.";
    public static final String PROP_EMPTY_OPTION = "emptyOption";
    public static final String PROP_GLOBAL_SECTION = "globalSection";
    public static final String PROP_GLOBAL_SECTION_NAME = "globalSectionName";
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_LOWER_CASE_OPTION = "lowerCaseOption";
    public static final String PROP_LOWER_CASE_SECTION = "lowerCaseSection";
    public static final String PROP_MULTI_OPTION = "multiOption";
    public static final String PROP_MULTI_SECTION = "multiSection";
    public static final String PROP_STRICT_OPERATOR = "strictOperator";
    public static final String PROP_UNNAMED_SECTION = "unnamedSection";
    public static final String PROP_ESCAPE = "escape";
    public static final boolean DEFAULT_EMPTY_OPTION = false;
    public static final boolean DEFAULT_GLOBAL_SECTION = false;
    public static final String DEFAULT_GLOBAL_SECTION_NAME = "?";
    public static final boolean DEFAULT_INCLUDE = false;
    public static final boolean DEFAULT_LOWER_CASE_OPTION = false;
    public static final boolean DEFAULT_LOWER_CASE_SECTION = false;
    public static final boolean DEFAULT_MULTI_OPTION = true;
    public static final boolean DEFAULT_MULTI_SECTION = false;
    public static final boolean DEFAULT_STRICT_OPERATOR = false;
    public static final boolean DEFAULT_UNNAMED_SECTION = false;
    public static final boolean DEFAULT_ESCAPE = true;
    private static final Config GLOBAL = new Config();
    private boolean _emptyOption;
    private boolean _escape;
    private boolean _globalSection;
    private String _globalSectionName;
    private boolean _include;
    private boolean _lowerCaseOption;
    private boolean _lowerCaseSection;
    private boolean _multiOption;
    private boolean _multiSection;
    private boolean _strictOperator;
    private boolean _unnamedSection;

    public Config() {
        this.reset();
    }

    public static Config getGlobal() {
        return GLOBAL;
    }

    public boolean isEscape() {
        return this._escape;
    }

    public boolean isInclude() {
        return this._include;
    }

    public void setEmptyOption(boolean value) {
        this._emptyOption = value;
    }

    public void setEscape(boolean value) {
        this._escape = value;
    }

    public void setGlobalSection(boolean value) {
        this._globalSection = value;
    }

    public String getGlobalSectionName() {
        return this._globalSectionName;
    }

    public void setGlobalSectionName(String value) {
        this._globalSectionName = value;
    }

    public void setInclude(boolean value) {
        this._include = value;
    }

    public void setLowerCaseOption(boolean value) {
        this._lowerCaseOption = value;
    }

    public void setLowerCaseSection(boolean value) {
        this._lowerCaseSection = value;
    }

    public void setMultiOption(boolean value) {
        this._multiOption = value;
    }

    public void setMultiSection(boolean value) {
        this._multiSection = value;
    }

    public boolean isEmptyOption() {
        return this._emptyOption;
    }

    public boolean isGlobalSection() {
        return this._globalSection;
    }

    public boolean isLowerCaseOption() {
        return this._lowerCaseOption;
    }

    public boolean isLowerCaseSection() {
        return this._lowerCaseSection;
    }

    public boolean isMultiOption() {
        return this._multiOption;
    }

    public boolean isMultiSection() {
        return this._multiSection;
    }

    public boolean isUnnamedSection() {
        return this._unnamedSection;
    }

    public boolean isStrictOperator() {
        return this._strictOperator;
    }

    public void setStrictOperator(boolean value) {
        this._strictOperator = value;
    }

    public void setUnnamedSection(boolean value) {
        this._unnamedSection = value;
    }

    public Config clone() {
        try {
            return (Config)super.clone();
        }
        catch (CloneNotSupportedException x) {
            throw new AssertionError((Object)x);
        }
    }

    public final void reset() {
        this._emptyOption = this.getBoolean(PROP_EMPTY_OPTION, false);
        this._globalSection = this.getBoolean(PROP_GLOBAL_SECTION, false);
        this._globalSectionName = this.getString(PROP_GLOBAL_SECTION_NAME, DEFAULT_GLOBAL_SECTION_NAME);
        this._include = this.getBoolean(PROP_INCLUDE, false);
        this._lowerCaseOption = this.getBoolean(PROP_LOWER_CASE_OPTION, false);
        this._lowerCaseSection = this.getBoolean(PROP_LOWER_CASE_SECTION, false);
        this._multiOption = this.getBoolean(PROP_MULTI_OPTION, true);
        this._multiSection = this.getBoolean(PROP_MULTI_SECTION, false);
        this._strictOperator = this.getBoolean(PROP_STRICT_OPERATOR, false);
        this._unnamedSection = this.getBoolean(PROP_UNNAMED_SECTION, false);
        this._escape = this.getBoolean(PROP_ESCAPE, true);
    }

    private boolean getBoolean(String name, boolean defaultValue) {
        String key = KEY_PREFIX + name;
        return System.getProperties().containsKey(key) ? Boolean.getBoolean(key) : defaultValue;
    }

    private String getString(String name, String defaultValue) {
        String key = KEY_PREFIX + name;
        return System.getProperties().containsKey(key) ? System.getProperty(key) : defaultValue;
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.clone();
    }
}

