/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wizard.XMLContentAttributes;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class XMLGeneratorVisitor
extends DeepAXITreeVisitor {
    private XMLContentAttributes contentAttr;
    private String elemPrefix = "";
    private String attrPrefix = "";
    private String defaultPrefix;
    private AXIModel axiModel;
    private int depth = 0;
    private String schemaFileName;
    private Element rElement;
    private StringBuffer writer;
    private String primaryTNS;
    Map<String, String> namespaceToPrefix;
    private int counter = 1;
    private static final String PREFIX = "ns";
    private boolean qualifiedElem;

    public XMLGeneratorVisitor(String string, XMLContentAttributes xMLContentAttributes, StringBuffer stringBuffer) {
        this.contentAttr = xMLContentAttributes;
        this.defaultPrefix = this.contentAttr.getPrefix() + ":";
        this.schemaFileName = string;
        this.writer = stringBuffer;
        this.namespaceToPrefix = this.contentAttr.getNamespaceToPrefixMap();
    }

    public void generateXML(String string, SchemaModel schemaModel) {
        if (schemaModel.getSchema().getAttributeFormDefaultEffective().equals((Object)Form.QUALIFIED)) {
            this.attrPrefix = this.defaultPrefix;
        }
        if (schemaModel.getSchema().getElementFormDefaultEffective().equals((Object)Form.QUALIFIED)) {
            this.elemPrefix = this.defaultPrefix;
        }
        this.axiModel = AXIModelFactory.getDefault().getModel(schemaModel);
        this.rElement = this.findAXIGlobalElement(string);
        this.primaryTNS = this.rElement.getTargetNamespace();
        if (this.rElement != null) {
            this.visit(this.rElement);
        }
        this.contentAttr.setNamespaceToPrefixMap(this.namespaceToPrefix);
    }

    public void generateXML(String string) {
        if (string == null || this.schemaFileName == null || this.schemaFileName.equals("") || string.equals("")) {
            return;
        }
        File file = new File(this.schemaFileName);
        FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fileObject == null) {
            return;
        }
        ModelSource modelSource = null;
        try {
            modelSource = Utilities.createModelSource((FileObject)fileObject, (boolean)true);
        }
        catch (Exception exception) {
            return;
        }
        if (modelSource == null) {
            return;
        }
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
        this.generateXML(string, schemaModel);
    }

    public void generateXML(Element element) {
        if (element != null) {
            this.visit(element);
        }
    }

    public void visit(Element element) {
        int n = this.getOccurence(element.getMinOccurs(), element.getMaxOccurs());
        if (!this.contentAttr.generateOptionalElements() && this.isElementOptional(element)) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.visitChildren((AXIComponent)element);
        }
    }

    protected void visitChildren(AXIComponent aXIComponent) {
        try {
            this.printModel(aXIComponent);
            ++this.depth;
            this.visitChildrenForXML(aXIComponent);
            this.postVisitChildren(aXIComponent);
            --this.depth;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isElementOptional(Element element) {
        int n = Integer.parseInt(element.getMinOccurs());
        return n == 0;
    }

    private void printModel(AXIComponent aXIComponent) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (aXIComponent.getChildElements().isEmpty()) {
            bl = false;
        }
        if (aXIComponent instanceof Compositor) {
            Compositor compositor = (Compositor)aXIComponent;
            stringBuffer.append(this.getTab() == null ? compositor : this.getTab() + compositor);
            stringBuffer.append("<min=" + compositor.getMinOccurs() + ":max=" + compositor.getMaxOccurs() + ">");
            return;
        }
        if (aXIComponent instanceof Element) {
            Element element = (Element)aXIComponent;
            String string = this.setPrefixForElement(element);
            if (element.equals(this.rElement)) {
                int n;
                if (element.getAttributes().size() != 0 && (n = this.writer.lastIndexOf("\n")) != -1) {
                    this.writer = this.writer.insert(n - 1, " " + this.getAttributes(element));
                }
                return;
            }
            stringBuffer.append(this.getTab() == null ? element.getName() : this.getTab() + "<" + string + element.getName());
            if (element.getAttributes().size() != 0) {
                stringBuffer.append(" " + this.getAttributes(element));
            }
            if (bl) {
                this.writer.append(stringBuffer.toString() + ">" + "\n");
            } else {
                this.writer.append(stringBuffer.toString() + ">");
            }
            this.writer.append(this.getComponentValue((AXIComponent)element));
        }
    }

    private String getAttributes(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AbstractAttribute abstractAttribute : element.getAttributes()) {
            String string = this.attrPrefix;
            if (this.isGlobal((AXIComponent)abstractAttribute)) {
                string = this.contentAttr.getPrefix() + ":";
            }
            if (abstractAttribute instanceof Attribute && !this.contentAttr.generateOptionalAttributes()) {
                if (!((Attribute)abstractAttribute).getUse().equals((Object)Attribute.Use.REQUIRED)) continue;
                stringBuffer.append(string + abstractAttribute + "=\"" + this.getComponentValue((AXIComponent)((Attribute)abstractAttribute)) + "\" ");
                continue;
            }
            if (abstractAttribute instanceof Attribute) {
                stringBuffer.append(string + abstractAttribute + "=\"" + this.getComponentValue((AXIComponent)((Attribute)abstractAttribute)) + "\" ");
                continue;
            }
            stringBuffer.append(abstractAttribute + "= \" \" ");
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private String getTab() {
        String string = "    ";
        if (this.depth == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected void visitChildrenForXML(AXIComponent aXIComponent) {
        Object object;
        if (!super.canVisit(aXIComponent)) {
            return;
        }
        if (aXIComponent instanceof Compositor && (object = ((Compositor)aXIComponent).getType()).equals((Object)Compositor.CompositorType.CHOICE)) {
            List list = aXIComponent.getChildren();
            if (list != null && list.size() > 0) {
                ((AXIComponent)aXIComponent.getChildren().get(0)).accept((AXIVisitor)this);
            }
            return;
        }
        for (AXIComponent aXIComponent2 : aXIComponent.getChildren()) {
            aXIComponent2.accept((AXIVisitor)this);
        }
    }

    private int getOccurence(String string, String string2) {
        if (string2.equals("unbounded")) {
            return this.contentAttr.getPreferredOccurences();
        }
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        if (this.contentAttr.getPreferredOccurences() > n && this.contentAttr.getPreferredOccurences() < n2) {
            return this.contentAttr.getPreferredOccurences();
        }
        if (this.contentAttr.getPreferredOccurences() > n2) {
            return n2;
        }
        if (this.contentAttr.getPreferredOccurences() < n) {
            return n;
        }
        return n;
    }

    private void postVisitChildren(AXIComponent aXIComponent) throws IOException {
        if (aXIComponent instanceof Element) {
            if (((Element)aXIComponent).equals(this.rElement)) {
                return;
            }
            String string = this.setPrefixForElement((Element)aXIComponent);
            if (aXIComponent.getChildElements().isEmpty()) {
                this.writer.append("</" + string + ((Element)aXIComponent).getName() + ">" + "\n");
            } else {
                this.writer.append(this.getTab() + "</" + string + ((Element)aXIComponent).getName() + ">" + "\n");
            }
        }
    }

    private Element findAXIGlobalElement(String string) {
        if (string == null) {
            return null;
        }
        for (Element element : this.axiModel.getRoot().getElements()) {
            if (!element.getName().equals(string)) continue;
            return element;
        }
        return null;
    }

    private String getComponentValue(AXIComponent aXIComponent) {
        Element element;
        String string = null;
        if (aXIComponent instanceof Attribute) {
            Attribute attribute = (Attribute)aXIComponent;
            string = attribute.getFixed();
            if (string == null) {
                string = attribute.getDefault();
            }
        } else if (aXIComponent instanceof Element && (string = (element = (Element)aXIComponent).getFixed()) == null) {
            string = element.getDefault();
        }
        if (string != null) {
            return string;
        }
        return "";
    }

    private String generatePrefix() {
        String string = PREFIX + this.counter++;
        while (this.namespaceToPrefix.containsValue(string)) {
            string = PREFIX + this.counter++;
        }
        return string;
    }

    private String setPrefixForElement(Element element) {
        String string = this.elemPrefix;
        String string2 = element.isReference() ? element.getReferent().getTargetNamespace() : element.getTargetNamespace();
        if (string2 == null) {
            return string;
        }
        if (!string2.equals(this.primaryTNS)) {
            String string3;
            if (this.namespaceToPrefix == null) {
                this.namespaceToPrefix = new HashMap<String, String>();
            }
            if ((string3 = this.namespaceToPrefix.get(string2)) == null || string3.equals("")) {
                string3 = this.generatePrefix();
                this.namespaceToPrefix.put(string2, string3);
            }
            string = string3 + ":";
            return string;
        }
        if (this.isGlobal((AXIComponent)element)) {
            return this.defaultPrefix;
        }
        return string;
    }

    private boolean isGlobal(AXIComponent aXIComponent) {
        AXIComponent aXIComponent2 = aXIComponent.getOriginal();
        if (aXIComponent2.getComponentType() == AXIComponent.ComponentType.REFERENCE) {
            return true;
        }
        return aXIComponent2.isGlobal();
    }
}

