/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharScanner;

public final class ANTLRHashString {
    private String s;
    private char[] buf;
    private int len;
    private CharScanner lexer;
    private boolean caseSensitiveLiterals;
    private int hashCode = -1;
    private static final int prime = 151;

    public ANTLRHashString(char[] cArray, int n, CharScanner charScanner) {
        this.lexer = charScanner;
        this.caseSensitiveLiterals = charScanner.getCaseSensitiveLiterals();
        this.setBuffer(cArray, n);
    }

    public ANTLRHashString(CharScanner charScanner) {
        this.lexer = charScanner;
        this.caseSensitiveLiterals = charScanner.getCaseSensitiveLiterals();
    }

    public ANTLRHashString(String string, CharScanner charScanner) {
        this.lexer = charScanner;
        this.caseSensitiveLiterals = charScanner.getCaseSensitiveLiterals();
        this.setString(string);
    }

    public ANTLRHashString(String string, boolean bl) {
        this.lexer = null;
        this.caseSensitiveLiterals = bl;
        this.setString(string);
    }

    private final char charAt(int n) {
        return this.s != null ? this.s.charAt(n) : this.buf[n];
    }

    public boolean equals(Object object) {
        if (!(object instanceof ANTLRHashString) && !(object instanceof String)) {
            return false;
        }
        ANTLRHashString aNTLRHashString = object instanceof String ? new ANTLRHashString((String)object, this.lexer) : (ANTLRHashString)object;
        int n = this.length();
        if (aNTLRHashString.length() != n) {
            return false;
        }
        if (this.lexer != null) {
            if (this.lexer.getCaseSensitiveLiterals()) {
                for (int i = 0; i < n; ++i) {
                    if (this.charAt(i) == aNTLRHashString.charAt(i)) continue;
                    return false;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (this.lexer.toLower(this.charAt(i)) == this.lexer.toLower(aNTLRHashString.charAt(i))) continue;
                    return false;
                }
            }
        } else if (this.caseSensitiveLiterals) {
            for (int i = 0; i < n; ++i) {
                if (this.charAt(i) == aNTLRHashString.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.toLower(this.charAt(i)) == this.toLower(aNTLRHashString.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private char toLower(char c) {
        return Character.toLowerCase(c);
    }

    public int hashCode() {
        if (this.hashCode == -1 || this.lexer != null) {
            int n = 0;
            int n2 = this.length();
            if (this.lexer != null) {
                if (this.lexer.getCaseSensitiveLiterals()) {
                    for (int i = 0; i < n2; ++i) {
                        n = n * 151 + this.charAt(i);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        n = n * 151 + this.lexer.toLower(this.charAt(i));
                    }
                }
            } else if (this.caseSensitiveLiterals) {
                for (int i = 0; i < n2; ++i) {
                    n = n * 151 + this.charAt(i);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    n = n * 151 + this.toLower(this.charAt(i));
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    private final int length() {
        return this.s != null ? this.s.length() : this.len;
    }

    public void setBuffer(char[] cArray, int n) {
        this.buf = cArray;
        this.len = n;
        this.s = null;
    }

    public void setString(String string) {
        this.s = string;
        this.buf = null;
    }
}

