/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.application.ResourceMap;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DesignResourceMap
extends ResourceMap {
    static final int APP_LEVEL = 0;
    static final int CLASS_LEVEL = 2;
    private static final String NOI18N_COMMENT = "NOI18N";
    private FileObject sourceFile;
    private BundleStructure[] bundles;
    private String locale;
    private String[] localeBundleNames;
    private int storageLevel;
    private Map<String, ChangeInfo> changes = new HashMap<String, ChangeInfo>();
    private static final String EVALUATING_KEY = "#EVALUATING_KEY#";
    private String evaluateStringValue;

    DesignResourceMap(ResourceMap resourceMap, ClassLoader classLoader, FileObject fileObject, String[] stringArray, int n) {
        super(resourceMap, classLoader, stringArray);
        this.sourceFile = fileObject;
        this.bundles = new BundleStructure[stringArray.length];
        this.locale = "";
        this.localeBundleNames = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.localeBundleNames[i] = DesignResourceMap.getShortBundleName(stringArray[i]);
        }
        this.storageLevel = n;
    }

    public DesignResourceMap getDesignParent() {
        ResourceMap resourceMap = super.getParent();
        return resourceMap instanceof DesignResourceMap ? (DesignResourceMap)resourceMap : null;
    }

    DesignResourceMap getLevel(int n) {
        if (n == this.storageLevel) {
            return this;
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        if (designResourceMap != null) {
            return designResourceMap.getLevel(n);
        }
        return null;
    }

    FileObject getSourceFile() {
        return this.sourceFile;
    }

    void setLocalization(String string) {
        if (this.locale.equals(string)) {
            return;
        }
        this.locale = string;
        List<String> list = this.getBundleNames();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = DesignResourceMap.getShortBundleName(list.get(i));
            this.localeBundleNames[i] = string != null && !string.equals("") ? string2 + string : string2;
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        if (designResourceMap != null) {
            designResourceMap.setLocalization(string);
        }
    }

    private static String getShortBundleName(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }

    private BundleStructure[] getBundles() {
        List<String> list = null;
        for (int i = 0; i < this.bundles.length; ++i) {
            if (this.bundles[i] != null) continue;
            if (list == null) {
                list = this.getBundleNames();
            }
            this.bundles[i] = ResourceUtils.getBundleStructure(this.sourceFile, list.get(i));
        }
        return this.bundles;
    }

    PropertiesDataObject getRepresentativeDataObject() {
        for (String string : this.getBundleNames()) {
            PropertiesDataObject propertiesDataObject = ResourceUtils.getPropertiesDataObject(this.sourceFile, string, false);
            if (propertiesDataObject == null) continue;
            return propertiesDataObject;
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        return designResourceMap != null ? designResourceMap.getRepresentativeDataObject() : null;
    }

    ResourceValueImpl getResourceValue(String string, Class clazz) {
        BundleStructure[] bundleStructureArray = this.getBundles();
        for (int i = 0; i < bundleStructureArray.length; ++i) {
            Object object;
            Element.ItemElem itemElem;
            BundleStructure bundleStructure = bundleStructureArray[i];
            if (bundleStructure == null || (itemElem = bundleStructure.getItem(this.localeBundleNames[i], string)) == null) continue;
            try {
                object = this.getObject(string, clazz);
            }
            catch (ResourceMap.LookupException lookupException) {
                ErrorManager.getDefault().notify(1, (Throwable)lookupException);
                object = null;
            }
            String string2 = itemElem.getValue();
            String string3 = this.getResourceName(clazz, string2);
            return new ResourceValueImpl(string, clazz, object, string3, string2, !DesignResourceMap.isNoI18nComment(itemElem.getComment()), this.storageLevel, this.sourceFile);
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        return designResourceMap != null ? designResourceMap.getResourceValue(string, clazz) : null;
    }

    private static boolean isNoI18nComment(String string) {
        if (string != null && string.length() > 0) {
            string = string.trim().toUpperCase();
            return string.contains(NOI18N_COMMENT);
        }
        return false;
    }

    private String getResourceName(Class clazz, String string) {
        if (Icon.class.isAssignableFrom(clazz)) {
            return this.getResourcesDir() + string;
        }
        return null;
    }

    Object evaluateStringValue(String string, Class clazz) {
        this.evaluateStringValue = string;
        Object object = this.getObject(EVALUATING_KEY, clazz);
        this.evaluateStringValue = null;
        return object;
    }

    Collection<String> collectKeys(String string, boolean bl) {
        Collection<String> collection = this.collectKeys(string, null, bl);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    private Collection<String> collectKeys(String string, Collection<String> collection, boolean bl) {
        DesignResourceMap designResourceMap;
        BundleStructure[] bundleStructureArray = this.getBundles();
        for (int i = 0; i < bundleStructureArray.length; ++i) {
            BundleStructure bundleStructure = bundleStructureArray[i];
            if (bundleStructure == null) continue;
            for (String string2 : bundleStructure.getKeys()) {
                if (!string2.matches(string)) continue;
                if (collection == null) {
                    collection = new LinkedList<String>();
                }
                collection.add(string2);
            }
        }
        if (bl && (designResourceMap = this.getDesignParent()) != null) {
            collection = designResourceMap.collectKeys(string, collection, bl);
        }
        return collection;
    }

    Collection<MultiDataObject.Entry> collectLocaleEntries() {
        Collection<MultiDataObject.Entry> collection = this.collectLocaleEntries(null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    private Collection<MultiDataObject.Entry> collectLocaleEntries(Collection<MultiDataObject.Entry> collection) {
        for (String string : this.getBundleNames()) {
            PropertiesDataObject propertiesDataObject = ResourceUtils.getPropertiesDataObject(this.sourceFile, string, false);
            if (propertiesDataObject != null) {
                if (collection == null) {
                    collection = new LinkedList<MultiDataObject.Entry>();
                }
                collection.add(propertiesDataObject.getPrimaryEntry());
                collection.addAll(propertiesDataObject.secondaryEntries());
            }
            try {
                String string2 = propertiesDataObject.getName() + "_";
                for (FileObject fileObject : propertiesDataObject.getPrimaryFile().getParent().getChildren()) {
                    DataObject dataObject;
                    String string3 = fileObject.getNameExt();
                    if (!string3.endsWith(".properties") || !string3.startsWith(string2) || !((dataObject = DataObject.find((FileObject)fileObject)) instanceof PropertiesDataObject)) continue;
                    collection.add(((MultiDataObject)dataObject).getPrimaryEntry());
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        return designResourceMap != null ? super.collectLocaleEntries(collection) : collection;
    }

    void removeResourceValue(ResourceValueImpl resourceValueImpl) {
        block2: {
            block1: {
                if (resourceValueImpl.getStorageLevel() == this.storageLevel) break block1;
                DesignResourceMap designResourceMap = this.getDesignParent();
                if (designResourceMap == null) break block2;
                designResourceMap.removeResourceValue(resourceValueImpl);
                break block2;
            }
            String string = resourceValueImpl.getKey();
            for (BundleStructure bundleStructure : this.bundles) {
                String[] stringArray;
                if (bundleStructure == null || (stringArray = bundleStructure.getAllData(string)) == null) continue;
                bundleStructure.removeItem(string);
                this.recordChange(string, stringArray, bundleStructure);
                resourceValueImpl.setAllData(stringArray);
                break;
            }
        }
    }

    void addResourceValue(ResourceValueImpl resourceValueImpl) {
        if (resourceValueImpl.getStorageLevel() != this.storageLevel) {
            DesignResourceMap designResourceMap = this.getDesignParent();
            if (designResourceMap != null) {
                designResourceMap.addResourceValue(resourceValueImpl);
            }
        } else {
            String[] stringArray;
            Object object;
            Class clazz;
            String string;
            Object object22;
            String[] stringArray2;
            BundleStructure bundleStructure;
            String string2;
            block14: {
                string2 = resourceValueImpl.getKey();
                int n = 0;
                bundleStructure = null;
                stringArray2 = null;
                for (Object object22 : this.getBundles()) {
                    if (object22 != null && (stringArray2 = object22.getAllData(string2)) != null) {
                        bundleStructure = object22;
                        break;
                    }
                    ++n;
                }
                if (bundleStructure == null) {
                    n = 0;
                    bundleStructure = this.bundles[0];
                }
                String string3 = this.getBundleNames().get(n);
                string = resourceValueImpl.isInternationalized() ? this.localeBundleNames[n] : DesignResourceMap.getShortBundleName(string3);
                PropertiesDataObject propertiesDataObject = null;
                if (bundleStructure == null) {
                    try {
                        propertiesDataObject = ResourceUtils.createPropertiesDataObject(this.getSourceFile(), string3);
                        bundleStructure = propertiesDataObject.getBundleStructure();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        return;
                    }
                }
                if (!string3.endsWith(string)) {
                    object22 = string.substring(DesignResourceMap.getShortBundleName(string3).length() + 1);
                    Util.createLocaleFile((PropertiesDataObject)propertiesDataObject, (String)object22, (boolean)false);
                }
                object22 = resourceValueImpl.getStringValue();
                clazz = resourceValueImpl.getValueType();
                try {
                    object = this.evaluateStringValue((String)object22, clazz);
                }
                catch (ResourceMap.LookupException lookupException) {
                    object = resourceValueImpl.getValue();
                    String string4 = ResourceUtils.getValueAsString(object);
                    if (string4 == null) break block14;
                    resourceValueImpl.setStringValue(string4);
                    object22 = string4;
                }
            }
            bundleStructure.addItem(string, string2, (String)object22, resourceValueImpl.isInternationalized() ? "" : NOI18N_COMMENT, true);
            this.recordChange(string2, stringArray2, bundleStructure);
            if (stringArray2 == null && (stringArray = resourceValueImpl.getAllData()) != null) {
                bundleStructure.setAllData(string2, stringArray);
                resourceValueImpl.setAllData(null);
            }
            resourceValueImpl.setValue(object);
            if (resourceValueImpl.getClassPathResourceName() == null) {
                resourceValueImpl.setClassPathResourceName(this.getResourceName(clazz, (String)object22));
            }
        }
    }

    private void recordChange(String string, String[] stringArray, BundleStructure bundleStructure) {
        if (!this.changes.containsKey(string)) {
            ChangeInfo changeInfo = new ChangeInfo();
            ChangeInfo.access$102(changeInfo, stringArray);
            changeInfo.bundle = bundleStructure;
            this.changes.put(string, changeInfo);
        }
    }

    void save() {
        this.save(true);
    }

    private void save(boolean bl) {
        Object object;
        if (!this.changes.isEmpty()) {
            object = this.getBundleNames().iterator();
            while (object.hasNext()) {
                SaveCookie saveCookie;
                String string = (String)object.next();
                PropertiesDataObject propertiesDataObject = ResourceUtils.getPropertiesDataObject(this.sourceFile, string, false);
                if (propertiesDataObject == null || (saveCookie = (SaveCookie)propertiesDataObject.getCookie(SaveCookie.class)) == null) continue;
                try {
                    saveCookie.save();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            this.changes.clear();
        }
        if (bl && (object = this.getDesignParent()) != null) {
            super.save(bl);
        }
    }

    void revertChanges() {
        for (Map.Entry<String, ChangeInfo> entry : this.changes.entrySet()) {
            String string = entry.getKey();
            BundleStructure bundleStructure = entry.getValue().bundle;
            String[] stringArray = entry.getValue().originalData;
            if (stringArray != null) {
                bundleStructure.setAllData(string, stringArray);
                continue;
            }
            bundleStructure.removeItem(string);
        }
        DesignResourceMap designResourceMap = this.getDesignParent();
        if (designResourceMap != null) {
            designResourceMap.revertChanges();
        }
        this.save(false);
    }

    @Override
    protected boolean containsResourceKey(String string) {
        if (string == EVALUATING_KEY && this.evaluateStringValue != null) {
            return true;
        }
        this.getBundles();
        for (int i = 0; i < this.bundles.length; ++i) {
            if (this.bundles[i] == null || this.bundles[i].getItem(this.localeBundleNames[i], string) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object getResource(String string) {
        if (string == EVALUATING_KEY) {
            return this.evaluateStringValue;
        }
        this.getBundles();
        for (int i = 0; i < this.bundles.length; ++i) {
            Element.ItemElem itemElem;
            if (this.bundles[i] == null || (itemElem = this.bundles[i].getItem(this.localeBundleNames[i], string)) == null) continue;
            return itemElem.getValue();
        }
        return null;
    }

    @Override
    protected void putResource(String string, Object object) {
    }

    private static class ChangeInfo {
        private String[] originalData;
        private BundleStructure bundle;

        private ChangeInfo() {
        }

        static /* synthetic */ String[] access$102(ChangeInfo changeInfo, String[] stringArray) {
            changeInfo.originalData = stringArray;
            return stringArray;
        }
    }
}

