/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.IOException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbRenameRefactoringPlugin
extends AbstractRefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private RenameRefactoring rename;

    public NbRenameRefactoringPlugin(AbstractRefactoring abstractRefactoring) {
        super(abstractRefactoring);
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Lookup lookup;
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        try {
            Project project;
            AbstractRefactoringPlugin.InfoHolder infoHolder;
            this.rename = (RenameRefactoring)this.refactoring;
            Object var2_2 = null;
            lookup = this.rename.getRefactoringSource();
            TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
            if (treePathHandle != null) {
                infoHolder = this.examineLookup(lookup);
                project = FileOwnerQuery.getOwner((FileObject)treePathHandle.getFileObject());
                if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem = null;
                    return problem;
                }
                if (infoHolder.isClass) {
                    this.checkManifest(project, infoHolder.fullName, refactoringElementsBag);
                    this.checkLayer(project, infoHolder.fullName, refactoringElementsBag);
                }
                if (infoHolder.isMethod) {
                    this.checkMethodLayer(infoHolder, treePathHandle.getFileObject(), refactoringElementsBag);
                }
            }
            if ((infoHolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class)) != null) {
                SourceGroup[] sourceGroupArray;
                project = FileOwnerQuery.getOwner((FileObject)infoHolder.getFolder());
                if (project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem = null;
                    return problem;
                }
                Sources sources = ProjectUtils.getSources((Project)project);
                for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
                    if (!FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)infoHolder.getFolder())) continue;
                    String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)infoHolder.getFolder());
                    string.replace('/', '.');
                }
            }
            err.log("Gonna return problem: " + var2_2);
            project = var2_2;
            return project;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            lookup = null;
            return lookup;
        }
        finally {
            semafor.set(null);
        }
    }

    protected RefactoringElementImplementation createManifestRefactoring(String string, FileObject fileObject, String string2, String string3, String string4) {
        return new ManifestRenameRefactoringElement(string, fileObject, string3, string2, string4);
    }

    protected RefactoringElementImplementation createConstructorLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        return null;
    }

    protected RefactoringElementImplementation createLayerRefactoring(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
        return new LayerClassRefactoringElement(string, layerHandle, fileObject, string2);
    }

    protected RefactoringElementImplementation createMethodLayerRefactoring(String string, String string2, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string3) {
        return new LayerMethodRefactoringElement(string, layerHandle, fileObject, string3);
    }

    public final class ManifestRenameRefactoringElement
    extends AbstractRefactoringElement {
        private String attrName;
        private String sectionName = null;
        private String oldName;
        private String oldContent;
        private String newName;

        public ManifestRenameRefactoringElement(String string, FileObject fileObject, String string2, String string3) {
            this.name = string2;
            this.parentFile = fileObject;
            this.attrName = string3;
            this.oldName = string;
        }

        public ManifestRenameRefactoringElement(String string, FileObject fileObject, String string2, String string3, String string4) {
            this(string, fileObject, string2, string3);
            this.sectionName = string4;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbRenameRefactoringPlugin.class, (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbRenameRefactoringPlugin.class, (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
            String string;
            this.oldContent = string = Utility.readFileIntoString(this.parentFile);
            if (string != null) {
                String string2 = this.oldName.substring(this.oldName.lastIndexOf(".") + 1);
                if (this.newName == null) {
                    this.newName = NbRenameRefactoringPlugin.this.rename.getNewName();
                    this.newName = this.newName.replace('.', '/') + ".class";
                }
                string2 = string2 + ".class";
                string = string.replaceAll(string2, this.newName);
                Utility.writeFileFromString(this.parentFile, string);
            }
        }

        public void undoChange() {
            if (this.oldContent != null) {
                Utility.writeFileFromString(this.parentFile, this.oldContent);
            }
        }
    }

    public final class LayerClassRefactoringElement
    extends LayerAbstractRefactoringElement {
        private String fqname;
        private String newAttrName;
        private String newAttrValue;
        private String newFileName;

        public LayerClassRefactoringElement(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
            super(layerHandle, fileObject, string2);
            this.fqname = string;
        }

        public String getDisplayText() {
            if (this.newFileName != null) {
                return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerFileRename", (Object)this.oldFileName, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performChange() {
            String string = this.fqname.substring(this.fqname.lastIndexOf(46) + 1);
            if (this.oldAttrName == null) {
                this.newFileName = this.oldFileName.replaceAll("\\-" + string + "$", "-" + NbRenameRefactoringPlugin.this.rename.getNewName());
            } else if (this.oldAttrName.indexOf(this.fqname.replace('.', '-') + ".instance") > 0) {
                this.newAttrName = this.oldAttrName.replaceAll("-" + string + "\\.", "-" + NbRenameRefactoringPlugin.this.rename.getNewName() + ".");
            } else if (this.oldAttrValue != null) {
                String string2 = string;
                this.newAttrValue = this.oldAttrValue.replaceAll(string2, NbRenameRefactoringPlugin.this.rename.getNewName());
            }
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.newAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.oldAttrName, this.newAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.newFileName);
            }
        }

        public void undoChange() {
            if (this.newAttrValue != null) {
                this.doAttributeValueChange(this.oldAttrValue, this.valueType);
            }
            if (this.newAttrName != null) {
                this.doAttributeMove(this.newAttrName, this.oldAttrName);
            }
            if (this.newFileName != null) {
                this.doFileMove(this.oldFileName);
            }
        }
    }

    public final class LayerMethodRefactoringElement
    extends LayerAbstractRefactoringElement {
        private String newAttrValue;
        private String method;

        public LayerMethodRefactoringElement(String string, LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string2) {
            super(layerHandle, fileObject, string2);
            this.method = string;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TXT_LayerMethodRename", (Object)this.oldAttrValue, (Object)NbRenameRefactoringPlugin.this.rename.getNewName());
        }

        public void performChange() {
            this.newAttrValue = this.oldAttrValue.replaceAll("\\." + this.method + "$", "." + NbRenameRefactoringPlugin.this.rename.getNewName());
            this.doAttributeValueChange(this.newAttrValue, this.valueType);
        }

        public void undoChange() {
            this.doAttributeValueChange(this.oldAttrValue, this.valueType);
        }
    }

    public abstract class LayerAbstractRefactoringElement
    extends AbstractRefactoringElement {
        protected FileObject layerFile;
        protected LayerUtils.LayerHandle handle;
        protected String oldFileName;
        protected String oldAttrName;
        protected String oldAttrValue;
        protected String valueType;

        public LayerAbstractRefactoringElement(LayerUtils.LayerHandle layerHandle, FileObject fileObject, String string) {
            this.layerFile = fileObject;
            this.parentFile = layerHandle.getLayerFile();
            this.handle = layerHandle;
            this.oldFileName = fileObject.getName();
            this.oldAttrName = string;
            if (string != null) {
                Object object = fileObject.getAttribute("literal:" + string);
                if (object == null) {
                    throw new IllegalStateException();
                }
                if (object instanceof String) {
                    this.oldAttrValue = (String)object;
                    if (this.oldAttrValue.startsWith("new:")) {
                        this.oldAttrValue = ((String)object).substring("new:".length());
                        this.valueType = "newvalue:";
                    } else if (this.oldAttrValue.startsWith("method:")) {
                        this.oldAttrValue = ((String)object).substring("method:".length());
                        this.valueType = "methodvalue:";
                    }
                }
            }
        }

        protected void doAttributeValueChange(String string, String string2) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            try {
                this.layerFile.setAttribute(this.oldAttrName, (Object)((string2 != null ? string2 : "") + string));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }

        protected void doAttributeMove(String string, String string2) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            try {
                Object object = this.layerFile.getAttribute(string);
                this.layerFile.setAttribute(string, null);
                this.layerFile.setAttribute(string2, object);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doFileMove(String string) {
            boolean bl = this.handle.isAutosave();
            if (!bl) {
                this.handle.setAutosave(true);
            }
            FileLock fileLock = null;
            try {
                fileLock = this.layerFile.lock();
                this.layerFile.rename(fileLock, string, this.layerFile.getExt());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            if (!bl) {
                this.handle.setAutosave(false);
            }
        }
    }
}

