/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Toolkit;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.cnd.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    public boolean canFindUsages(Lookup lookup) {
        CsmObject csmObject = CsmRefactoringUtils.findContextObject(lookup);
        return CsmRefactoringUtils.isSupportedReference(csmObject);
    }

    public void doFindUsages(Lookup lookup) {
        Runnable runnable = RefactoringActionsProvider.isFromEditor(lookup) ? new TextComponentTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, CsmContext csmContext) {
                return new WhereUsedQueryUI(csmObject);
            }
        } : new NodeToElementTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return new WhereUsedQueryUI(csmObject);
            }
        };
        runnable.run();
    }

    public boolean canRename(Lookup lookup) {
        CsmObject csmObject;
        if (CsmModelAccessor.getModelState() != CsmModelState.ON) {
            return false;
        }
        HashSet hashSet = new HashSet(lookup.lookupAll(Node.class));
        return hashSet.size() == 1 && CsmRefactoringUtils.isSupportedReference(csmObject = CsmRefactoringUtils.findContextObject(lookup));
    }

    public void doRename(Lookup lookup) {
        Runnable runnable = RefactoringActionsProvider.isFromEditor(lookup) ? new TextComponentTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject, CsmContext csmContext) {
                return new RenameRefactoringUI(csmObject);
            }
        } : new NodeToElementTask(lookup){

            protected RefactoringUI createRefactoringUI(CsmObject csmObject) {
                return new RenameRefactoringUI(csmObject);
            }
        };
        runnable.run();
    }

    static boolean isFromEditor(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        return editorCookie != null && editorCookie.getOpenedPanes() != null;
    }

    static abstract class NodeToElementTask
    implements Runnable {
        private Lookup context;
        private RefactoringUI ui;

        public NodeToElementTask(Lookup lookup) {
            this.context = lookup;
        }

        public void cancel() {
        }

        public final void run() {
            CsmObject csmObject = CsmRefactoringUtils.findContextObject(this.context);
            if (!CsmRefactoringUtils.isSupportedReference(csmObject)) {
                return;
            }
            this.ui = this.createRefactoringUI(csmObject);
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)topComponent);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1);
    }

    static abstract class TextComponentTask
    implements Runnable {
        private RefactoringUI ui;
        private Lookup lookup;
        private final CsmContext editorContext;

        public TextComponentTask(Lookup lookup) {
            this.lookup = lookup;
            this.editorContext = CsmContext.create(lookup);
        }

        public final void run() {
            CsmObject csmObject = CsmRefactoringUtils.findContextObject(this.lookup);
            if (csmObject == null && this.editorContext == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            this.ui = this.createRefactoringUI(csmObject, this.editorContext);
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)topComponent);
            } else {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRefactorLoc"));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(CsmObject var1, CsmContext var2);
    }
}

