/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class ElementNode
extends AbstractNode {
    private Description description;
    private boolean singleSelection;
    private static final Action[] EMPTY_ACTIONS = new Action[0];

    public ElementNode(Description description) {
        this(description, false);
    }

    private ElementNode(Description description, boolean bl) {
        super((Children)(description.subs == null ? Children.LEAF : new ElementChilren(description.subs, bl)), Lookups.singleton((Object)description));
        this.description = description;
        description.node = this;
        this.setDisplayName(description.name);
    }

    public void setSingleSelection(boolean bl) {
        this.singleSelection = bl;
    }

    public Image getIcon(int n) {
        if (this.description.elementHandle == null) {
            return super.getIcon(n);
        }
        return ImageUtilities.icon2Image((Icon)CsmImageLoader.getIcon((CsmObject)this.description.elementHandle));
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getDisplayName() {
        return this.description.name;
    }

    public String getHtmlDisplayName() {
        return this.description.htmlHeader;
    }

    public Action[] getActions(boolean bl) {
        return EMPTY_ACTIONS;
    }

    public void assureSingleSelection() {
        Description description;
        Node node = this.getParentNode();
        if (node == null && this.singleSelection) {
            this.description.deepSetSelected(false);
        } else if (node != null && (description = (Description)node.getLookup().lookup(Description.class)) != null) {
            description.node.assureSingleSelection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Description {
        public static final Comparator<Description> ALPHA_COMPARATOR = new DescriptionComparator();
        private ElementNode node;
        private String name;
        private CsmDeclaration elementHandle;
        private Set<CsmVisibility> modifiers;
        private List<Description> subs;
        private String htmlHeader;
        private boolean isSelected;
        private boolean isSelectable;

        public static Description create(List<Description> list) {
            return new Description("<root>", null, null, list, null, false, false);
        }

        public static Description create(CsmDeclaration csmDeclaration, List<Description> list, boolean bl, boolean bl2) {
            String string = ((Object)csmDeclaration.getName()).toString();
            if (CsmKindUtilities.isVariable((CsmObject)csmDeclaration)) {
                CsmField csmField = (CsmField)csmDeclaration;
                string = ((Object)csmField.getName()).toString() + " : " + csmField.getType().getText();
            } else if (CsmKindUtilities.isFunction((CsmObject)csmDeclaration)) {
                CsmMethod csmMethod = (CsmMethod)csmDeclaration;
                string = csmMethod.getSignature() + " : " + csmMethod.getReturnType().getText();
            }
            return new Description(((Object)csmDeclaration.getName()).toString(), csmDeclaration, Collections.<CsmVisibility>emptySet(), list, string, bl, bl2);
        }

        private Description(String string, CsmDeclaration csmDeclaration, Set<CsmVisibility> set, List<Description> list, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.elementHandle = csmDeclaration;
            this.modifiers = set;
            this.subs = list;
            this.htmlHeader = string2;
            this.isSelectable = bl;
            this.isSelected = bl2;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public boolean hasSelectableSubs() {
            if (null == this.subs) {
                return false;
            }
            for (Description description : this.getSubs()) {
                if (!description.isSelectable()) continue;
                return true;
            }
            return false;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public List<Description> getSubs() {
            return this.subs;
        }

        public void setSelected(boolean bl) {
            if (bl && this.node != null) {
                this.node.assureSingleSelection();
            }
            this.isSelected = bl;
            if (this.node != null) {
                this.node.fireDisplayNameChange(null, null);
            }
        }

        public void deepSetSelected(boolean bl) {
            if (this.isSelectable() && bl != this.isSelected()) {
                this.setSelected(bl);
            }
            if (this.subs != null) {
                for (Description description : this.subs) {
                    description.deepSetSelected(bl);
                }
            }
        }

        public CsmDeclaration getElementHandle() {
            return this.elementHandle;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Description)) {
                return false;
            }
            Description description = (Description)object;
            if (!this.name.equals(description.name)) {
                return false;
            }
            if (this.elementHandle != description.elementHandle) {
                if (this.elementHandle == null || description.elementHandle == null) {
                    return false;
                }
                if (this.elementHandle.getKind() != description.elementHandle.getKind()) {
                    return false;
                }
                if (!this.elementHandle.equals(description.elementHandle)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.name != null ? this.name.hashCode() : 0);
            n = 29 * n + (this.elementHandle != null ? this.elementHandle.getKind().hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.name + " " + this.isSelected;
        }

        public String getName() {
            return this.name;
        }

        public static Description deepCopy(Description description) {
            ArrayList<Description> arrayList;
            if (description.subs == null) {
                arrayList = null;
            } else {
                arrayList = new ArrayList<Description>(description.subs.size());
                for (Description description2 : description.subs) {
                    arrayList.add(Description.deepCopy(description2));
                }
            }
            return new Description(description.name, description.elementHandle, description.modifiers, arrayList, description.htmlHeader, description.isSelectable, description.isSelected);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DescriptionComparator
        implements Comparator<Description> {
            private DescriptionComparator() {
            }

            @Override
            public int compare(Description description, Description description2) {
                if (this.k2i(description.elementHandle.getKind()) != this.k2i(description2.elementHandle.getKind())) {
                    return this.k2i(description.elementHandle.getKind()) - this.k2i(description2.elementHandle.getKind());
                }
                return description.name.compareTo(description2.name);
            }

            int k2i(CsmDeclaration.Kind kind) {
                switch (kind) {
                    case FUNCTION: {
                        return 1;
                    }
                    case FUNCTION_DEFINITION: {
                        return 2;
                    }
                    case VARIABLE: 
                    case VARIABLE_DEFINITION: {
                        return 3;
                    }
                    case CLASS: {
                        return 4;
                    }
                    case STRUCT: {
                        return 5;
                    }
                    case UNION: {
                        return 6;
                    }
                    case ENUM: {
                        return 7;
                    }
                }
                return 100;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementChilren
    extends Children.Keys<Description> {
        public ElementChilren(List<Description> list, boolean bl) {
            if (bl) {
                Collections.sort(list, Description.ALPHA_COMPARATOR);
            }
            this.setKeys(list);
        }

        protected Node[] createNodes(Description description) {
            return new Node[]{new ElementNode(description, true)};
        }
    }
}

