/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.HintAction;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceHint;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceKind;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IntroduceAction
extends HintAction {
    private IntroduceKind type;
    private static String INTRODUCE_CONSTANT = "introduce-constant";
    private static String INTRODUCE_VARIABLE = "introduce-variable";
    private static String INTRODUCE_METHOD = "introduce-method";
    private static String INTRODUCE_FIELD = "introduce-field";

    private IntroduceAction(IntroduceKind introduceKind) {
        this.type = introduceKind;
        this.putValue("Name", IntroduceAction.getActionName(introduceKind));
        String string = IntroduceAction.getMenuItemText(introduceKind);
        this.putValue("ShortDescription", string);
        this.putValue("PopupMenuText", string);
        this.putValue("menuText", string);
    }

    protected void perform(CsmContext csmContext) {
        String string = this.doPerformAction(csmContext);
        if (string != null) {
            String string2 = NbBundle.getMessage(IntroduceAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    private String doPerformAction(CsmContext csmContext) {
        EnumMap<IntroduceKind, Fix> enumMap = new EnumMap<IntroduceKind, Fix>(IntroduceKind.class);
        EnumMap<IntroduceKind, String> enumMap2 = new EnumMap<IntroduceKind, String>(IntroduceKind.class);
        try {
            IntroduceHint.computeError(csmContext, enumMap, enumMap2, new AtomicBoolean());
            Fix fix = (Fix)enumMap.get((Object)this.type);
            if (fix != null) {
                fix.implement();
                return null;
            }
            String string = (String)enumMap2.get((Object)this.type);
            if (string != null) {
                return string;
            }
            return "ERR_Invalid_Selection";
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(IntroduceKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(IntroduceKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(IntroduceKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(IntroduceKind.CREATE_METHOD);
    }

    private static String getActionName(IntroduceKind introduceKind) {
        switch (introduceKind) {
            case CREATE_CONSTANT: {
                return INTRODUCE_CONSTANT;
            }
            case CREATE_VARIABLE: {
                return INTRODUCE_VARIABLE;
            }
            case CREATE_FIELD: {
                return INTRODUCE_FIELD;
            }
            case CREATE_METHOD: {
                return INTRODUCE_METHOD;
            }
        }
        return null;
    }

    private static String getMenuItemText(IntroduceKind introduceKind) {
        switch (introduceKind) {
            case CREATE_CONSTANT: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction");
            }
            case CREATE_VARIABLE: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction");
            }
            case CREATE_FIELD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction");
            }
            case CREATE_METHOD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction");
            }
        }
        return null;
    }
}

