/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.editor.api.FormattingSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldRefactoringPlugin
extends CsmModificationRefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(EncapsulateFieldRefactoringPlugin.class.getName());
    private Collection<CsmObject> referencedObjects;
    private CsmClass fieldEncloser;
    private CsmVisibility fieldEncloserAccessibility = CsmVisibility.PUBLIC;
    private CsmVisibility fieldAccessibility;
    private CsmMethod currentGetter;
    private CsmMethod currentSetter;
    private static Set<CsmVisibility> accessModifiers = EnumSet.of(CsmVisibility.PRIVATE, CsmVisibility.PROTECTED, CsmVisibility.PUBLIC);
    private static List<CsmVisibility> MODIFIERS = Arrays.asList(CsmVisibility.PRIVATE, null, CsmVisibility.PROTECTED, CsmVisibility.PUBLIC);
    private final EncapsulateFieldRefactoring refactoring;
    public static final String CLASS_FIELD_PREFIX = "_";
    private CsmObject sourceType;

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring encapsulateFieldRefactoring) {
        super(encapsulateFieldRefactoring);
        this.refactoring = encapsulateFieldRefactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 2);
        try {
            CsmField csmField = this.refactoring.getSourceField();
            Problem problem = this.checkIfModificationPossible(null, (CsmObject)csmField, "", "");
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            this.fieldEncloser = csmField.getContainingClass();
            this.fieldAccessibility = csmField.getVisibility();
            Problem problem3 = problem;
            return problem3;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        return this.fastCheckParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName());
    }

    @Override
    public Problem checkParameters() {
        Problem problem = null;
        CsmField csmField = this.refactoring.getSourceField();
        CsmClass csmClass = csmField.getContainingClass();
        String string = this.refactoring.getGetterName();
        String string2 = this.refactoring.getSetterName();
        CsmMethod csmMethod = null;
        CsmMethod csmMethod2 = null;
        if (string != null) {
            csmMethod = EncapsulateFieldRefactoringPlugin.findMethod(csmClass, string, Collections.emptyList(), true);
        }
        if (csmMethod != null) {
            if (!GeneratorUtils.isSameType(csmField.getType(), csmMethod.getReturnType())) {
                String string3 = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongGetter", (Object)string, (Object)csmMethod.getReturnType().getCanonicalText());
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, false, string3);
            }
            if (csmClass.equals(csmMethod.getContainingClass())) {
                this.currentGetter = csmMethod;
            }
        }
        if (string2 != null) {
            csmMethod2 = EncapsulateFieldRefactoringPlugin.findMethod(csmClass, string2, Collections.singletonList(csmField), true);
        }
        if (csmMethod2 != null) {
            if (GeneratorUtils.getTypeKind(csmMethod2.getReturnType()) != GeneratorUtils.TypeKind.VOID) {
                problem = EncapsulateFieldRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongSetter", (Object)string2, (Object)csmMethod2.getReturnType().getCanonicalText()));
            }
            if (csmClass.equals(csmMethod2.getContainingClass())) {
                this.currentSetter = csmMethod2;
            }
        }
        return problem;
    }

    private void addDiff(GeneratorUtils.InsertInfo insertInfo, CharSequence charSequence, String string, String string2, ModificationResult modificationResult, FileObject fileObject) throws MissingResourceException {
        CharSequence charSequence2 = FormattingSupport.getFormattedText((Document)this.getDoc(insertInfo.ces), (int)insertInfo.dot, (CharSequence)charSequence);
        String string3 = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)string2, (Object)string);
        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, insertInfo.start, insertInfo.end, string2, "\n" + charSequence2, string3);
        modificationResult.addDifference(fileObject, difference);
    }

    private Problem fastCheckParameters(String string, String string2) {
        if (string != null && !CndLexerUtilities.isCppIdentifier((CharSequence)string) || string2 != null && !CndLexerUtilities.isCppIdentifier((CharSequence)string2) || string == null && string2 == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    private FieldAccessInfo prepareFieldAccessInfo(final CsmReference csmReference, final Document document) {
        final FieldAccessTokenProcessor fieldAccessTokenProcessor = new FieldAccessTokenProcessor(csmReference.getStartOffset(), document);
        if (document != null) {
            document.render(new Runnable(){

                public void run() {
                    try {
                        int n = CndTokenUtilities.getLastCommandSeparator((Document)document, (int)csmReference.getStartOffset());
                        CndTokenUtilities.processTokens((CndTokenProcessor)fieldAccessTokenProcessor, (Document)document, (int)n, (int)document.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        return fieldAccessTokenProcessor.getFieldAccessInfo();
    }

    public static CsmMethod findMethod(CsmClass csmClass, String string, Collection<? extends CsmVariable> collection, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        CsmClass csmClass2 = csmClass;
        for (CsmMember csmMember : csmClass2.getMembers()) {
            CsmMethod csmMethod;
            if (!CsmKindUtilities.isMethod((CsmObject)csmMember) || !string.contentEquals((csmMethod = (CsmMethod)csmMember).getName()) || !EncapsulateFieldRefactoringPlugin.compareParams(collection, csmMethod.getParameters())) continue;
            return csmMethod;
        }
        return null;
    }

    private static boolean compareParams(Collection<? extends CsmVariable> collection, Collection<? extends CsmVariable> collection2) {
        if (collection.size() == collection2.size()) {
            Iterator<? extends CsmVariable> iterator = collection.iterator();
            for (CsmVariable csmVariable : collection2) {
                CsmVariable csmVariable2 = iterator.next();
                CsmType csmType = csmVariable.getType();
                CsmType csmType2 = csmVariable2.getType();
                if ((csmType != null || csmType2 != null) && GeneratorUtils.isSameType(csmType, csmType2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        return Collections.emptySet();
    }

    @Override
    protected void processFile(CsmFile csmFile, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        Object object;
        Object object2;
        EncapsulateFieldPanel.InsertPoint insertPoint = (EncapsulateFieldPanel.InsertPoint)this.refactoring.getContext().lookup(EncapsulateFieldPanel.InsertPoint.class);
        CsmField csmField = this.refactoring.getSourceField();
        CsmFile csmFile2 = this.refactoring.getClassDeclarationFile();
        CsmFile csmFile3 = this.refactoring.getClassDefinitionFile();
        CloneableEditorSupport cloneableEditorSupport = null;
        FileObject fileObject = null;
        String string = this.refactoring.getGetterName();
        String string2 = this.refactoring.getSetterName();
        if ((string != null && this.refactoring.getDefaultGetter() == null || string2 != null && this.refactoring.getDefaultSetter() == null) && (csmFile.equals(csmFile2) || csmFile.equals(csmFile3))) {
            String string3;
            GeneratorUtils.InsertInfo insertInfo;
            DeclarationGenerator.Kind kind;
            fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
            object2 = this.refactoring.getEnclosingClass();
            object = GeneratorUtils.getInsertPositons(null, (CsmClass)object2, insertPoint);
            if (csmFile.equals(csmFile2)) {
                kind = this.refactoring.isMethodInline() ? DeclarationGenerator.Kind.INLINE_DEFINITION : DeclarationGenerator.Kind.DECLARATION;
                insertInfo = object[0];
                if (string != null && this.refactoring.getDefaultGetter() == null) {
                    string3 = DeclarationGenerator.createGetter(csmField, string, kind);
                    this.addDiff(insertInfo, string3, string, this.refactoring.isMethodInline() ? "EncapsulateFieldInlineDefinition" : "EncapsulateFieldInsertDeclartion", modificationResult, fileObject);
                }
                if (string2 != null && this.refactoring.getDefaultSetter() == null) {
                    string3 = DeclarationGenerator.createSetter(csmField, string2, kind);
                    this.addDiff(insertInfo, string3, string2, this.refactoring.isMethodInline() ? "EncapsulateFieldInlineDefinition" : "EncapsulateFieldInsertDeclartion", modificationResult, fileObject);
                }
            }
            if (!this.refactoring.isMethodInline() && csmFile.equals(csmFile3)) {
                kind = DeclarationGenerator.Kind.EXTERNAL_DEFINITION;
                insertInfo = object[1];
                if (string != null && this.refactoring.getDefaultGetter() == null) {
                    string3 = DeclarationGenerator.createGetter(csmField, string, kind);
                    this.addDiff(insertInfo, string3, string, "EncapsulateFieldInsertDefinition", modificationResult, fileObject);
                }
                if (string2 != null && this.refactoring.getDefaultSetter() == null) {
                    string3 = DeclarationGenerator.createSetter(csmField, string2, kind);
                    this.addDiff(insertInfo, string3, string2, "EncapsulateFieldInsertDefinition", modificationResult, fileObject);
                }
            }
        }
        if (this.refactoring.isAlwaysUseAccessors()) {
            fileObject = fileObject != null ? fileObject : CsmUtilities.getFileObject((CsmFile)csmFile);
            cloneableEditorSupport = cloneableEditorSupport != null ? cloneableEditorSupport : CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            object2 = CsmReferenceRepository.getDefault().getReferences((CsmObject)csmField, csmFile, CsmReferenceKind.ALL, null);
            if (object2.size() > 0) {
                object = new ArrayList(object2);
                Collections.sort(object, new Comparator<CsmReference>(){

                    @Override
                    public int compare(CsmReference csmReference, CsmReference csmReference2) {
                        return csmReference.getStartOffset() - csmReference2.getStartOffset();
                    }
                });
                this.processRefactoredReferences((List<CsmReference>)object, fileObject, cloneableEditorSupport, modificationResult, atomicReference);
            }
        }
    }

    private Document getDoc(CloneableEditorSupport cloneableEditorSupport) {
        StyledDocument styledDocument = null;
        try {
            try {
                styledDocument = cloneableEditorSupport.openDocument();
            }
            catch (UserQuestionException userQuestionException) {
                userQuestionException.confirmed();
                styledDocument = cloneableEditorSupport.openDocument();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return styledDocument;
    }

    private void processRefactoredReferences(List<CsmReference> list, FileObject fileObject, CloneableEditorSupport cloneableEditorSupport, ModificationResult modificationResult, AtomicReference<Problem> atomicReference) {
        for (CsmReference csmReference : list) {
            CsmObject csmObject = CsmRefactoringUtils.getEnclosingElement((CsmObject)csmReference);
            if (CsmKindUtilities.isFunction((CsmObject)csmObject) && !CsmKindUtilities.isConstructor((CsmObject)csmObject) && CsmKindUtilities.isDestructor((CsmObject)csmObject) && !csmObject.equals(this.refactoring.getDefaultGetter()) && csmObject.equals(this.refactoring.getDefaultSetter())) continue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldAccessTokenProcessor
    implements CndTokenProcessor<Token<CppTokenId>> {
        private State state = State.START;
        private BlockConsumer blockConsumer;
        private final int refStartPos;
        private final FieldAccessInfo fldInfo = new FieldAccessInfo();
        private final Document doc;
        private Boolean inPP = null;
        private int curParamStartOffset = -1;

        private FieldAccessTokenProcessor(int n, Document document) {
            this.doc = document;
            this.refStartPos = n;
        }

        public boolean isStopped() {
            return this.state == State.END;
        }

        public FieldAccessInfo getFieldAccessInfo() {
            return this.fldInfo;
        }

        public boolean token(Token<CppTokenId> token, int n) {
            if (this.blockConsumer != null) {
                if (this.blockConsumer.isLastToken(token)) {
                    this.blockConsumer = null;
                }
                return false;
            }
            if (this.inPP == null) {
                if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.inPP = Boolean.TRUE;
                    return true;
                }
                this.inPP = Boolean.FALSE;
            } else if (this.inPP == Boolean.FALSE && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return false;
            }
            switch (this.state) {
                case START: {
                    if (n != this.refStartPos) break;
                    this.state = State.AFTER_FIELD_ACCESS;
                    this.fldInfo.startOffset = n;
                    this.fldInfo.origParamsText = token.text();
                    break;
                }
                case AFTER_FIELD_ACCESS: {
                    this.afterFieldAccess(token, n);
                }
            }
            return false;
        }

        private void afterFieldAccess(Token<CppTokenId> token, int n) {
            if (!this.isWS(token)) {
                switch ((CppTokenId)token.id()) {
                    case LPAREN: {
                        this.blockConsumer = new BlockConsumer(CppTokenId.LT, CppTokenId.GT);
                        break;
                    }
                    case SEMICOLON: 
                    case RPAREN: {
                        this.state = State.END;
                        break;
                    }
                    case EQ: {
                        this.state = State.LVALUE;
                    }
                }
            }
        }

        private boolean isWS(Token<CppTokenId> token) {
            switch ((CppTokenId)token.id()) {
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case LINE_COMMENT: 
                case ESCAPED_LINE: 
                case ESCAPED_WHITESPACE: {
                    return true;
                }
            }
            return false;
        }

        public void start(int n, int n2, int n3) {
        }

        public void end(int n, int n2) {
            if (this.fldInfo.startOffset != this.fldInfo.endOffset) {
                try {
                    this.fldInfo.origParamsText = this.doc.getText(this.fldInfo.startOffset, this.fldInfo.endOffset - this.fldInfo.startOffset);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class BlockConsumer {
            private final CppTokenId openBracket;
            private final CppTokenId closeBracket;
            private int depth;

            public BlockConsumer(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
                this.openBracket = cppTokenId;
                this.closeBracket = cppTokenId2;
                this.depth = 0;
            }

            public boolean isLastToken(Token<CppTokenId> token) {
                boolean bl = false;
                if (token.id() == this.openBracket) {
                    ++this.depth;
                } else if (token.id() == this.closeBracket) {
                    --this.depth;
                    bl = this.depth <= 0;
                }
                return bl;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            START,
            AFTER_FIELD_ACCESS,
            LVALUE,
            END;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FieldAccessInfo {
        private int startOffset = -1;
        private int endOffset = -1;
        private CharSequence origParamsText = "";
        private List<CharSequence> paramText = new ArrayList<CharSequence>();

        private FieldAccessInfo() {
        }

        public CharSequence getOriginalParamsText() {
            return this.origParamsText;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public List<CharSequence> getParametersText() {
            return this.paramText;
        }

        private void addParam(String string) {
            this.paramText.add(string);
        }

        public void setStartOffsetIfNeeded(int n) {
            if (this.startOffset < 0) {
                this.startOffset = n;
                this.endOffset = n;
            }
        }

        private boolean hasParam(int n) {
            return n < this.paramText.size();
        }

        private CharSequence getParameter(int n) {
            return this.paramText.get(n);
        }

        private boolean isValid() {
            return this.endOffset > this.startOffset;
        }

        private void setEndOffset(int n) {
            this.endOffset = n;
        }

        public String toString() {
            return this.origParamsText + "[" + this.startOffset + "-" + this.endOffset + "] params:" + this.paramText;
        }
    }
}

