/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmContext {
    private final CsmFile file;
    private final Document doc;
    private final FileObject fo;
    private final int startOffset;
    private final int endOffset;
    private final int caretOffset;
    private final CsmReference csmReference;
    private List<CsmObject> path = null;
    private CsmClass enclosingClass = null;
    private CsmNamespaceDefinition enclosingNS = null;
    private CsmFunction enclosingFun = null;
    private CsmOffsetable objectUnderOffset = null;

    private CsmContext(CsmFile csmFile, CsmReference csmReference, FileObject fileObject, Document document, int n, int n2, int n3) {
        this.file = csmFile;
        this.fo = fileObject;
        this.doc = document;
        this.startOffset = n;
        this.endOffset = n2;
        this.caretOffset = n3;
        this.csmReference = csmReference;
    }

    public static CsmContext create(Document document, int n, int n2, int n3) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)false);
        if (csmFile != null) {
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(document, n3);
            return new CsmContext(csmFile, csmReference, CsmUtilities.getFileObject((Document)document), document, n, n2, n3);
        }
        return null;
    }

    public static CsmContext create(CsmFile csmFile, int n) {
        DataObject dataObject = CsmUtilities.getDataObject((CsmFile)csmFile);
        Document document = CsmContext.getDocument(dataObject);
        if (document != null) {
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(document, n);
            return new CsmContext(csmFile, csmReference, CsmUtilities.getFileObject((Document)document), document, n, n, n);
        }
        return null;
    }

    private static Document getDocument(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            throw new IllegalStateException("Given file (\"" + dataObject.getName() + "\") does not have EditorCookie.");
        }
        StyledDocument styledDocument = null;
        try {
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (UserQuestionException userQuestionException) {
                userQuestionException.confirmed();
                styledDocument = editorCookie.openDocument();
            }
        }
        catch (IOException iOException) {
            styledDocument = null;
        }
        return styledDocument;
    }

    public static CsmContext create(Lookup lookup) {
        EditorCookie editorCookie;
        JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
        if (jTextComponent == null) {
            JEditorPane[] jEditorPaneArray;
            editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
            JEditorPane[] jEditorPaneArray2 = jEditorPaneArray = editorCookie == null ? null : CsmUtilities.getOpenedPanesInEQ((EditorCookie)editorCookie);
            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                jTextComponent = jEditorPaneArray[0];
            }
        }
        if (jTextComponent != null && (editorCookie = CsmUtilities.getCsmFile((JTextComponent)jTextComponent, (boolean)false)) != null) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            int n3 = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            FileObject fileObject = CsmUtilities.getFileObject((Document)document);
            CsmReference csmReference = CsmReferenceResolver.getDefault().findReference(document, n3);
            return new CsmContext((CsmFile)editorCookie, csmReference, fileObject, document, n, n2, n3);
        }
        return null;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public CsmReference getCsmReferenceUnderOffset() {
        return this.csmReference;
    }

    public Document getDocument() {
        return this.doc;
    }

    public CsmFile getFile() {
        return this.file;
    }

    public List<CsmObject> getPath() {
        this.initPath();
        return this.path;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String toString() {
        return "context: [" + this.file + ":" + this.startOffset + ", " + this.endOffset + "]";
    }

    public CsmClass getEnclosingClass() {
        this.initPath();
        return this.enclosingClass;
    }

    public CsmFunction getEnclosingFunction() {
        this.initPath();
        return this.enclosingFun;
    }

    public CsmNamespaceDefinition getEnclosingNamespace() {
        this.initPath();
        return this.enclosingNS;
    }

    public CsmOffsetable getObjectUnderOffset() {
        this.initPath();
        return this.objectUnderOffset;
    }

    private Iterator<? extends CsmObject> getInnerObjectsIterator(CsmSelect.CsmFilter csmFilter, CsmScope csmScope) {
        Iterator iterator = Collections.emptyList().iterator();
        iterator = CsmKindUtilities.isFile((CsmObject)csmScope) ? CsmSelect.getDeclarations((CsmFile)((CsmFile)csmScope), (CsmSelect.CsmFilter)csmFilter) : (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmScope) ? CsmSelect.getDeclarations((CsmNamespaceDefinition)((CsmNamespaceDefinition)csmScope), (CsmSelect.CsmFilter)csmFilter) : (CsmKindUtilities.isClass((CsmObject)csmScope) ? CsmSelect.getClassMembers((CsmClass)((CsmClass)csmScope), (CsmSelect.CsmFilter)csmFilter) : csmScope.getScopeElements().iterator()));
        return iterator;
    }

    private synchronized void initPath() {
        CsmObject csmObject;
        if (this.path != null) {
            return;
        }
        this.path = new ArrayList<CsmObject>(5);
        this.path.add((CsmObject)this.file);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(this.startOffset);
        Iterator<? extends CsmObject> iterator = this.getInnerObjectsIterator(csmFilter, (CsmScope)this.file);
        CsmObject csmObject2 = csmObject = iterator.hasNext() ? iterator.next() : null;
        if (csmObject != null) {
            this.path.add(csmObject);
            this.rememberObject(csmObject);
            if (CsmKindUtilities.isScope((CsmObject)csmObject)) {
                boolean bl;
                CsmScope csmScope = (CsmScope)csmObject;
                block0: do {
                    bl = false;
                    Iterator<? extends CsmObject> iterator2 = this.getInnerObjectsIterator(csmFilter, csmScope);
                    while (iterator2.hasNext()) {
                        CsmObject csmObject3 = iterator2.next();
                        if (!CsmKindUtilities.isOffsetable((Object)csmObject3)) continue;
                        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject3;
                        if (this.startOffset < csmOffsetable.getStartOffset()) continue block0;
                        if (this.startOffset >= csmOffsetable.getEndOffset()) continue;
                        bl = true;
                        this.path.add((CsmObject)csmOffsetable);
                        this.rememberObject((CsmObject)csmOffsetable);
                        if (CsmKindUtilities.isScope((CsmObject)csmOffsetable)) {
                            csmScope = (CsmScope)csmOffsetable;
                            continue block0;
                        }
                        this.objectUnderOffset = csmOffsetable;
                        bl = false;
                    }
                } while (bl);
            }
        }
    }

    private void rememberObject(CsmObject csmObject) {
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmObject)) {
            this.enclosingNS = (CsmNamespaceDefinition)csmObject;
        } else if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
            this.enclosingClass = (CsmClass)csmObject;
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            this.enclosingFun = (CsmFunction)csmObject;
        }
    }
}

