/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;

public abstract class ComponentProducer {
    private String producerID;
    private TypeID typeID;
    private PaletteDescriptor paletteDescriptor;

    protected ComponentProducer(String string, TypeID typeID, PaletteDescriptor paletteDescriptor) {
        assert (string != null && typeID != null && paletteDescriptor != null);
        this.producerID = string;
        this.typeID = typeID;
        this.paletteDescriptor = paletteDescriptor;
    }

    public final String getProducerID() {
        return this.producerID;
    }

    public final TypeID getMainComponentTypeID() {
        return this.typeID;
    }

    public final PaletteDescriptor getPaletteDescriptor() {
        return this.paletteDescriptor;
    }

    public final Result createComponent(DesignDocument designDocument) {
        DesignComponent designComponent = this.createMainComponent(designDocument);
        assert (designComponent != null);
        Result result = this.postInitialize(designDocument, designComponent);
        assert (result != null);
        assert (result.getMainComponent() == designComponent);
        return result;
    }

    protected DesignComponent createMainComponent(DesignDocument designDocument) {
        return designDocument.createComponent(this.getMainComponentTypeID());
    }

    public Result postInitialize(DesignDocument designDocument, DesignComponent designComponent) {
        return new Result(designComponent);
    }

    public abstract Boolean checkValidity(DesignDocument var1, boolean var2);

    static ComponentProducer createDefault(ComponentDescriptor componentDescriptor) {
        PaletteDescriptor paletteDescriptor = componentDescriptor.getPaletteDescriptor();
        TypeID typeID = componentDescriptor.getTypeDescriptor().getThisType();
        if (paletteDescriptor == null) {
            return null;
        }
        return new ComponentProducer(typeID.toString(), typeID, paletteDescriptor){

            public Boolean checkValidity(DesignDocument designDocument, boolean bl) {
                return true;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Result {
        private DesignComponent mainComponent;
        private List<DesignComponent> components;

        public Result(DesignComponent ... designComponentArray) {
            this.mainComponent = designComponentArray.length > 0 ? designComponentArray[0] : null;
            this.components = Arrays.asList(designComponentArray);
            assert (!this.components.contains(null));
        }

        public Result(DesignComponent designComponent, List<DesignComponent> list) {
            this.mainComponent = designComponent;
            this.components = list;
        }

        public DesignComponent getMainComponent() {
            return this.mainComponent;
        }

        public List<DesignComponent> getComponents() {
            return this.components;
        }
    }
}

