/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DescriptorRegistry {
    private final Mutex mutex = new Mutex();
    private final WeakSet<DescriptorRegistryListener> listeners = new WeakSet();
    private HashMap<TypeID, ComponentDescriptor> descriptors = new HashMap();
    private ArrayList<ComponentProducer> producers = new ArrayList();
    private GlobalDescriptorRegistry globalDescriptorRegistry;
    private DescriptorRegistryListener listener = new DescriptorRegistryListener(){

        public void descriptorRegistryUpdated() {
            DescriptorRegistry.this.reload();
        }
    };

    public static DescriptorRegistry getDescriptorRegistry(String string, String string2) {
        return GlobalDescriptorRegistry.getGlobalDescriptorRegistry(string).getProjectRegistry(string2);
    }

    DescriptorRegistry(GlobalDescriptorRegistry globalDescriptorRegistry) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "getProjectRegistry"));
        this.globalDescriptorRegistry = globalDescriptorRegistry;
        globalDescriptorRegistry.addRegistryListener(this.listener);
        this.reload();
    }

    private boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    public void readAccess(final Runnable runnable) {
        this.globalDescriptorRegistry.readAccess(new Runnable(){

            public void run() {
                DescriptorRegistry.this.mutex.readAccess(runnable);
            }
        });
    }

    private void writeAccess(final Runnable runnable) {
        this.globalDescriptorRegistry.readAccess(new Runnable(){

            public void run() {
                DescriptorRegistry.this.mutex.writeAccess(runnable);
            }
        });
    }

    private void reload() {
        this.writeAccess(new Runnable(){

            public void run() {
                DescriptorRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, ComponentDescriptor> hashMap = new HashMap<TypeID, ComponentDescriptor>();
        ArrayList<ComponentProducer> arrayList = new ArrayList<ComponentProducer>();
        Collection<ComponentDescriptor> collection = this.globalDescriptorRegistry.getComponentDescriptors();
        for (ComponentDescriptor componentDescriptor : collection) {
            hashMap.put(componentDescriptor.getTypeDescriptor().getThisType(), componentDescriptor);
        }
        arrayList.addAll(this.globalDescriptorRegistry.getComponentProducers());
        this.descriptors = hashMap;
        this.producers = arrayList;
        for (DescriptorRegistryListener descriptorRegistryListener : this.listeners) {
            try {
                descriptorRegistryListener.descriptorRegistryUpdated();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public ComponentDescriptor getComponentDescriptor(TypeID typeID) {
        assert (this.isAccess()) : "No Mutex acess";
        if (typeID == null) {
            return null;
        }
        return this.descriptors.get(typeID);
    }

    public void removeComponentDescriptor(TypeID typeID) {
        if (typeID != null) {
            this.globalDescriptorRegistry.writeAccess(new RemoveComponentDescriptorTask(typeID));
        }
    }

    public Collection<ComponentDescriptor> getComponentDescriptors() {
        assert (this.isAccess());
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    public List<ComponentProducer> getComponentProducers() {
        assert (this.isAccess());
        return Collections.unmodifiableList(this.producers);
    }

    public void addRegistryListener(final DescriptorRegistryListener descriptorRegistryListener) {
        this.writeAccess(new Runnable(){

            public void run() {
                DescriptorRegistry.this.listeners.add((Object)descriptorRegistryListener);
                descriptorRegistryListener.descriptorRegistryUpdated();
            }
        });
    }

    public void removeRegistryListener(final DescriptorRegistryListener descriptorRegistryListener) {
        this.writeAccess(new Runnable(){

            public void run() {
                DescriptorRegistry.this.listeners.remove((Object)descriptorRegistryListener);
            }
        });
    }

    private boolean isComponentDescriptorCompatibleWithTypeID(TypeID typeID, ComponentDescriptor componentDescriptor) {
        assert (this.isAccess());
        if (typeID == null) {
            return false;
        }
        while (componentDescriptor != null) {
            TypeDescriptor typeDescriptor = componentDescriptor.getTypeDescriptor();
            TypeID typeID2 = typeDescriptor.getThisType();
            if (typeID2 == null) {
                return false;
            }
            if (typeID2.equals(typeID)) {
                return true;
            }
            componentDescriptor = this.getComponentDescriptor(typeDescriptor.getSuperType());
        }
        return false;
    }

    public boolean isInHierarchy(TypeID typeID, TypeID typeID2) {
        return this.isComponentDescriptorCompatibleWithTypeID(typeID, this.getComponentDescriptor(typeID2));
    }

    final class RemoveComponentDescriptorTask
    implements Runnable {
        private TypeID componentType;

        public RemoveComponentDescriptorTask(TypeID typeID) {
            this.componentType = typeID;
        }

        public void run() {
            DescriptorRegistry.this.globalDescriptorRegistry.removeComponentDescriptor(this.componentType);
        }
    }
}

