/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresentersProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignComponent {
    private final DesignDocument document;
    private final long componentID;
    private final TypeID type;
    private DesignComponent parentComponent;
    private final ArrayList<DesignComponent> children;
    private final HashMap<String, PropertyValue> properties;
    private final HashMap<String, PropertyValue> defaultProperties;
    private ComponentDescriptor componentDescriptor;
    private Lookup presenters;
    private PropertyValue referencePropertyValue;

    DesignComponent(DesignDocument designDocument, long l, ComponentDescriptor componentDescriptor) {
        assert (Debug.isFriend(DesignDocument.class, "createRawComponent"));
        this.document = designDocument;
        this.componentID = l;
        this.type = componentDescriptor.getTypeDescriptor().getThisType();
        assert (this.type.getKind() == TypeID.Kind.COMPONENT && this.type.getDimension() == 0);
        this.children = new ArrayList();
        this.properties = new HashMap();
        this.defaultProperties = new HashMap();
        this.referencePropertyValue = PropertyValue.createComponentReferenceCore(this);
        this.presenters = Lookup.EMPTY;
        this.setComponentDescriptor(componentDescriptor, false);
    }

    public ComponentDescriptor getComponentDescriptor() {
        assert (this.document.getTransactionManager().isAccess());
        return this.componentDescriptor;
    }

    void setComponentDescriptor(ComponentDescriptor componentDescriptor, boolean bl) {
        assert (Debug.isFriend(DesignDocument.class, "updateDescriptorReferences") || Debug.isFriend(DesignComponent.class, "<init>") || Debug.isFriend(DesignDocument.class, "updateDescriptorReferencesCore"));
        if (this.componentDescriptor == componentDescriptor) {
            return;
        }
        this.componentDescriptor = componentDescriptor;
        if (componentDescriptor != null) {
            for (PropertyDescriptor object2 : componentDescriptor.getPropertyDescriptors()) {
                String string = object2.getName();
                PropertyValue propertyValue = this.properties.get(string);
                if (propertyValue != null && propertyValue.isCompatible(object2.getType())) continue;
                propertyValue = object2.createDefaultValue(this, string);
                if (!propertyValue.isCompatible(object2)) {
                    Debug.warning("Default property value is not compatible", this.componentID, string, propertyValue);
                }
                this.defaultProperties.put(string, propertyValue);
                if (this.properties.get(string) != null) {
                    this.writeProperty(string, propertyValue);
                    continue;
                }
                this.properties.put(string, propertyValue);
            }
            Collection collection = this.presenters.lookupAll(Presenter.class);
            ArrayList<Presenter> arrayList = new ArrayList<Presenter>();
            this.gatherPresenters(arrayList, componentDescriptor);
            PresentersProcessor.postProcessDescriptor(this.document.getDocumentInterface().getProjectType(), this.document, componentDescriptor, arrayList);
            this.presenters = Lookups.fixed((Object[])arrayList.toArray());
            this.document.getTransactionManager().componentDescriptorChangeHappened(this, collection, arrayList, bl);
        } else {
            this.document.getTransactionManager().componentDescriptorChangeHappened(this, null, null, bl);
        }
    }

    private void gatherPresenters(ArrayList<Presenter> arrayList, ComponentDescriptor componentDescriptor) {
        if (componentDescriptor == null) {
            return;
        }
        this.gatherPresenters(arrayList, componentDescriptor.getSuperDescriptor());
        componentDescriptor.gatherPresenters(arrayList);
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public long getComponentID() {
        return this.componentID;
    }

    public TypeID getType() {
        return this.type;
    }

    public DesignComponent getParentComponent() {
        assert (this.document.getTransactionManager().isAccess());
        return this.parentComponent;
    }

    public void addComponent(DesignComponent designComponent) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (this.document == designComponent.document);
        assert (designComponent.parentComponent == null);
        assert (this.addComponentAssert(designComponent));
        this.children.add(designComponent);
        designComponent.parentComponent = this;
        this.document.getTransactionManager().parentChangeHappened(null, this, designComponent);
    }

    private boolean addComponentAssert(DesignComponent designComponent) {
        for (DesignComponent designComponent2 = this; designComponent2 != null; designComponent2 = designComponent2.getParentComponent()) {
            assert (designComponent2 != designComponent);
        }
        return true;
    }

    public void removeComponent(DesignComponent designComponent) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (this.document == designComponent.document);
        assert (designComponent.parentComponent == this);
        if (!this.children.remove(designComponent)) {
            throw Debug.error("Component is not a child of its parent", "parent", this, "Child", designComponent, "Children", this.children);
        }
        designComponent.parentComponent = null;
        this.document.getTransactionManager().parentChangeHappened(this, null, designComponent);
    }

    public void removeFromParentComponent() {
        assert (this.document.getTransactionManager().isWriteAccess());
        if (this.parentComponent != null) {
            this.parentComponent.removeComponent(this);
        }
    }

    public Collection<DesignComponent> getComponents() {
        assert (this.document.getTransactionManager().isAccess());
        return Collections.unmodifiableCollection(this.children);
    }

    public PropertyValue readProperty(String string) {
        assert (this.document.getTransactionManager().isAccess());
        PropertyValue propertyValue = this.properties.get(string);
        assert (this.properties.containsKey(string)) : this.toString() + "." + string + " property is missing";
        assert (propertyValue != null);
        return propertyValue;
    }

    public void writeProperty(String string, PropertyValue propertyValue) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (propertyValue != null) : "Null property value";
        assert (this.componentDescriptor != null);
        PropertyValue propertyValue2 = this.properties.get(string);
        assert (propertyValue2 != null) : "Missing old value in " + this + "." + string;
        if (propertyValue2 == propertyValue) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.componentDescriptor.getPropertyDescriptor(string);
        assert (propertyDescriptor != null) : "Missing property descriptor in " + this + "." + string;
        assert (!propertyDescriptor.isReadOnly()) : "Cannot write read-only property " + this + "." + string;
        assert (propertyValue.isCompatible(propertyDescriptor));
        this.properties.put(string, propertyValue);
        this.document.getTransactionManager().writePropertyHappened(this, string, propertyValue2, propertyValue);
    }

    public boolean isDefaultValue(String string) {
        assert (this.document.getTransactionManager().isAccess());
        assert (string != null);
        PropertyValue propertyValue = this.defaultProperties.get(string);
        PropertyValue propertyValue2 = this.properties.get(string);
        assert (propertyValue != null);
        assert (propertyValue2 != null);
        return propertyValue == propertyValue2;
    }

    public void resetToDefault(String string) {
        assert (this.document.getTransactionManager().isWriteAccess());
        assert (string != null);
        PropertyValue propertyValue = this.defaultProperties.get(string);
        assert (propertyValue != null);
        this.writeProperty(string, propertyValue);
    }

    PropertyValue getReferenceValue() {
        return this.referencePropertyValue;
    }

    public <T extends Presenter> T getPresenter(Class<T> clazz) {
        assert (this.document.getTransactionManager().isAccess());
        assert (clazz != null);
        return (T)((Presenter)this.presenters.lookup(clazz));
    }

    public <T> Collection<? extends T> getPresenters(Class<T> clazz) {
        assert (this.document.getTransactionManager().isAccess());
        assert (clazz != null);
        return this.presenters.lookupAll(clazz);
    }

    public String toString() {
        return this.componentID + ":" + this.type;
    }

    void dumpComponent(String string) {
        assert (this.document.getTransactionManager().isAccess());
        System.out.println(string + this.componentID + " : " + this.componentDescriptor);
        string = string + "    ";
        HashSet<String> hashSet = new HashSet<String>(this.properties.keySet());
        Collection<PropertyDescriptor> collection = this.componentDescriptor.getPropertyDescriptors();
        for (PropertyDescriptor object : collection) {
            String string2 = object.getName();
            System.out.println(string + (this.properties.get(string2) == this.defaultProperties.get(string2) ? "## " : ":: ") + string2 + " = " + this.properties.get(string2));
            hashSet.remove(string2);
        }
        for (String string3 : hashSet) {
            System.out.println(string + "?? " + string3 + " = " + this.properties.get(string3));
        }
        for (Object object : this.presenters.lookupAll(Object.class)) {
            System.out.println(string + ">>" + object);
        }
        for (DesignComponent designComponent : this.children) {
            designComponent.dumpComponent(string);
        }
    }
}

