/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DocumentInterface;
import org.netbeans.modules.vmd.api.model.ListenerManager;
import org.netbeans.modules.vmd.api.model.PostInitializeProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TransactionManager;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignDocument {
    private final DocumentInterface documentInterface;
    private final DescriptorRegistry descriptorRegistry;
    private final ListenerManager listenerManager;
    private final TransactionManager transactionManager;
    private HashMap<Long, TimedWeakReference> uid2components;
    private DesignComponent rootComponent;
    private long componentIDCounter;
    private String selectionSourceID;
    private Collection<DesignComponent> selectedComponents;

    public DesignDocument(DocumentInterface documentInterface) {
        this.documentInterface = documentInterface;
        this.descriptorRegistry = DescriptorRegistry.getDescriptorRegistry(documentInterface.getProjectType(), documentInterface.getProjectID());
        this.listenerManager = new ListenerManager(this);
        this.transactionManager = new TransactionManager(this, this.descriptorRegistry, this.listenerManager);
        this.uid2components = new HashMap(100);
        this.componentIDCounter = 0L;
        this.selectedComponents = Collections.emptySet();
        this.descriptorRegistry.addRegistryListener(new DescriptorRegistryListener(){

            public void descriptorRegistryUpdated() {
                DesignDocument.this.updateDescriptorReferences();
            }
        });
    }

    public DocumentInterface getDocumentInterface() {
        return this.documentInterface;
    }

    public DescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public DesignComponent getRootComponent() {
        assert (this.getTransactionManager().isAccess());
        return this.rootComponent;
    }

    public void setRootComponent(DesignComponent designComponent) {
        assert (this.getTransactionManager().isWriteAccess());
        assert (this.rootComponent == null);
        assert (designComponent != null);
        this.rootComponent = designComponent;
        this.getTransactionManager().rootChangeHappened(designComponent);
    }

    public boolean setPreferredComponentID(long l) {
        assert (this.transactionManager.isWriteAccess());
        if (this.componentIDCounter > l) {
            return false;
        }
        this.componentIDCounter = l;
        return true;
    }

    public DesignComponent createComponent(TypeID typeID) {
        DesignComponent designComponent = this.createRawComponent(typeID);
        assert (designComponent != null);
        this.performComponentPostInit(designComponent, designComponent.getComponentDescriptor());
        PostInitializeProcessor.postInitializeComponent(this.getDocumentInterface().getProjectType(), designComponent);
        return designComponent;
    }

    private void performComponentPostInit(DesignComponent designComponent, ComponentDescriptor componentDescriptor) {
        if (componentDescriptor == null) {
            return;
        }
        this.performComponentPostInit(designComponent, componentDescriptor.getSuperDescriptor());
        componentDescriptor.postInitialize(designComponent);
    }

    public DesignComponent createRawComponent(TypeID typeID) {
        assert (Debug.isFriend(DesignDocument.class, "createComponent") || Debug.isFriend("org.netbeans.modules.vmd.io.DocumentLoad", "loadDocumentCore"));
        assert (this.transactionManager.isWriteAccess());
        ComponentDescriptor componentDescriptor = this.descriptorRegistry.getComponentDescriptor(typeID);
        assert (componentDescriptor != null) : "Missing component descriptor for " + typeID;
        assert (componentDescriptor.getTypeDescriptor().isCanInstantiate());
        DesignComponent designComponent = new DesignComponent(this, this.componentIDCounter++, componentDescriptor);
        this.uid2components.put(designComponent.getComponentID(), new TimedWeakReference(designComponent));
        this.getListenerManager().notifyComponentCreated(designComponent);
        return designComponent;
    }

    public void deleteComponent(DesignComponent designComponent) {
        assert (this.transactionManager.isWriteAccess());
        assert (designComponent != null && designComponent != this.rootComponent);
        assert (designComponent.getDocument() == this);
        Collection<DesignComponent> collection = designComponent.getComponents();
        if (collection.size() > 0) {
            Debug.warning("Children has to be deleted before deleting the component", designComponent, collection);
        }
        designComponent.removeFromParentComponent();
        ComponentDescriptor componentDescriptor = designComponent.getComponentDescriptor();
        if (componentDescriptor != null) {
            for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
                designComponent.resetToDefault(propertyDescriptor.getName());
            }
        }
        if (this.selectedComponents.contains(designComponent)) {
            HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>(this.selectedComponents);
            hashSet.remove(designComponent);
            this.setSelectedComponents("deleteComponent", (Collection<DesignComponent>)hashSet);
        }
        assert (!Debug.isComponentReferencedInRootTree(designComponent)) : "Component (" + designComponent + ") is referenced still after deletion";
    }

    public void deleteComponents(Collection<DesignComponent> collection) {
        assert (this.transactionManager.isWriteAccess());
        assert (this.deleteComponentsPreAssert(collection));
        for (DesignComponent object : collection) {
            object.removeFromParentComponent();
        }
        Object object = null;
        for (DesignComponent designComponent : collection) {
            ComponentDescriptor componentDescriptor;
            Collection<DesignComponent> collection2 = designComponent.getComponents();
            if (collection2.size() > 0) {
                Debug.warning("Children has to be deleted before deleting the component", designComponent, collection2);
            }
            if ((componentDescriptor = designComponent.getComponentDescriptor()) != null) {
                for (PropertyDescriptor propertyDescriptor : componentDescriptor.getPropertyDescriptors()) {
                    designComponent.resetToDefault(propertyDescriptor.getName());
                }
            }
            if (!this.selectedComponents.contains(designComponent)) continue;
            if (object == null) {
                object = new HashSet<DesignComponent>(this.selectedComponents);
            }
            ((HashSet)object).remove(designComponent);
        }
        if (object != null) {
            this.setSelectedComponents("deleteComponent", (Collection<DesignComponent>)object);
        }
        assert (this.deleteComponentsPostAssert(collection));
    }

    private boolean deleteComponentsPreAssert(Collection<DesignComponent> collection) {
        for (DesignComponent designComponent : collection) {
            assert (designComponent != null && designComponent != this.rootComponent);
            assert (designComponent.getDocument() == this);
        }
        return true;
    }

    private boolean deleteComponentsPostAssert(Collection<DesignComponent> collection) {
        for (DesignComponent designComponent : collection) {
            assert (!Debug.isComponentReferencedInRootTree(designComponent)) : "Component (" + designComponent + ") is referenced still after deletion";
        }
        return true;
    }

    public DesignComponent getComponentByUID(long l) {
        assert (this.transactionManager.isAccess());
        TimedWeakReference timedWeakReference = this.uid2components.get(l);
        return timedWeakReference != null ? (DesignComponent)timedWeakReference.get() : null;
    }

    public String getSelectionSourceID() {
        assert (this.transactionManager.isAccess());
        return this.selectionSourceID;
    }

    public Collection<DesignComponent> getSelectedComponents() {
        assert (this.transactionManager.isAccess());
        return this.selectedComponents;
    }

    public void setSelectedComponents(String string, Collection<DesignComponent> collection) {
        assert (this.transactionManager.isWriteAccess());
        assert (collection != null);
        assert (this.setSelectedComponentsAssert(collection));
        if (this.selectedComponents.containsAll(collection) && collection.containsAll(this.selectedComponents)) {
            return;
        }
        Collection<DesignComponent> collection2 = this.selectedComponents;
        this.selectionSourceID = string;
        this.selectedComponents = Collections.unmodifiableCollection(new ArrayList<DesignComponent>(collection));
        this.transactionManager.selectComponentsHappened(collection2, this.selectedComponents);
    }

    private boolean setSelectedComponentsAssert(Collection<DesignComponent> collection) {
        for (DesignComponent designComponent : collection) {
            assert (designComponent != null);
            assert (designComponent.getDocument() == this);
        }
        return true;
    }

    private void updateDescriptorReferences() {
        this.transactionManager.writeAccess(new Runnable(){

            public void run() {
                DesignDocument.this.updateDescriptorReferencesCore();
            }
        });
    }

    private void updateDescriptorReferencesCore() {
        for (TimedWeakReference timedWeakReference : this.uid2components.values()) {
            DesignComponent designComponent = (DesignComponent)timedWeakReference.get();
            if (designComponent == null) continue;
            ComponentDescriptor componentDescriptor = this.descriptorRegistry.getComponentDescriptor(designComponent.getType());
            designComponent.setComponentDescriptor(componentDescriptor, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TimedWeakReference
    extends WeakReference<DesignComponent>
    implements Runnable {
        private final long componentID;

        public TimedWeakReference(DesignComponent designComponent) {
            super(designComponent, Utilities.activeReferenceQueue());
            this.componentID = designComponent.getComponentID();
        }

        @Override
        public void run() {
            DesignDocument.this.transactionManager.writeAccess(new Runnable(){

                public void run() {
                    DesignDocument.this.uid2components.remove(TimedWeakReference.this.componentID);
                }
            });
        }
    }
}

