/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.Versionable;

public final class PropertyDescriptor {
    private final String name;
    private final TypeID type;
    private final DefaultValueFactory defaultValueFactory;
    private final PropertyValue defaultValue;
    private final boolean allowNull;
    private final boolean allowUserCode;
    private final Versionable versionable;
    private final boolean useForSerialization;
    private final boolean readOnly;

    public PropertyDescriptor(String string, TypeID typeID, PropertyValue propertyValue, boolean bl, boolean bl2, Versionable versionable) {
        this(string, typeID, propertyValue, bl, bl2, versionable, true, false);
    }

    public PropertyDescriptor(String string, TypeID typeID, PropertyValue propertyValue, boolean bl, boolean bl2, Versionable versionable, boolean bl3, boolean bl4) {
        this(string, typeID, null, propertyValue, bl, bl2, versionable, bl3, bl4);
    }

    public PropertyDescriptor(String string, TypeID typeID, DefaultValueFactory defaultValueFactory, boolean bl, boolean bl2, Versionable versionable, boolean bl3, boolean bl4) {
        this(string, typeID, defaultValueFactory, null, bl, bl2, versionable, bl3, bl4);
    }

    private PropertyDescriptor(String string, TypeID typeID, DefaultValueFactory defaultValueFactory, PropertyValue propertyValue, boolean bl, boolean bl2, Versionable versionable, boolean bl3, boolean bl4) {
        assert (string != null && typeID != null && (defaultValueFactory != null || propertyValue != null)) : "Name, type, defaultValueFactory or defaultValue could be null in PropertyDescriptor : " + this;
        this.name = string;
        this.type = typeID;
        this.defaultValueFactory = defaultValueFactory;
        this.defaultValue = propertyValue;
        this.allowNull = bl;
        this.allowUserCode = bl2;
        this.versionable = versionable;
        this.useForSerialization = bl3;
        this.readOnly = bl4;
    }

    public String getName() {
        return this.name;
    }

    public TypeID getType() {
        return this.type;
    }

    public PropertyValue getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowUserCode() {
        return this.allowUserCode;
    }

    public Versionable getVersionable() {
        return this.versionable;
    }

    public boolean isUseForSerialization() {
        return this.useForSerialization;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertyValue createDefaultValue(DesignComponent designComponent, String string) {
        return this.defaultValueFactory != null ? this.defaultValueFactory.createDefaultValue(designComponent, string) : this.defaultValue;
    }

    public static interface DefaultValueFactory {
        public PropertyValue createDefaultValue(DesignComponent var1, String var2);
    }
}

