/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.openide.util.ImageUtilities;

public abstract class AddActionItem
extends AbstractAction {
    public static final String TYPEID_KEY = "typeID";
    private static Map<ComponentProducer, AddActionItem> instances = new WeakHashMap<ComponentProducer, AddActionItem>();
    private ImageIcon icon;

    public static final AddActionItem getInstance(DesignComponent designComponent, ComponentProducer componentProducer) {
        AddActionItem addActionItem = instances.get(componentProducer);
        if (addActionItem != null) {
            addActionItem.resolveAction(designComponent);
            return addActionItem;
        }
        addActionItem = AddActionItem.create(designComponent, componentProducer);
        instances.put(componentProducer, addActionItem);
        return addActionItem;
    }

    protected AddActionItem(TypeID typeID) {
        this.putValue(TYPEID_KEY, typeID);
    }

    private AddActionItem(TypeID typeID, DesignComponent designComponent, ComponentProducer componentProducer) {
        String string = componentProducer.getPaletteDescriptor().getSmallIcon();
        Image image = string != null ? ImageUtilities.loadImage((String)string) : null;
        this.putValue(TYPEID_KEY, typeID);
        this.putValue("Name", componentProducer.getPaletteDescriptor().getDisplayName());
        if (image != null) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }
        this.resolveAction(designComponent);
    }

    public abstract void resolveAction(DesignComponent var1);

    private static AddActionItem create(DesignComponent designComponent, final ComponentProducer componentProducer) {
        return new AddActionItem(componentProducer.getMainComponentTypeID(), designComponent, componentProducer){
            private WeakReference<DesignComponent> component;
            private DesignComponent selectedComponent;

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                if (componentProducer == null) {
                    throw new IllegalArgumentException("Null argument typeID");
                }
                final DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)component.get(), componentProducer, null);
                        selectedComponent = result.getMainComponent();
                    }
                });
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        designDocument.setSelectedComponents(null, Collections.singleton(selectedComponent));
                        selectedComponent = null;
                    }
                });
            }

            public void resolveAction(DesignComponent designComponent) {
                this.component = new WeakReference<DesignComponent>(designComponent);
            }
        };
    }
}

