/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class DefaultJavaPlatformProvider
implements JavaPlatformProvider,
FileChangeListener {
    private static final String PLATFORM_STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject storage = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
    private JavaPlatform defaultPlatform;

    public DefaultJavaPlatformProvider() {
        if (this.storage != null) {
            this.storage.addFileChangeListener((FileChangeListener)this);
        }
    }

    public JavaPlatform[] getInstalledPlatforms() {
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>();
        if (this.storage != null) {
            try {
                for (FileObject fileObject : this.storage.getChildren()) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                    if (instanceCookie == null) {
                        ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " has no InstanceCookie");
                        continue;
                    }
                    if (instanceCookie instanceof InstanceCookie.Of) {
                        if (((InstanceCookie.Of)instanceCookie).instanceOf(JavaPlatform.class)) {
                            arrayList.add((JavaPlatform)instanceCookie.instanceCreate());
                            continue;
                        }
                        ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " is not an instance of JavaPlatform");
                        continue;
                    }
                    Object object = instanceCookie.instanceCreate();
                    if (object instanceof JavaPlatform) {
                        arrayList.add((JavaPlatform)object);
                        continue;
                    }
                    ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + fileObject.getNameExt() + " is not an instance of JavaPlatform");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return arrayList.toArray(new JavaPlatform[arrayList.size()]);
    }

    public JavaPlatform getDefaultPlatform() {
        if (this.defaultPlatform == null) {
            JavaPlatform[] javaPlatformArray = this.getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                if (!"default_platform".equals(javaPlatformArray[i].getProperties().get("platform.ant.name"))) continue;
                this.defaultPlatform = javaPlatformArray[i];
                break;
            }
        }
        return this.defaultPlatform;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileChanged(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.firePropertyChange();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.firePropertyChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private void firePropertyChange() {
        this.pcs.firePropertyChange("installedPlatforms", null, null);
    }
}

