/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.PathFinderVisitor;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstPath
implements Iterable<ASTNode> {
    private ArrayList<ASTNode> path = new ArrayList(30);

    public AstPath() {
    }

    public AstPath(ArrayList<ASTNode> arrayList) {
        this.path = arrayList;
    }

    public AstPath(ASTNode aSTNode, int n, BaseDocument baseDocument) {
        try {
            int n2;
            int n3 = baseDocument.getLength();
            int n4 = n2 = n3 == 0 ? 0 : n + 1;
            if (n3 > 0 && n2 >= n3) {
                n2 = n3 - 1;
            }
            Scanner scanner = new Scanner(baseDocument.getText(0, n2));
            int n5 = 0;
            String string = "";
            while (scanner.hasNextLine()) {
                string = scanner.nextLine();
                ++n5;
            }
            int n6 = string.length();
            this.findPathTo(aSTNode, n5, n6);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public AstPath(ASTNode aSTNode, int n, int n2) {
        this.findPathTo(aSTNode, n, n2);
    }

    public AstPath(ASTNode aSTNode, ASTNode aSTNode2) {
        if (!this.find(aSTNode, aSTNode2)) {
            this.path.clear();
        } else {
            Collections.reverse(this.path);
        }
    }

    public void descend(ASTNode aSTNode) {
        this.path.add(aSTNode);
    }

    public void ascend() {
        this.path.remove(this.path.size() - 1);
    }

    private ASTNode findPathTo(ASTNode aSTNode, int n, int n2) {
        ASTNode aSTNode2;
        assert (n >= 0) : "line number was negative: " + n;
        assert (n2 >= 0) : "column number was negative: " + n2;
        assert (aSTNode != null) : "ASTNode should not be null";
        assert (aSTNode instanceof ModuleNode) : "ASTNode must be a ModuleNode";
        this.path.addAll(this.find(aSTNode, n, n2));
        if (this.path.size() == 0 || !(this.path.get(0) instanceof ClassNode)) {
            aSTNode2 = (ModuleNode)aSTNode;
            String string = ((ModuleNode)aSTNode2).getContext().getName();
            int n3 = string.lastIndexOf(".groovy");
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
            if ((n3 = string.lastIndexOf(46)) != -1) {
                string = string.substring(n3 + 1);
            }
            for (Object e : ((ModuleNode)aSTNode2).getClasses()) {
                ClassNode classNode = (ClassNode)e;
                if (!string.equals(classNode.getNameWithoutPackage())) continue;
                this.path.add(0, classNode);
                break;
            }
        }
        this.path.add(0, aSTNode);
        aSTNode2 = this.path.get(this.path.size() - 1);
        return aSTNode2;
    }

    private List<ASTNode> find(ASTNode aSTNode, int n, int n2) {
        assert (n >= 0) : "line number was negative: " + n;
        assert (n2 >= 0) : "column number was negative: " + n2;
        assert (aSTNode != null) : "ASTNode should not be null";
        assert (aSTNode instanceof ModuleNode) : "ASTNode must be a ModuleNode";
        ModuleNode moduleNode = (ModuleNode)aSTNode;
        PathFinderVisitor pathFinderVisitor = new PathFinderVisitor(moduleNode.getContext(), n, n2);
        for (Object e : moduleNode.getClasses()) {
            pathFinderVisitor.visitClass((ClassNode)e);
        }
        for (Object e : moduleNode.getMethods()) {
            pathFinderVisitor.visitMethod((MethodNode)e);
        }
        return pathFinderVisitor.getPath();
    }

    public boolean find(ASTNode aSTNode, ASTNode aSTNode2) {
        if (aSTNode == aSTNode2) {
            return true;
        }
        List<ASTNode> list = AstUtilities.children(aSTNode);
        for (ASTNode aSTNode3 : list) {
            boolean bl = this.find(aSTNode3, aSTNode2);
            if (!bl) continue;
            this.path.add(aSTNode3);
            return bl;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path(");
        stringBuilder.append(this.path.size());
        stringBuilder.append(")=[");
        for (ASTNode aSTNode : this.path) {
            String string = aSTNode.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ASTNode leaf() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public ASTNode leafParent() {
        if (this.path.size() < 2) {
            return null;
        }
        return this.path.get(this.path.size() - 2);
    }

    public ASTNode leafGrandParent() {
        if (this.path.size() < 3) {
            return null;
        }
        return this.path.get(this.path.size() - 3);
    }

    public ASTNode root() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(0);
    }

    @Override
    public Iterator<ASTNode> iterator() {
        return new LeafToRootIterator(this.path);
    }

    public ListIterator<ASTNode> rootToLeaf() {
        return this.path.listIterator();
    }

    public ListIterator<ASTNode> leafToRoot() {
        return new LeafToRootIterator(this.path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LeafToRootIterator
    implements ListIterator<ASTNode> {
        private final ListIterator<ASTNode> it;

        private LeafToRootIterator(ArrayList<ASTNode> arrayList) {
            this.it = arrayList.listIterator(arrayList.size());
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public ASTNode next() {
            return this.it.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public ASTNode previous() {
            return this.it.next();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(ASTNode aSTNode) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(ASTNode aSTNode) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

