/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.elements.AstClassElement;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.AstFieldElement;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureAnalyzer
implements StructureScanner {
    private List<AstElement> structure;
    private Map<AstClassElement, Set<FieldNode>> fields;
    private Map<AstClassElement, Set<PropertyNode>> properties;
    private List<AstMethodElement> methods;
    private static final Logger LOG = Logger.getLogger(StructureAnalyzer.class.getName());

    public AnalysisResult analyze(GroovyParserResult groovyParserResult) {
        return this.scan(groovyParserResult);
    }

    public List<? extends StructureItem> scan(ParserResult parserResult) {
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        AnalysisResult analysisResult = groovyParserResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<GroovyStructureItem> arrayList = new ArrayList<GroovyStructureItem>(list.size());
        for (AstElement astElement : list) {
            if (!StructureAnalyzer.isVisible(astElement)) continue;
            arrayList.add(new GroovyStructureItem(astElement, parserResult));
        }
        return arrayList;
    }

    private AnalysisResult scan(GroovyParserResult groovyParserResult) {
        AnalysisResult analysisResult = new AnalysisResult();
        ModuleNode moduleNode = AstUtilities.getRoot(groovyParserResult);
        if (moduleNode == null) {
            return analysisResult;
        }
        this.structure = new ArrayList<AstElement>();
        this.fields = new HashMap<AstClassElement, Set<FieldNode>>();
        this.methods = new ArrayList<AstMethodElement>();
        this.properties = new HashMap<AstClassElement, Set<PropertyNode>>();
        AstPath astPath = new AstPath();
        astPath.descend(moduleNode);
        this.scan(groovyParserResult, moduleNode, astPath, null, null, null);
        astPath.ascend();
        HashMap<String, FieldNode> hashMap = new HashMap<String, FieldNode>();
        for (AstClassElement astClassElement : this.fields.keySet()) {
            Set<FieldNode> set = this.fields.get(astClassElement);
            if (set == null) continue;
            for (FieldNode fieldNode : set) {
                hashMap.put(fieldNode.getName(), fieldNode);
            }
            for (FieldNode fieldNode : hashMap.values()) {
                AstFieldElement astFieldElement = new AstFieldElement(groovyParserResult, fieldNode);
                astFieldElement.setIn(astClassElement.getFqn());
                String string = fieldNode.getName();
                boolean bl = false;
                Set<PropertyNode> set2 = this.properties.get(astClassElement);
                if (set2 != null) {
                    for (PropertyNode propertyNode : set2) {
                        if (!string.equals(propertyNode.getName())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    astFieldElement.setProperty(true);
                }
                astClassElement.addChild(astFieldElement);
            }
            hashMap.clear();
        }
        analysisResult.setElements(this.structure);
        return analysisResult;
    }

    private void scan(GroovyParserResult groovyParserResult, ASTNode aSTNode, AstPath astPath, String string, Set<String> set, AstElement object) {
        Set<AnnotatedNode> set2;
        if (aSTNode instanceof ClassNode) {
            set2 = new AstClassElement(groovyParserResult, aSTNode);
            ((AstClassElement)((Object)set2)).setFqn(((ClassNode)aSTNode).getName());
            if (object != null) {
                ((AstElement)((Object)object)).addChild((AstElement)((Object)set2));
            } else {
                this.structure.add((AstElement)((Object)set2));
            }
            object = set2;
        } else if (aSTNode instanceof FieldNode) {
            if (object instanceof AstClassElement) {
                set2 = this.fields.get(object);
                if (set2 == null) {
                    set2 = new HashSet<PropertyNode>();
                    this.fields.put((AstClassElement)((Object)object), set2);
                }
                set2.add((PropertyNode)((Object)((FieldNode)aSTNode)));
            }
        } else if (aSTNode instanceof MethodNode) {
            set2 = new AstMethodElement(groovyParserResult, aSTNode);
            this.methods.add((AstMethodElement)((Object)set2));
            ((AstElement)((Object)set2)).setIn(string);
            if (object != null) {
                ((AstElement)((Object)object)).addChild((AstElement)((Object)set2));
            } else {
                this.structure.add((AstElement)((Object)set2));
            }
        } else if (aSTNode instanceof PropertyNode) {
            set2 = this.properties.get(object);
            if (set2 == null) {
                set2 = new HashSet<PropertyNode>();
                this.properties.put((AstClassElement)((Object)object), set2);
            }
            set2.add((PropertyNode)aSTNode);
        }
        set2 = AstUtilities.children(aSTNode);
        for (ASTNode aSTNode2 : set2) {
            astPath.descend(aSTNode2);
            this.scan(groovyParserResult, aSTNode2, astPath, string, set, (AstElement)((Object)object));
            astPath.ascend();
        }
    }

    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        if (moduleNode == null) {
            return Collections.emptyMap();
        }
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        AnalysisResult analysisResult = groovyParserResult.getStructure();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        final BaseDocument baseDocument = LexUtilities.getDocument(groovyParserResult, false);
        if (baseDocument == null) {
            return Collections.emptyMap();
        }
        final OffsetRange[] offsetRangeArray = new OffsetRange[1];
        final ArrayList arrayList2 = new ArrayList();
        baseDocument.render(new Runnable(){

            public void run() {
                TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, 1);
                int n = 0;
                int n2 = 0;
                boolean bl = false;
                while (tokenSequence != null && tokenSequence.isValid() && tokenSequence.moveNext()) {
                    StringBuffer stringBuffer;
                    Token token = tokenSequence.token();
                    if (token.id() == GroovyTokenId.LITERAL_import) {
                        int n3 = tokenSequence.offset();
                        if (!bl) {
                            n = n3;
                            bl = true;
                        }
                        n2 = n3;
                        continue;
                    }
                    if (token.id() != GroovyTokenId.BLOCK_COMMENT || (stringBuffer = new StringBuffer(token.text())).indexOf("\n") == -1) continue;
                    int n4 = tokenSequence.offset();
                    arrayList2.add(new OffsetRange(n4, n4 + token.length()));
                }
                try {
                    n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
                    offsetRangeArray[0] = new OffsetRange(n, n2);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
        if (!arrayList2.isEmpty()) {
            hashMap.put("comments", arrayList2);
        }
        try {
            if (offsetRangeArray[0] != null && Utilities.getRowCount((BaseDocument)baseDocument, (int)offsetRangeArray[0].getStart(), (int)offsetRangeArray[0].getEnd()) > 1) {
                hashMap.put("imports", Collections.singletonList(offsetRangeArray[0]));
            }
            this.addFolds(baseDocument, analysisResult.getElements(), hashMap, arrayList);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return hashMap;
    }

    private void addFolds(BaseDocument baseDocument, List<? extends AstElement> list, Map<String, List<OffsetRange>> map, List<OffsetRange> list2) throws BadLocationException {
        for (AstElement astElement : list) {
            Object object;
            ElementKind elementKind = astElement.getKind();
            switch (elementKind) {
                case FIELD: 
                case METHOD: 
                case CONSTRUCTOR: 
                case CLASS: 
                case MODULE: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRangeFull((ASTNode)object, baseDocument);
                    if (!(elementKind == ElementKind.METHOD && !((MethodNode)object).isSynthetic() || elementKind == ElementKind.CONSTRUCTOR && !((ConstructorNode)object).isSynthetic() || elementKind == ElementKind.FIELD && ((FieldNode)object).getInitialExpression() instanceof ClosureExpression) && (offsetRange.getStart() <= Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange.getStart()) || elementKind == ElementKind.FIELD)) break;
                    int n = offsetRange.getStart();
                    if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) >= 0 && baseDocument.getChars(n, 1)[0] != '{') {
                        ++n;
                    }
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                }
            }
            if ((object = astElement.getChildren()) == null || object.size() <= 0) continue;
            this.addFolds(baseDocument, (List<? extends AstElement>)object, map, list2);
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    private static boolean isVisible(AstElement astElement) {
        if (astElement.getKind() == ElementKind.METHOD) {
            AstMethodElement astMethodElement = (AstMethodElement)astElement;
            ASTNode aSTNode = astMethodElement.getNode();
            return !(aSTNode instanceof MethodNode) || !((MethodNode)aSTNode).isSynthetic();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyStructureItem
    implements StructureItem {
        private final AstElement node;
        private final ElementKind kind;
        private final ParserResult info;
        @NullAllowed
        private final BaseDocument doc;

        private GroovyStructureItem(AstElement astElement, ParserResult parserResult) {
            this.node = astElement;
            this.kind = astElement.getKind();
            this.info = parserResult;
            this.doc = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        }

        public String getName() {
            return this.node.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.node.getName());
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                AstMethodElement astMethodElement = (AstMethodElement)this.node;
                List<String> list = astMethodElement.getParameters();
                if (list != null && list.size() > 0) {
                    htmlFormatter.appendHtml("(");
                    htmlFormatter.parameters(true);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        htmlFormatter.appendText(string);
                        if (!iterator.hasNext()) continue;
                        htmlFormatter.appendHtml(", ");
                    }
                    htmlFormatter.parameters(false);
                    htmlFormatter.appendHtml(")");
                } else {
                    htmlFormatter.appendHtml("()");
                }
            }
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.node;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.node.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case FIELD: 
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case PROPERTY: 
                case CONSTANT: 
                case KEYWORD: 
                case VARIABLE: 
                case OTHER: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.node.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<GroovyStructureItem> arrayList = new ArrayList<GroovyStructureItem>(list.size());
                for (AstElement astElement : list) {
                    if (!StructureAnalyzer.isVisible(astElement)) continue;
                    arrayList.add(new GroovyStructureItem(astElement, this.info));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            if (this.doc != null) {
                OffsetRange offsetRange = AstUtilities.getRangeFull(this.node.getNode(), this.doc);
                LOG.log(Level.FINEST, "getPosition(), start: {0}", offsetRange.getStart());
                return offsetRange.getStart();
            }
            return 0L;
        }

        public long getEndPosition() {
            if (this.doc != null) {
                OffsetRange offsetRange = AstUtilities.getRangeFull(this.node.getNode(), this.doc);
                LOG.log(Level.FINEST, "getEndPosition(), end: {0}", offsetRange.getEnd());
                return offsetRange.getEnd();
            }
            return 0L;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GroovyStructureItem)) {
                return false;
            }
            GroovyStructureItem groovyStructureItem = (GroovyStructureItem)object;
            if (this.kind != groovyStructureItem.kind) {
                return false;
            }
            return this.getName().equals(groovyStructureItem.getName());
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AnalysisResult {
        private List<? extends AstElement> elements;

        Set<String> getRequires() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        List<? extends AstElement> getElements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return this.elements;
        }

        private void setElements(List<? extends AstElement> list) {
            this.elements = list;
        }
    }
}

