/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.MethodElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstMethodElement
extends AstElement
implements MethodElement {
    private List<String> parameters;
    private Modifier access = Modifier.PUBLIC;
    private Class clz;
    private MetaMethod method;
    boolean GDK;

    public AstMethodElement(GroovyParserResult groovyParserResult, ASTNode aSTNode) {
        super(groovyParserResult, aSTNode);
    }

    public AstMethodElement(GroovyParserResult groovyParserResult, ASTNode aSTNode, Class clazz, MetaMethod metaMethod, boolean bl) {
        super(groovyParserResult, aSTNode);
        this.clz = clazz;
        this.method = metaMethod;
        this.GDK = bl;
    }

    public boolean isGDK() {
        return this.GDK;
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    public Class getClz() {
        return this.clz;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<String>();
            for (Parameter parameter : ((MethodNode)this.node).getParameters()) {
                this.parameters.add(parameter.getName());
            }
            if (this.parameters == null) {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.node instanceof ConstructorNode) {
                this.name = ((ConstructorNode)this.node).getDeclaringClass().getNameWithoutPackage();
            } else if (this.node instanceof MethodNode) {
                this.name = ((MethodNode)this.node).getName();
            }
            if (this.name == null) {
                this.name = this.node.toString();
            }
        }
        return this.name;
    }

    public void setModifiers(Set<Modifier> set) {
        this.modifiers = set;
    }

    public void setAccess(Modifier modifier) {
        this.access = modifier;
        this.modifiers = this.modifiers != null && this.modifiers.contains(Modifier.STATIC) ? EnumSet.of(Modifier.STATIC, modifier) : null;
    }

    @Override
    public ElementKind getKind() {
        if (this.node instanceof ConstructorNode) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public boolean isInherited() {
        return false;
    }
}

