/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.IndexedField;
import org.netbeans.modules.groovy.editor.spi.completion.CompletionContext;
import org.netbeans.modules.groovy.editor.spi.completion.DynamicCompletionProvider;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicElementHandler {
    private static final Logger LOGGER = Logger.getLogger(DynamicElementHandler.class.getName());
    private final ParserResult info;

    private DynamicElementHandler(ParserResult parserResult) {
        this.info = parserResult;
    }

    public static DynamicElementHandler forCompilationInfo(ParserResult parserResult) {
        return new DynamicElementHandler(parserResult);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(String string, String string2, String string3, int n, boolean bl, boolean bl2, FileObject fileObject) {
        if (this.info.getSnapshot().getSource().getFileObject() == null) {
            return Collections.emptyMap();
        }
        CompletionContext completionContext = new CompletionContext(n, fileObject, string, string2, string3, false, this.getProperties(string2), bl2, bl);
        HashMap<MethodSignature, CompletionItem> hashMap = new HashMap<MethodSignature, CompletionItem>();
        for (DynamicCompletionProvider dynamicCompletionProvider : Lookup.getDefault().lookupAll(DynamicCompletionProvider.class)) {
            for (Map.Entry<MethodSignature, CompletionItem> entry : dynamicCompletionProvider.getMethods(completionContext).entrySet()) {
                if (!entry.getKey().getName().startsWith(string3)) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(String string, String string2, String string3, int n, boolean bl, FileObject fileObject) {
        if (this.info.getSnapshot().getSource().getFileObject() == null) {
            return Collections.emptyMap();
        }
        CompletionContext completionContext = new CompletionContext(n, fileObject, string, string2, string3, false, this.getProperties(string2), bl, false);
        HashMap<FieldSignature, CompletionItem> hashMap = new HashMap<FieldSignature, CompletionItem>();
        for (DynamicCompletionProvider dynamicCompletionProvider : Lookup.getDefault().lookupAll(DynamicCompletionProvider.class)) {
            for (Map.Entry<FieldSignature, CompletionItem> entry : dynamicCompletionProvider.getFields(completionContext).entrySet()) {
                if (!entry.getKey().getName().startsWith(string3)) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    private List<String> getProperties(String string) {
        FileObject fileObject = this.info.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return Collections.emptyList();
        }
        GroovyIndex groovyIndex = GroovyIndex.get(QuerySupport.findRoots((FileObject)fileObject, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet()));
        Set<IndexedField> set = groovyIndex.getFields(".*", string, QuerySupport.Kind.REGEXP);
        if (set.size() == 0) {
            LOGGER.log(Level.FINEST, "Nothing found in GroovyIndex");
            return Collections.emptyList();
        }
        LOGGER.log(Level.FINEST, "Found this number of fields : {0} ", set.size());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IndexedField indexedField : set) {
            LOGGER.log(Level.FINEST, "field from index : {0} ", indexedField.getName());
            if (indexedField.isStatic() || !indexedField.isProperty()) continue;
            arrayList.add(indexedField.getName());
        }
        return arrayList;
    }
}

