/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.hints.infrastructure;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.api.parser.GroovyError;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyErrorRule;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovyRuleContext;
import org.netbeans.modules.groovy.editor.hints.infrastructure.GroovySelectionRule;
import org.netbeans.modules.parsing.spi.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyHintsProvider
implements HintsProvider {
    public static final Logger LOG = Logger.getLogger(GroovyHintsProvider.class.getName());
    private boolean cancelled;

    public RuleContext createRuleContext() {
        return new GroovyRuleContext();
    }

    public void computeHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list) {
    }

    public void computeSuggestions(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n, int n2) {
        this.cancelled = false;
        ParserResult parserResult = ruleContext.parserResult;
        if (parserResult == null) {
            return;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        if (moduleNode == null) {
            return;
        }
        List list2 = hintsManager.getSelectionHints();
        if (list2.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        this.applyRules(ruleContext, list2, n, n2, list);
    }

    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        LOG.log(Level.FINEST, "@@@ computeErrors()");
        ParserResult parserResult = ruleContext.parserResult;
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (groovyParserResult == null) {
            return;
        }
        List<? extends Error> list3 = groovyParserResult.getDiagnostics();
        LOG.log(Level.FINEST, "@@@ errors.size() : {0}", list3.size());
        if (list3 == null || list3.size() == 0) {
            return;
        }
        this.cancelled = false;
        Map map = hintsManager.getErrors();
        if (map.isEmpty() || this.isCancelled()) {
            list2.addAll(list3);
            return;
        }
        LOG.log(Level.FINEST, "@@@ hints.size() : {0}", map.size());
        for (Error error : list3) {
            if (!(error instanceof GroovyError)) continue;
            LOG.log(Level.FINEST, "@@@ ----------------------------------------------------\n");
            LOG.log(Level.FINEST, "@@@ error.getDescription()   : {0}\n", error.getDescription());
            LOG.log(Level.FINEST, "@@@ error.getKey()           : {0}\n", error.getKey());
            LOG.log(Level.FINEST, "@@@ error.getDisplayName()   : {0}\n", error.getDisplayName());
            LOG.log(Level.FINEST, "@@@ error.getStartPosition() : {0}\n", error.getStartPosition());
            LOG.log(Level.FINEST, "@@@ error.getEndPosition()   : {0}\n", error.getEndPosition());
            if (this.applyRules((GroovyError)error, ruleContext, map, list)) continue;
            LOG.log(Level.FINEST, "@@@ Adding error to unhandled");
            list2.add(error);
        }
        LOG.log(Level.FINEST, "@@@ result.size() =  {0}", list.size());
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    private void applyRules(RuleContext ruleContext, List<GroovySelectionRule> list, int n, int n2, List<Hint> list2) {
        GroovyRuleContext groovyRuleContext = (GroovyRuleContext)ruleContext;
        for (GroovySelectionRule groovySelectionRule : list) {
            if (!groovySelectionRule.appliesTo(ruleContext)) continue;
            groovySelectionRule.run(groovyRuleContext, list2);
        }
    }

    private boolean applyRules(GroovyError groovyError, RuleContext ruleContext, Map<GroovyCompilerErrorID, List<GroovyErrorRule>> map, List<Hint> list) {
        List<GroovyErrorRule> list2;
        LOG.log(Level.FINEST, "applyRules(...)");
        GroovyCompilerErrorID groovyCompilerErrorID = groovyError.getId();
        if (groovyCompilerErrorID != null && (list2 = map.get((Object)groovyCompilerErrorID)) != null) {
            int n = list.size();
            GroovyRuleContext groovyRuleContext = (GroovyRuleContext)ruleContext;
            for (GroovyErrorRule groovyErrorRule : list2) {
                if (!groovyErrorRule.appliesTo(ruleContext)) continue;
                groovyErrorRule.run(groovyRuleContext, groovyError, list);
            }
            return n < list.size();
        }
        return false;
    }
}

