/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.creator;

import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringUtils;
import hidden.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.index.ArtifactAvailablility;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.LegacyDocumentUpdater;
import org.sonatype.nexus.index.locator.JavadocLocator;
import org.sonatype.nexus.index.locator.Locator;
import org.sonatype.nexus.index.locator.Sha1Locator;
import org.sonatype.nexus.index.locator.SignatureLocator;
import org.sonatype.nexus.index.locator.SourcesLocator;

@Component(role=IndexCreator.class, hint="min")
public class MinimalArtifactInfoIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    private ModelReader modelReader = new ModelReader();
    private Locator jl = new JavadocLocator();
    private Locator sl = new SourcesLocator();
    private Locator sigl = new SignatureLocator();
    private Locator sha1l = new Sha1Locator();

    public void populateArtifactInfo(ArtifactContext ac) {
        File artifact = ac.getArtifact();
        File pom = ac.getPom();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (pom != null) {
            Model model = this.modelReader.readModel(pom, ai.groupId, ai.artifactId, ai.version);
            if (model != null) {
                ai.name = model.getName();
                ai.description = model.getDescription();
                if (model.getPackaging() != null && ai.classifier == null) {
                    ai.packaging = model.getPackaging();
                }
            }
            ai.lastModified = pom.lastModified();
            ai.fextension = "pom";
        }
        if (pom != null) {
            if (ai.classifier != null) {
                ai.sourcesExists = ArtifactAvailablility.NOT_AVAILABLE;
                ai.javadocExists = ArtifactAvailablility.NOT_AVAILABLE;
            } else {
                File sources = this.sl.locate(pom);
                ai.sourcesExists = !sources.exists() ? ArtifactAvailablility.NOT_PRESENT : ArtifactAvailablility.PRESENT;
                File javadoc = this.jl.locate(pom);
                ai.javadocExists = !javadoc.exists() ? ArtifactAvailablility.NOT_PRESENT : ArtifactAvailablility.PRESENT;
            }
        }
        if (artifact != null) {
            File signature = this.sigl.locate(artifact);
            ai.signatureExists = signature.exists() ? ArtifactAvailablility.PRESENT : ArtifactAvailablility.NOT_PRESENT;
            File sha1 = this.sha1l.locate(artifact);
            if (sha1.exists()) {
                try {
                    ai.sha1 = StringUtils.chomp((String)FileUtils.fileRead((File)sha1)).trim().split(" ")[0];
                }
                catch (IOException e) {
                    ac.addError(e);
                }
            }
            ai.lastModified = artifact.lastModified();
            ai.size = artifact.length();
            ai.fextension = this.getExtension(artifact, ac.getGav());
            if (ai.packaging == null) {
                ai.packaging = ai.fextension;
            }
        }
        this.checkMavenPlugin(ai, artifact);
    }

    private String getExtension(File artifact, Gav gav) {
        if (gav != null) {
            return gav.getExtension();
        }
        String artifactFileName = artifact.getName().toLowerCase();
        if (artifactFileName.endsWith("tar.gz")) {
            return "tar.gz";
        }
        if (artifactFileName.equals("tar.bz2")) {
            return "tar.bz2";
        }
        return FileUtils.getExtension((String)artifactFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMavenPlugin(ArtifactInfo ai, File artifact) {
        ZipEntry entry;
        BufferedInputStream is;
        ZipFile jf;
        block7: {
            if (!"maven-plugin".equals(ai.packaging) || artifact == null) {
                return;
            }
            jf = null;
            is = null;
            jf = new ZipFile(artifact);
            entry = jf.getEntry("META-INF/maven/plugin.xml");
            if (entry != null) break block7;
            this.close(jf);
            IOUtil.close(is);
            return;
        }
        try {
            PlexusConfiguration[] mojoConfigs;
            is = new BufferedInputStream(jf.getInputStream(entry));
            XmlPlexusConfiguration plexusConfig = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)new InputStreamReader(is)));
            ai.prefix = plexusConfig.getChild("goalPrefix").getValue();
            ai.goals = new ArrayList<String>();
            for (PlexusConfiguration mojoConfig : mojoConfigs = plexusConfig.getChild("mojos").getChildren("mojo")) {
                ai.goals.add(mojoConfig.getChild("goal").getValue());
            }
            this.close(jf);
        }
        catch (Exception e) {
            try {
                this.getLogger().info("Failed to parsing Maven plugin " + artifact.getAbsolutePath(), (Throwable)e);
                this.close(jf);
            }
            catch (Throwable throwable) {
                this.close(jf);
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
        IOUtil.close((InputStream)is);
    }

    public void updateDocument(ArtifactInfo ai, Document doc) {
        String info = ai.packaging + "|" + Long.toString(ai.lastModified) + "|" + Long.toString(ai.size) + "|" + ai.sourcesExists.toString() + "|" + ai.javadocExists.toString() + "|" + ai.signatureExists.toString() + "|" + ai.fextension;
        doc.add((Fieldable)new Field("i", info, Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("g", ai.groupId, Field.Store.NO, Field.Index.TOKENIZED));
        doc.add((Fieldable)new Field("a", ai.artifactId, Field.Store.NO, Field.Index.TOKENIZED));
        doc.add((Fieldable)new Field("v", ai.version, Field.Store.NO, Field.Index.TOKENIZED));
        if (ai.name != null) {
            doc.add((Fieldable)new Field("n", ai.name, Field.Store.YES, Field.Index.NO));
        }
        if (ai.description != null) {
            doc.add((Fieldable)new Field("d", ai.description, Field.Store.YES, Field.Index.NO));
        }
        if (ai.packaging != null) {
            doc.add((Fieldable)new Field("p", ai.packaging, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
        if (ai.classifier != null) {
            doc.add((Fieldable)new Field("l", ai.classifier, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
        if (ai.prefix != null) {
            doc.add((Fieldable)new Field("px", ai.prefix, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
        if (ai.goals != null) {
            doc.add((Fieldable)new Field("gx", ArtifactInfo.lst2str(ai.goals), Field.Store.YES, Field.Index.NO));
        }
        if (ai.sha1 != null) {
            doc.add((Fieldable)new Field("1", ai.sha1, Field.Store.YES, Field.Index.UN_TOKENIZED));
        }
    }

    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        this.updateDocument(ai, doc);
        doc.removeField("g");
        doc.add((Fieldable)new Field("g", ai.groupId, Field.Store.NO, Field.Index.UN_TOKENIZED));
    }

    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        String sha1;
        String description;
        String name;
        String info;
        boolean res = false;
        String uinfo = doc.get("u");
        if (uinfo != null) {
            String[] r = ArtifactInfo.FS_PATTERN.split(uinfo);
            ai.groupId = r[0];
            ai.artifactId = r[1];
            ai.version = r[2];
            if (r.length > 3) {
                ai.classifier = ArtifactInfo.renvl(r[3]);
            }
            res = true;
        }
        if ((info = doc.get("i")) != null) {
            String[] r = ArtifactInfo.FS_PATTERN.split(info);
            ai.packaging = r[0];
            ai.lastModified = Long.parseLong(r[1]);
            ai.size = Long.parseLong(r[2]);
            ai.sourcesExists = ArtifactAvailablility.fromString(r[3]);
            ai.javadocExists = ArtifactAvailablility.fromString(r[4]);
            ai.signatureExists = ArtifactAvailablility.fromString(r[5]);
            ai.fextension = r.length > 6 ? r[6] : (ai.classifier != null || "pom".equals(ai.packaging) || "war".equals(ai.packaging) || "ear".equals(ai.packaging) ? ai.packaging : "jar");
            if ("maven-plugin".equals(ai.packaging)) {
                ai.prefix = doc.get("px");
                String goals = doc.get("gx");
                if (goals != null) {
                    ai.goals = ArtifactInfo.str2lst(goals);
                }
            }
            res = true;
        }
        if ((name = doc.get("n")) != null) {
            ai.name = name;
            res = true;
        }
        if ((description = doc.get("d")) != null) {
            ai.description = description;
            res = true;
        }
        if ("null".equals(ai.packaging)) {
            ai.packaging = null;
        }
        if ((sha1 = doc.get("1")) != null) {
            ai.sha1 = sha1;
        }
        return res;
    }

    private void close(ZipFile zf) {
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "min";
    }

    public static class ModelReader {
        private final HashMap<File, Model> models = new HashMap();

        public Model getModel(File pom, String groupId, String artifactId, String version) {
            Model model = this.models.get(pom);
            if (model == null) {
                model = this.readModel(pom, groupId, artifactId, version);
                this.models.put(pom, model);
            }
            return model;
        }

        public Model readModel(File pom, String groupId, String artifactId, String version) {
            Xpp3Dom dom = this.readPom(pom);
            if (dom == null) {
                return null;
            }
            String packaging = null;
            if (dom.getChild("packaging") != null) {
                packaging = dom.getChild("packaging").getValue();
            }
            Model model = new Model();
            model.setPackaging(packaging);
            if (dom.getChild("name") != null) {
                model.setName(dom.getChild("name").getValue());
            }
            if (dom.getChild("description") != null) {
                model.setDescription(dom.getChild("description").getValue());
            }
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Xpp3Dom readPom(File pom) {
            FileReader r = null;
            try {
                r = new FileReader(pom);
                Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)r);
                return xpp3Dom;
            }
            catch (Exception e) {
            }
            finally {
                if (r != null) {
                    try {
                        ((Reader)r).close();
                    }
                    catch (IOException ex) {}
                }
            }
            return null;
        }
    }
}

