/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.event;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.Util;

public final class TreeEventChangeSupport {
    private PropertyChangeSupport propertyChangeSupport;
    private TreeObject eventSource;
    private EventCache eventCache;

    public TreeEventChangeSupport(TreeObject treeObject) {
        this.eventSource = treeObject;
        this.eventCache = new EventCache();
    }

    public final TreeEvent createEvent(String string, Object object, Object object2) {
        return new TreeEvent(this.eventSource, string, object, object2);
    }

    protected final TreeObject getEventSource() {
        return this.eventSource;
    }

    private final PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this.eventSource);
        }
        return this.propertyChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::addPropertyChangeListener: listener = " + propertyChangeListener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
            if (propertyChangeListener == null) {
                Util.THIS.debug("    eventSource = " + this.eventSource);
            }
        }
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::addPropertyChangeListener: propertyName = " + string);
            Util.THIS.debug("    listener = " + propertyChangeListener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
            if (propertyChangeListener == null) {
                Util.THIS.debug("    eventSource = " + this.eventSource);
                Util.THIS.debug(new RuntimeException("TreeEventChangeSupport.addPropertyChangeListener"));
            }
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::removePropertyChangeListener: listener = " + propertyChangeListener);
            Util.THIS.debug("    propertyChangeSupport = " + this.listListeners());
        }
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::removePropertyChangeListener: propertyName = " + string);
            Util.THIS.debug("    listener = " + propertyChangeListener);
            Util.THIS.debug("-                       ::removePropertyChangeListener: propertyChangeSupport = " + this.listListeners());
        }
    }

    public final boolean hasPropertyChangeListeners(String string) {
        return this.getPropertyChangeSupport().hasListeners(string);
    }

    public final void firePropertyChange(TreeEvent treeEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeEventChangeSupport::firePropertyChange ( " + treeEvent + " )");
            Util.THIS.debug("    eventSource  = " + this.eventSource);
            Util.THIS.debug("    EventManager = " + this.eventSource.getEventManager());
        }
        if (this.eventSource.getEventManager() == null) {
            return;
        }
        this.eventSource.getEventManager().firePropertyChange(this, treeEvent);
    }

    protected final void firePropertyChangeNow(TreeEvent treeEvent) {
        this.getPropertyChangeSupport().firePropertyChange(treeEvent);
    }

    protected final void firePropertyChangeLater(TreeEvent treeEvent) {
        this.eventCache.addEvent(treeEvent);
    }

    protected final void firePropertyChangeCache() {
        this.eventCache.firePropertyChange();
    }

    protected final void clearPropertyChangeCache() {
        this.eventCache.clear();
    }

    private String listListeners(Object object) {
        try {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("listeners");
            field.setAccessible(true);
            return field.get(object).toString();
        }
        catch (Exception exception) {
            return "" + exception.getClass() + " " + exception.getMessage();
        }
    }

    private String listChildrenListeners(PropertyChangeSupport propertyChangeSupport) {
        try {
            PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport;
            Class<?> clazz = propertyChangeSupport2.getClass();
            Field field = clazz.getDeclaredField("children");
            field.setAccessible(true);
            StringBuffer stringBuffer = new StringBuffer();
            Map map = (Map)field.get(propertyChangeSupport2);
            if (map == null) {
                return "";
            }
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                stringBuffer.append("\n[").append(k).append("] ").append(this.listListeners(map.get(k)));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "<" + exception + ">";
        }
    }

    public final String listListeners() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[*general*] ").append(this.listListeners(this.getPropertyChangeSupport())).append("\n");
        stringBuffer.append(this.listChildrenListeners(this.getPropertyChangeSupport()));
        return stringBuffer.toString();
    }

    private class EventCache {
        List eventList = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List list = this.eventList;
            synchronized (list) {
                this.eventList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(TreeEvent treeEvent) {
            List list = this.eventList;
            synchronized (list) {
                this.eventList.add(treeEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void firePropertyChange() {
            LinkedList linkedList;
            Object object = this.eventList;
            synchronized (object) {
                linkedList = new LinkedList(this.eventList);
                this.eventList.clear();
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                TreeEventChangeSupport.this.firePropertyChangeNow((TreeEvent)object.next());
            }
        }
    }
}

