/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserSupport {
    private static final boolean isBrowseSupported;
    private static final Method browseMethod;
    private static final Object desktop;
    private static final Logger LOG;

    public static boolean isSupported() {
        return isBrowseSupported;
    }

    public static void browse(URI uRI) throws IOException {
        block8: {
            if (uRI == null) {
                throw new NullPointerException("null uri");
            }
            if (!BrowserSupport.isSupported()) {
                throw new UnsupportedOperationException("Browse operation is not supported");
            }
            try {
                browseMethod.invoke(desktop, uRI);
            }
            catch (IllegalAccessException illegalAccessException) {
                InternalError internalError = new InternalError("Desktop.getDesktop() method not found");
                internalError.initCause(illegalAccessException);
                throw internalError;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) break block8;
                if (throwable instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (!(throwable instanceof SecurityException)) break block8;
                throw (SecurityException)throwable;
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.reglib.BrowserSupport");
        boolean bl = false;
        Method method = null;
        Object object = null;
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop", true, null);
            Method method2 = clazz.getMethod("getDesktop", new Class[0]);
            method = clazz.getMethod("browse", URI.class);
            Class<?> clazz2 = Class.forName("java.awt.Desktop$Action", true, null);
            Method method3 = clazz.getMethod("isDesktopSupported", new Class[0]);
            Method method4 = clazz.getMethod("isSupported", clazz2);
            Field field = clazz2.getField("BROWSE");
            Boolean bl2 = (Boolean)method3.invoke(null, new Object[0]);
            if (bl2.booleanValue()) {
                object = method2.invoke(null, new Object[0]);
                bl2 = (Boolean)method4.invoke(object, field.get(null));
                bl = bl2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, "Browser not supported:");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.log(Level.INFO, "Browser not supported:");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            LOG.log(Level.INFO, "Browser not supported:");
        }
        catch (IllegalAccessException illegalAccessException) {
            InternalError internalError = new InternalError("Desktop.getDesktop() method not found");
            internalError.initCause(illegalAccessException);
            throw internalError;
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.log(Level.INFO, "Browser not supported:");
        }
        isBrowseSupported = bl;
        browseMethod = method;
        desktop = object;
    }
}

