/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.netbeans.modules.php.dbgp.URIMapper;
import org.netbeans.modules.php.project.api.Pair;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionId {
    private static final String SOURCES_TYPE_PHP = "PHPSOURCE";
    private URIMapper.MultiMapper uriMapper;
    private String id = this.getSessionPrefix();
    private final FileObject sessionFileObject;

    public SessionId(FileObject fileObject) {
        this.sessionFileObject = fileObject;
    }

    public String getId() {
        return this.id;
    }

    public Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.sessionFileObject);
    }

    synchronized void initialize(String string, List<Pair<String, String>> list) {
        Object object;
        if (this.uriMapper == null) {
            object = this.getProject();
            FileObject fileObject = object != null ? this.getSourceRoot() : this.sessionFileObject.getParent();
            this.uriMapper = URIMapper.createMultiMapper(URI.create(string), this.sessionFileObject, fileObject, list);
        }
        this.notifyAll();
        object = SessionProgress.forSessionId(this);
        if (object != null) {
            ((SessionProgress)object).notifyConnectionFinished();
        }
    }

    public synchronized boolean isInitialized(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.uriMapper != null;
        if (!bl2 && bl) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            bl2 = this.uriMapper != null;
        }
        return bl2;
    }

    public String toWebServerURI(FileObject fileObject) {
        if (this.uriMapper != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            assert (file != null);
            URI uRI = this.uriMapper.toWebServerURI(file);
            if (uRI != null) {
                return uRI.toString();
            }
        }
        return null;
    }

    public FileObject toSourceFile(String string) {
        if (this.uriMapper != null) {
            File file = this.uriMapper.toSourceFile(URI.create(string));
            file = file != null ? FileUtil.normalizeFile((File)file) : null;
            return file != null ? FileUtil.toFileObject((File)file) : null;
        }
        return null;
    }

    private FileObject getSourceRoot() {
        FileObject[] fileObjectArray = SessionId.getSourceObjects(this.getProject());
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    private static FileObject[] getSourceObjects(Project project) {
        SourceGroup[] sourceGroupArray = SessionId.getSourceGroups(project);
        FileObject[] fileObjectArray = new FileObject[sourceGroupArray.length];
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            fileObjectArray[i] = sourceGroupArray[i].getRootFolder();
        }
        return fileObjectArray;
    }

    private static SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups(SOURCES_TYPE_PHP);
        return sourceGroupArray;
    }

    private String getSessionPrefix() {
        return PhpOptions.getInstance().getDebuggerSessionId();
    }
}

