/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public abstract class SingleThread
extends ThreadPoolExecutor
implements Runnable {
    private final Object sync = new Object();
    private FutureTask task;

    public SingleThread() {
        super(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(SingleThread.getDaemonThreadFactory());
        this.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy(){

            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                super.rejectedExecution(runnable, threadPoolExecutor);
                Logger.getLogger(this.getClass().getName()).info("rejectedExecution");
            }
        });
    }

    public static ThreadFactory getDaemonThreadFactory() {
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                ThreadFactory threadFactory = Executors.defaultThreadFactory();
                Thread thread = threadFactory.newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public Object getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FutureTask invokeLater() {
        Object object = this.sync;
        synchronized (object) {
            this.task = new FutureTask<Object>(this, null);
            this.execute(this.task);
            return this.task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeAneWait() throws InterruptedException, ExecutionException {
        Object object = this.sync;
        synchronized (object) {
            this.task = new FutureTask<Object>(this, null);
            this.execute(this.task);
            this.task.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitFinished() {
        Object object = this.sync;
        synchronized (object) {
            if (this.task != null) {
                this.cancel();
                try {
                    this.task.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
                catch (TimeoutException timeoutException) {
                    Exceptions.printStackTrace((Throwable)timeoutException);
                }
            }
        }
    }

    public abstract void cancel();
}

