/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.ClearingThread;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.models.WeakProxyListener;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchesModel
extends ViewModelSupport
implements TreeModel,
NodeModel,
TableModel {
    private Listener myListener;
    private ContextProvider myLookupProvider;
    private Map<Watch, ScriptWatchEvaluating> myWatches = new WeakHashMap<Watch, ScriptWatchEvaluating>();
    private AtomicReference<ScriptWatchEvaluating[]> myWatcheNodes;
    private static final ClearingThread<Listener> CLERAING_THREAD = new ClearingThread();

    public WatchesModel(ContextProvider contextProvider) {
        this.myLookupProvider = contextProvider;
        this.myWatcheNodes = new AtomicReference();
    }

    @Override
    public void clearModel() {
        this.fireTreeChanged();
    }

    public void updateExpressionValue(String string, Property property) {
        ScriptWatchEvaluating[] scriptWatchEvaluatingArray = this.myWatcheNodes.get();
        if (scriptWatchEvaluatingArray == null) {
            return;
        }
        for (ScriptWatchEvaluating scriptWatchEvaluating : scriptWatchEvaluatingArray) {
            String string2 = scriptWatchEvaluating.getExpression();
            if (!string.equals(string2)) continue;
            scriptWatchEvaluating.setEvaluated(property);
            this.fireTableValueChangedComputed(scriptWatchEvaluating, null);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            n2 = Math.min(watchArray.length, n2);
            n = Math.min(watchArray.length, n);
            Watch[] watchArray2 = new Watch[n2 - n];
            System.arraycopy(watchArray, n, watchArray2, 0, n2 - n);
            Object[] objectArray = this.getEvaluatingWatches(watchArray2);
            if (this.myListener == null) {
                this.myListener = new Listener();
            }
            this.myWatcheNodes.set((ScriptWatchEvaluating[])objectArray);
            return objectArray;
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getChildren(n, n2);
        }
        throw new UnknownTypeException((Object)(object + " " + object.getClass().getName()));
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            if (this.myListener == null) {
                this.myListener = new Listener();
            }
            return Integer.MAX_VALUE;
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getChildrenSize();
        }
        throw new UnknownTypeException((Object)(object + " " + object.getClass().getName()));
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getChildrenSize() == 0;
        }
        throw new UnknownTypeException((Object)(object + " " + object.getClass().getName()));
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof JToolTip) {
            return this.getTooltip((JToolTip)object, string);
        }
        if ("WatchType".equals(string)) {
            if (object instanceof ModelNode) {
                return ((ModelNode)object).getType();
            }
        } else if ("WatchValue".equals(string) && object instanceof ModelNode) {
            String string2;
            try {
                string2 = ((ModelNode)object).getValue();
            }
            catch (UnsufficientValueException unsufficientValueException) {
                return "null";
            }
            return string2 == null ? "null" : string2;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == null) {
            return "null";
        }
        if (object == "Root") {
            return "Root";
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getName();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == null || object == "Root") {
            return "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getIconBase();
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == null || object == "Root") {
            return null;
        }
        if (object instanceof ModelNode) {
            return ((ModelNode)object).getShortDescription();
        }
        throw new UnknownTypeException(object);
    }

    private String getTooltip(JToolTip jToolTip, String string) throws UnknownTypeException {
        Object object = jToolTip.getClientProperty("getShortDescription");
        if ("WatchType".equals(string) && object instanceof ModelNode) {
            return ((ModelNode)object).getType();
        }
        throw new UnknownTypeException((Object)jToolTip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Map<Watch, ScriptWatchEvaluating> map = this.getWatchesMap();
        synchronized (map) {
            for (ScriptWatchEvaluating scriptWatchEvaluating : this.getWatchesMap().values()) {
                scriptWatchEvaluating.requestValue();
            }
        }
        this.fireChangeEvent((ModelEvent)new ModelEvent.TreeChanged((Object)this));
    }

    private void fireWatchesChanged() {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8));
    }

    void fireTableValueChanged(Object object, String string) {
        ((ScriptWatchEvaluating)object).requestValue();
        this.fireTableValueChangedComputed(object, string);
    }

    private void fireTableValueChangedComputed(Object object, String string) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
    }

    private ScriptWatchEvaluating[] getEvaluatingWatches(Watch[] watchArray) {
        ScriptWatchEvaluating[] scriptWatchEvaluatingArray = new ScriptWatchEvaluating[watchArray.length];
        int n = 0;
        for (Watch watch : watchArray) {
            ScriptWatchEvaluating scriptWatchEvaluating = this.getWatchesMap().get(watch);
            if (scriptWatchEvaluating == null) {
                scriptWatchEvaluating = new ScriptWatchEvaluating(this.myLookupProvider, watch);
                this.getWatchesMap().put(watchArray[n], scriptWatchEvaluating);
            }
            scriptWatchEvaluatingArray[n++] = scriptWatchEvaluating;
        }
        return scriptWatchEvaluatingArray;
    }

    private Map<Watch, ScriptWatchEvaluating> getWatchesMap() {
        return this.myWatches;
    }

    static /* synthetic */ ClearingThread access$100() {
        return CLERAING_THREAD;
    }

    static {
        CLERAING_THREAD.start();
    }

    class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakProxyListener<Listener> myListener = new WeakProxyListener<Listener>(this, (ReferenceQueue<Listener>)WatchesModel.access$100().getQueue());

        private Listener() {
            Watch[] watchArray;
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", this.myListener);
            for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener(this.myListener);
            }
        }

        public void watchAdded(Watch watch) {
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            WatchesModel.this.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            WatchesModel.this.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("watches".equals(string)) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Watch) {
                Object v;
                Map map = WatchesModel.this.getWatchesMap();
                synchronized (map) {
                    v = WatchesModel.this.getWatchesMap().get(propertyChangeEvent.getSource());
                }
                if (v != null) {
                    WatchesModel.this.fireTableValueChanged(v, null);
                    return;
                }
            }
            this.myListener.setupTask();
        }

        void fireTreeChanged() {
            WatchesModel.this.fireTreeChanged();
        }
    }

    private static class ScriptWatchEvaluating
    extends org.netbeans.modules.php.dbgp.models.nodes.ScriptWatchEvaluating {
        protected ScriptWatchEvaluating(ContextProvider contextProvider, Watch watch) {
            super(contextProvider, watch);
        }

        protected synchronized void setEvaluated(Property property) {
            super.setEvaluated(property);
        }

        protected void requestValue() {
            super.requestValue();
        }
    }
}

