/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ArrayVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.BaseVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.NullVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ObjectVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ResourceVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.ScalarTypeVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.StringVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.UndefinedVariableNode;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.spi.viewmodel.ModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelNode {
    private static final String RESOURCE = "resource";
    private static final String OBJECT = "object";
    private static final String ARRAY = "array";
    private static final String STRING = "string";
    private static final String UNDEF = "uninitialized";
    private static final String NULL = "null";
    private List<AbstractVariableNode> myVars;
    private AbstractModelNode myParent;

    AbstractModelNode(AbstractModelNode abstractModelNode, List<Property> list) {
        this.myParent = abstractModelNode;
        this.initVariables(list);
    }

    public AbstractModelNode getParent() {
        return this.myParent;
    }

    public boolean hasType(Set<VariablesModelFilter.FilterType> set) {
        return this.isTypeApplied(set);
    }

    public static VariablesModel.AbstractVariableNode createVariable(Property property, AbstractModelNode abstractModelNode) {
        String string = property.getType();
        if (STRING.equals(string)) {
            return new StringVariableNode(property, abstractModelNode);
        }
        if (ARRAY.equals(string)) {
            return new ArrayVariableNode(property, abstractModelNode);
        }
        if (UNDEF.equals(string)) {
            return new UndefinedVariableNode(property, abstractModelNode);
        }
        if (NULL.equals(string)) {
            return new NullVariableNode(property, abstractModelNode);
        }
        if (OBJECT.equals(string)) {
            return new ObjectVariableNode(property, abstractModelNode);
        }
        if (RESOURCE.equals(string)) {
            return new ResourceVariableNode(property, abstractModelNode);
        }
        if ("boolean".equals(string) || "bool".equals(string) || "integer".equals(string) || "int".equals(string) || "float".equals(string)) {
            return new ScalarTypeVariableNode(property, abstractModelNode);
        }
        return new BaseVariableNode(property, abstractModelNode);
    }

    protected abstract boolean isTypeApplied(Set<VariablesModelFilter.FilterType> var1);

    protected List<AbstractVariableNode> getVariables() {
        return this.myVars;
    }

    protected void initVariables(List<Property> list) {
        if (list == null) {
            return;
        }
        this.myVars = new ArrayList<AbstractVariableNode>();
        for (Property property : list) {
            VariablesModel.AbstractVariableNode abstractVariableNode = AbstractModelNode.createVariable(property, this);
            this.myVars.add(abstractVariableNode);
        }
    }

    protected void setVars(List<AbstractVariableNode> list) {
        this.myVars = list;
    }

    protected boolean addAbsentChildren(AbstractModelNode abstractModelNode) {
        boolean bl = false;
        if (abstractModelNode.getVariables() != null && abstractModelNode.getVariables().size() > 0) {
            for (AbstractVariableNode abstractVariableNode : abstractModelNode.getVariables()) {
                this.getVariables().add(abstractVariableNode);
                bl = true;
            }
        }
        return bl;
    }

    protected boolean updateExistedChildren(VariablesModel variablesModel, AbstractModelNode abstractModelNode, Collection<ModelEvent> collection) {
        boolean bl = false;
        ArrayList<AbstractVariableNode> arrayList = new ArrayList<AbstractVariableNode>(this.getVariables());
        int n = 0;
        for (AbstractVariableNode abstractVariableNode : arrayList) {
            Property property = abstractVariableNode.getProperty();
            int n2 = abstractModelNode.findChild(property);
            if (n2 == -1) {
                this.getVariables().remove(n);
                bl = true;
                continue;
            }
            AbstractVariableNode abstractVariableNode2 = abstractModelNode.getVariables().get(n2);
            Property property2 = abstractVariableNode2.getProperty();
            if (property.getType().equals(property2.getType())) {
                abstractModelNode.getVariables().remove(n2);
                abstractVariableNode.collectUpdates(variablesModel, abstractVariableNode2, collection);
            } else {
                this.getVariables().remove(n);
                this.getVariables().add(n, abstractVariableNode2);
                abstractModelNode.getVariables().remove(n2);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    protected boolean updatePage(AbstractVariableNode abstractVariableNode) {
        Property property = abstractVariableNode.getProperty();
        if (property.getPageSize() > 0 && property.getPage() > 0) {
            this.addAbsentChildren(abstractVariableNode);
            return true;
        }
        return false;
    }

    protected int findChild(Property property) {
        int n = 0;
        for (AbstractVariableNode abstractVariableNode : this.getVariables()) {
            String string;
            Property property2 = abstractVariableNode.getProperty();
            String string2 = string = property2 != null ? property2.getName() : null;
            if (string != null && string.equals(property.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

