/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openidex.search.CompoundSearchInfo;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SharabilityFilter;
import org.openidex.search.SimpleSearchInfo;
import org.openidex.search.SubnodesSearchInfo;
import org.openidex.search.VisibilityFilter;

public final class SearchInfoFactory {
    public static final FileObjectFilter VISIBILITY_FILTER = new VisibilityFilter();
    public static final FileObjectFilter SHARABILITY_FILTER = new SharabilityFilter();

    private SearchInfoFactory() {
    }

    public static SearchInfo createSearchInfo(FileObject fileObject, boolean bl, FileObjectFilter[] fileObjectFilterArray) {
        DataFolder dataFolder;
        if (fileObject == null) {
            throw new IllegalArgumentException("folder is <null>");
        }
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        try {
            dataFolder = DataFolder.findFolder((FileObject)fileObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO;
        }
        return new SimpleSearchInfo(dataFolder, bl, fileObjectFilterArray);
    }

    public static SearchInfo createSearchInfo(FileObject[] fileObjectArray, boolean bl, FileObjectFilter[] fileObjectFilterArray) {
        if (fileObjectArray.length == 0) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO;
        }
        if (fileObjectArray.length == 1) {
            return SearchInfoFactory.createSearchInfo(fileObjectArray[0], bl, fileObjectFilterArray);
        }
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isFolder()) continue;
            throw new IllegalArgumentException("folder expected (index " + i + ')');
        }
        SearchInfo[] searchInfoArray = new SearchInfo[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            searchInfoArray[i] = SearchInfoFactory.createSearchInfo(fileObjectArray[i], bl, fileObjectFilterArray);
        }
        return new CompoundSearchInfo(searchInfoArray);
    }

    public static SearchInfo createSearchInfoBySubnodes(Node node) {
        return new SubnodesSearchInfo(node);
    }

    public static SearchInfo createCompoundSearchInfo(SearchInfo ... searchInfoArray) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException("null");
        }
        return new CompoundSearchInfo(searchInfoArray);
    }
}

