/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.codecoverage;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.codecoverage.CoverageManagerImpl;
import org.netbeans.modules.gsf.codecoverage.api.CoverageProvider;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class CoverageAction
extends AbstractAction
implements ContextAwareAction {
    private static final int ACTION_TOGGLE_COLLECT = 1;
    private static final int ACTION_TOGGLE_AGGREGATION = 2;
    private static final int ACTION_CLEAR_RESULTS = 3;
    private static final int ACTION_SHOW_REPORT = 4;
    private static final int ACTION_TOGGLE_EDITORBAR = 5;
    private Action configureAction;
    private Action[] extraActions;

    public CoverageAction(Action action, Action[] actionArray) {
        this.configureAction = action;
        this.extraActions = actionArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false) : "Action should never be called without a context";
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup, this.configureAction, this.extraActions);
    }

    private static JMenu createMenu(Project project, Action action, Action[] actionArray) {
        return new LazyMenu(project, action, actionArray);
    }

    static void buildMenu(JMenu jMenu, Project project, Action action, Action[] actionArray) {
        Object object;
        boolean bl = true;
        if (action != null && action.isEnabled()) {
            bl = false;
            object = new JMenuItem((String)action.getValue("Name"));
            ((AbstractButton)object).addActionListener(action);
            jMenu.add((JMenuItem)object);
            jMenu.addSeparator();
            bl = false;
        }
        object = CoverageManagerImpl.getInstance();
        boolean bl2 = ((CoverageManagerImpl)object).isEnabled(project);
        JMenuItem jMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CollectCoverageAction"), bl2);
        jMenuItem.addActionListener(new CoverageItemHandler(project, 1));
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        CoverageProvider coverageProvider = CoverageManagerImpl.getProvider(project);
        if (coverageProvider == null) {
            return;
        }
        boolean bl3 = coverageProvider.isEnabled();
        if (coverageProvider.supportsAggregation()) {
            jMenu.addSeparator();
            boolean bl4 = ((CoverageManagerImpl)object).isAggregating(project);
            jMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_AggregateResults"), bl4);
            jMenuItem.addActionListener(new CoverageItemHandler(project, 2));
            if (!bl || !bl3) {
                jMenuItem.setEnabled(false);
            }
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ClearResultsAction"));
        jMenuItem.addActionListener(new CoverageItemHandler(project, 3));
        if (!bl || !bl3) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ShowReportAction"));
        jMenuItem.addActionListener(new CoverageItemHandler(project, 4));
        if (!bl || !bl3) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(CoverageAction.class, (String)"LBL_ShowEditorBar"), ((CoverageManagerImpl)object).getShowEditorBar());
        jMenuItem.addActionListener(new CoverageItemHandler(project, 5));
        if (!bl || !bl3) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem);
        if (actionArray != null && actionArray.length > 0) {
            jMenu.addSeparator();
            for (Action action2 : actionArray) {
                String string = (String)action2.getValue("Name");
                String string2 = "SwingSelectedKey";
                Boolean bl5 = (Boolean)action2.getValue(string2);
                jMenuItem = bl5 != null ? new JCheckBoxMenuItem(string, bl5) : new JMenuItem(string);
                jMenuItem.addActionListener(action);
                if (!bl || !bl3) {
                    jMenuItem.setEnabled(false);
                }
                jMenu.add(jMenuItem);
            }
        }
    }

    private static final class CoverageItemHandler
    implements ActionListener {
        private final Project project;
        private final int action;

        public CoverageItemHandler(Project project, int n) {
            this.project = project;
            this.action = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CoverageManagerImpl coverageManagerImpl = CoverageManagerImpl.getInstance();
            switch (this.action) {
                case 1: {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                    coverageManagerImpl.setEnabled(this.project, bl);
                    break;
                }
                case 2: {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                    coverageManagerImpl.setAggregating(this.project, bl);
                    break;
                }
                case 4: {
                    coverageManagerImpl.showReport(this.project);
                    break;
                }
                case 3: {
                    coverageManagerImpl.clear(this.project);
                    break;
                }
                case 5: {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                    coverageManagerImpl.setShowEditorBar(bl);
                    break;
                }
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final Project project;
        private boolean initialized = false;
        private Action configureAction;
        private Action[] extraActions;

        public LazyMenu(Project project, Action action, Action[] actionArray) {
            super(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CodeCoverage"));
            this.project = project;
            this.configureAction = action;
            this.extraActions = actionArray;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                CoverageAction.buildMenu(this, this.project, this.configureAction, this.extraActions);
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Project project;
        private Action configureAction;
        private Action[] extraActions;

        public ContextAction(Lookup lookup, Action action, Action[] actionArray) {
            super(NbBundle.getMessage(CoverageAction.class, (String)"LBL_CodeCoverage"));
            this.configureAction = action;
            this.extraActions = actionArray;
            Collection collection = lookup.lookupAll(Project.class);
            this.project = collection.size() == 1 ? (Project)collection.iterator().next() : null;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return CoverageAction.createMenu(this.project, this.configureAction, this.extraActions);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            assert (false) : "No modifications to enablement status permitted";
        }
    }
}

