/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sync;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.indicators.graph.Graph;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPanel;
import org.netbeans.modules.dlight.indicators.graph.Legend;
import org.openide.util.NbBundle;

class SyncIndicatorPanel {
    private static final Color THREADS_COLOR = GraphConfig.COLOR_4;
    private static final Color LOCKS_COLOR = GraphConfig.COLOR_1;
    private static final GraphDescriptor THREADS_DESCRIPTOR = new GraphDescriptor(THREADS_COLOR, NbBundle.getMessage(SyncIndicatorPanel.class, (String)"graph.description.threads"), GraphDescriptor.Kind.ABS_SURFACE);
    private static final GraphDescriptor LOCKS_DESCRIPTOR = new GraphDescriptor(LOCKS_COLOR, NbBundle.getMessage(SyncIndicatorPanel.class, (String)"graph.description.locks"), GraphDescriptor.Kind.ABS_SURFACE);
    private final Graph graph = SyncIndicatorPanel.createGraph();
    private final Legend legend = SyncIndicatorPanel.createLegend();
    private final GraphPanel<Graph, Legend> panel = new GraphPanel(SyncIndicatorPanel.getTitle(), (JComponent)this.graph, (JComponent)this.legend, null, this.graph.getVerticalAxis());

    SyncIndicatorPanel() {
    }

    public GraphPanel getPanel() {
        return this.panel;
    }

    private static String getTitle() {
        return NbBundle.getMessage(SyncIndicatorPanel.class, (String)"indicator.title");
    }

    private static Graph createGraph() {
        Graph graph = new Graph(2, null, new GraphDescriptor[]{THREADS_DESCRIPTOR, LOCKS_DESCRIPTOR});
        graph.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        Dimension dimension = new Dimension(80, 60);
        graph.setMinimumSize(dimension);
        graph.setPreferredSize(dimension);
        Dimension dimension2 = new Dimension(30, 80);
        graph.getVerticalAxis().setMinimumSize(dimension2);
        graph.getVerticalAxis().setPreferredSize(dimension2);
        return graph;
    }

    private static Legend createLegend() {
        Legend legend = new Legend(Arrays.asList(THREADS_DESCRIPTOR, LOCKS_DESCRIPTOR), Collections.emptyMap());
        return legend;
    }

    public void addData(int n, int n2) {
        int n3;
        for (n3 = this.graph.getUpperLimit(); n3 < n2; n3 *= 2) {
        }
        this.graph.setUpperLimit(n3);
        this.graph.addData(new int[]{n2, n});
    }
}

