/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.Utils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaHierarchyModel
extends DefaultTreeModel {
    private static final Logger LOG = Logger.getLogger(JavaHierarchyModel.class.getName());
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    static ElementHandle[] EMPTY_ELEMENTHANDLES_ARRAY = new ElementHandle[0];
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private FileObject fileObject;
    private ElementHandle[] elementHandles;

    public JavaHierarchyModel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        super(null);
        this.fileObject = fileObject;
        if (elementArray == null || elementArray.length == 0) {
            this.elementHandles = EMPTY_ELEMENTHANDLES_ARRAY;
        } else {
            ArrayList<ElementHandle> arrayList = new ArrayList<ElementHandle>(elementArray.length);
            for (Element element : elementArray) {
                arrayList.add(ElementHandle.create((Element)element));
            }
            this.elementHandles = arrayList.toArray(EMPTY_ELEMENTHANDLES_ARRAY);
        }
        this.update(elementArray, compilationInfo);
    }

    public void update() {
        this.update(this.elementHandles);
    }

    private void update(final ElementHandle[] elementHandleArray) {
        if (elementHandleArray == null && elementHandleArray.length == 0) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ArrayList<Element> arrayList = new ArrayList<Element>(elementHandleArray.length);
                        for (ElementHandle elementHandle : elementHandleArray) {
                            Element element = elementHandle.resolve((CompilationInfo)compilationController);
                            if (element != null) {
                                arrayList.add(element);
                                continue;
                            }
                            LOG.warning(elementHandle.toString() + " cannot be resolved using: " + compilationController.getClasspathInfo());
                        }
                        Element[] elementArray = arrayList.toArray(EMPTY_ELEMENTS_ARRAY);
                        JavaHierarchyModel.this.update(elementArray, (CompilationInfo)compilationController);
                    }
                }, true);
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private void update(Element[] elementArray, CompilationInfo compilationInfo) {
        if (elementArray == null && elementArray.length == 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        for (Element element : elementArray) {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM && element.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            if (JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                defaultMutableTreeNode.add(new TypeTreeNode(this.fileObject, (TypeElement)element, compilationInfo, null));
                continue;
            }
            Types types = compilationInfo.getTypes();
            TypeElement typeElement = (TypeElement)element;
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
            arrayList.add(typeElement);
            TypeElement typeElement2 = (TypeElement)types.asElement(typeElement.getSuperclass());
            while (typeElement2 != null) {
                arrayList.add(0, typeElement2);
                typeElement2 = (TypeElement)types.asElement(typeElement2.getSuperclass());
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            for (TypeElement typeElement3 : arrayList) {
                FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement3), (ClasspathInfo)compilationInfo.getClasspathInfo());
                SimpleTypeTreeNode simpleTypeTreeNode = new SimpleTypeTreeNode(fileObject, typeElement3, compilationInfo, null, typeElement != typeElement3 || ((Object)typeElement.getQualifiedName()).equals(Object.class.getName()));
                defaultMutableTreeNode2.insert(simpleTypeTreeNode, 0);
                defaultMutableTreeNode2 = simpleTypeTreeNode;
            }
            JavaMembersAndHierarchyOptions.setSubTypeHierarchyDepth(arrayList.size() + 2);
        }
        this.setRoot(defaultMutableTreeNode);
    }

    void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    private class SimpleTypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode) {
            this(fileObject, typeElement, compilationInfo, abstractHierarchyTreeNode, false);
        }

        SimpleTypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode, boolean bl) {
            super(fileObject, typeElement, compilationInfo, abstractHierarchyTreeNode, bl);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            if (this.inSuperClassRole) {
                return;
            }
            TypeElement typeElement = (TypeElement)element;
            if (typeElement.getQualifiedName().toString().equals(Object.class.getName())) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_WontShowSubTypesOfObject", (Object)Object.class.getName()));
                return;
            }
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            if (projectArray == null) {
                return;
            }
            LinkedHashSet<ElementHandle> linkedHashSet = new LinkedHashSet<ElementHandle>();
            ElementHandle elementHandle = ElementHandle.create((Element)typeElement);
            final int[] nArray = new int[]{0};
            for (Project project : projectArray) {
                Collection collection = project.getLookup().lookupAll(Sources.class);
                if (collection == null) continue;
                for (Sources sources : collection) {
                    SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                    if (sourceGroupArray == null) continue;
                    for (SourceGroup sourceGroup : sourceGroupArray) {
                        ClassIndex classIndex;
                        ClasspathInfo classpathInfo;
                        FileObject fileObject = sourceGroup.getRootFolder();
                        if (fileObject == null) continue;
                        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
                        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
                        if (classPath == null || (classpathInfo = ClasspathInfo.create((ClassPath)classPath2, (ClassPath)classPath3, (ClassPath)classPath)) == null || (classIndex = classpathInfo.getClassIndex()) == null) continue;
                        Set set = classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
                        for (ElementHandle elementHandle2 : set) {
                            JavaSource javaSource;
                            if (linkedHashSet.contains(elementHandle2)) continue;
                            linkedHashSet.add(elementHandle2);
                            final ElementHandle elementHandle3 = elementHandle2;
                            final FileObject fileObject2 = SourceUtils.getFile((ElementHandle)elementHandle2, (ClasspathInfo)classpathInfo);
                            if (fileObject2 == null || (javaSource = JavaSource.forFileObject((FileObject)fileObject2)) == null) continue;
                            try {
                                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                                    public void run(CompilationController compilationController) throws Exception {
                                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                        Element element = elementHandle3.resolve((CompilationInfo)compilationController);
                                        if (element instanceof TypeElement && ((TypeElement)element).getNestingKind() != NestingKind.ANONYMOUS) {
                                            int n = nArray[0];
                                            nArray[0] = n + 1;
                                            SimpleTypeTreeNode.this.insert(new SimpleTypeTreeNode(fileObject2, (TypeElement)element, (CompilationInfo)compilationController, (AbstractHierarchyTreeNode)SimpleTypeTreeNode.this), n);
                                        }
                                    }
                                }, true);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                    }
                }
            }
        }
    }

    private class TypeTreeNode
    extends AbstractHierarchyTreeNode {
        private boolean inSuperClassRole;

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode) {
            this(fileObject, typeElement, compilationInfo, abstractHierarchyTreeNode, false);
        }

        TypeTreeNode(FileObject fileObject, TypeElement typeElement, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode, boolean bl) {
            super(fileObject, typeElement, compilationInfo, abstractHierarchyTreeNode);
            this.inSuperClassRole = bl;
        }

        public boolean isLeaf() {
            return false;
        }

        protected void loadChildren(Element element, CompilationInfo compilationInfo) {
            this.loadChildren(element, compilationInfo, 0);
        }

        protected int loadChildren(Element element, CompilationInfo compilationInfo, int n) {
            Object object;
            TypeElement typeElement;
            Types types = compilationInfo.getTypes();
            TypeElement typeElement2 = (TypeElement)types.asElement((typeElement = (TypeElement)element).getSuperclass());
            if (typeElement2 != null && !typeElement2.getQualifiedName().toString().equals(Object.class.getName()) && !this.hasCycle(typeElement2)) {
                this.insert(new TypeTreeNode(this.getFileObject(), typeElement2, compilationInfo, (AbstractHierarchyTreeNode)this, true), n++);
            }
            List<? extends TypeMirror> list = typeElement.getInterfaces();
            for (TypeMirror annotatedConstruct : list) {
                object = (TypeElement)types.asElement(annotatedConstruct);
                if (object == null || this.hasCycle((TypeElement)object)) continue;
                this.insert(new TypeTreeNode(this.getFileObject(), (TypeElement)object, compilationInfo, (AbstractHierarchyTreeNode)this, true), n++);
            }
            if (JavaMembersAndHierarchyOptions.isShowInner() && !this.inSuperClassRole) {
                for (Element element2 : typeElement.getEnclosedElements()) {
                    object = null;
                    if (element2.getKind() != ElementKind.CLASS && element2.getKind() != ElementKind.INTERFACE && element2.getKind() != ElementKind.ENUM && element2.getKind() != ElementKind.ANNOTATION_TYPE) continue;
                    object = new TypeTreeNode(this.getFileObject(), (TypeElement)element2, compilationInfo, (AbstractHierarchyTreeNode)this, true);
                    if (this.hasCycle((TypeElement)element2)) continue;
                    this.insert((MutableTreeNode)object, n++);
                }
            }
            return n;
        }

        private boolean hasCycle(TypeElement typeElement) {
            String string = ElementUtilities.getBinaryName((TypeElement)typeElement);
            for (AbstractHierarchyTreeNode abstractHierarchyTreeNode = this; abstractHierarchyTreeNode != null; abstractHierarchyTreeNode = abstractHierarchyTreeNode.getOwningTreeNode()) {
                if (!(abstractHierarchyTreeNode instanceof TypeTreeNode) || !string.equals(abstractHierarchyTreeNode.getElementHandle().getBinaryName())) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractHierarchyTreeNode
    extends DefaultMutableTreeNode
    implements JavaElement {
        private FileObject fileObject;
        private ElementHandle<? extends Element> elementHandle;
        private ElementKind elementKind;
        private Set<Modifier> modifiers;
        private String name = "";
        private String label = "";
        private String FQNlabel = "";
        private String tooltip = null;
        private Icon icon = null;
        private ElementJavadoc javaDoc = null;
        private final ClasspathInfo cpInfo;
        private boolean loaded = false;
        private AbstractHierarchyTreeNode owner;

        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode) {
            this(fileObject, element, compilationInfo, abstractHierarchyTreeNode, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractHierarchyTreeNode(FileObject fileObject, Element element, CompilationInfo compilationInfo, AbstractHierarchyTreeNode abstractHierarchyTreeNode, boolean bl) {
            this.fileObject = fileObject;
            this.elementHandle = ElementHandle.create((Element)element);
            this.elementKind = element.getKind();
            this.modifiers = element.getModifiers();
            this.cpInfo = compilationInfo.getClasspathInfo();
            this.owner = abstractHierarchyTreeNode;
            this.setName(element.getSimpleName().toString());
            this.setIcon(ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers()));
            this.setLabel(Utils.format(element));
            this.setFQNLabel(Utils.format(element, false, true));
            this.setToolTip(Utils.format(element, true, JavaMembersAndHierarchyOptions.isShowFQN()));
            if (!bl) {
                try {
                    this.loadChildren(element, compilationInfo);
                }
                finally {
                    this.loaded = true;
                }
            }
        }

        public AbstractHierarchyTreeNode getOwningTreeNode() {
            return this.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount() {
            if (!this.loaded) {
                try {
                    this.loadChildren();
                }
                finally {
                    this.loaded = true;
                }
            }
            return super.getChildCount();
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public ElementKind getElementKind() {
            return this.elementKind;
        }

        protected void setName(String string) {
            this.name = string;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        protected void setLabel(String string) {
            this.label = string;
        }

        @Override
        public String getFQNLabel() {
            return this.FQNlabel;
        }

        protected void setFQNLabel(String string) {
            this.FQNlabel = string;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        protected void setToolTip(String string) {
            this.tooltip = string;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
        }

        protected void setElementHandle(ElementHandle<? extends Element> elementHandle) {
            this.elementHandle = elementHandle;
        }

        @Override
        public ElementJavadoc getJavaDoc() {
            if (this.javaDoc == null) {
                if (this.fileObject == null) {
                    return null;
                }
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
                if (javaSource != null) {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                                AbstractHierarchyTreeNode.this.setJavaDoc(ElementJavadoc.create((CompilationInfo)compilationController, (Element)element));
                            }
                        }, true);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            }
            return this.javaDoc;
        }

        protected void setJavaDoc(ElementJavadoc elementJavadoc) {
            this.javaDoc = elementJavadoc;
        }

        @Override
        public ElementHandle getElementHandle() {
            return this.elementHandle;
        }

        @Override
        public void gotoElement() {
            this.openElementHandle();
        }

        protected void loadChildren() {
            JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Element element = AbstractHierarchyTreeNode.this.elementHandle.resolve((CompilationInfo)compilationController);
                            if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().toString().equals(Object.class.getName())) {
                                AbstractHierarchyTreeNode.this.loadChildren(element, (CompilationInfo)compilationController);
                            }
                        }
                    }, true);
                    return;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        protected abstract void loadChildren(Element var1, CompilationInfo var2);

        @Override
        public String toString() {
            return JavaMembersAndHierarchyOptions.isShowFQN() ? this.getFQNLabel() : this.getLabel();
        }

        protected void openElementHandle() {
            if (this.fileObject == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
                return;
            }
            if (this.elementHandle == null) {
                return;
            }
            if (!ElementOpen.open((ClasspathInfo)this.cpInfo, this.elementHandle)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaHierarchyModel.class, (String)"MSG_CouldNotOpenElement", (Object)this.getFQNLabel()));
            }
        }
    }
}

