/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.navigation.JavaMembers;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class InspectMembersAtCaretAction
extends BaseAction {
    private static final String INSPECT_MEMBERS_AT_CARET = "inspect-members-at-caret";
    private static final String INSPECT_MEMBERS_AT_CARET_POPUP = "inspect-members-at-caret-popup";

    public InspectMembersAtCaretAction() {
        super(NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_MEMBERS_AT_CARET), 0);
        this.putValue("ShortDescription", this.getValue("Name"));
        this.putValue("trimmed-text", this.getValue("Name"));
        this.putValue("PopupMenuText", NbBundle.getMessage(InspectMembersAtCaretAction.class, (String)INSPECT_MEMBERS_AT_CARET_POPUP));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public boolean isEnabled() {
        if (EditorRegistry.lastFocusedComponent() == null || !EditorRegistry.lastFocusedComponent().isShowing()) {
            return false;
        }
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
        if (javaSource == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Document document = compilationController.getDocument();
                    if (document != null) {
                        int n = jTextComponent.getCaret().getDot();
                        TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                        Element element = compilationController.getTrees().getElement(treePath);
                        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                        if (fileObject != null) {
                            if (element instanceof TypeElement) {
                                JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                            } else if (element instanceof VariableElement) {
                                TypeMirror typeMirror = ((VariableElement)element).asType();
                                if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                    JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                                }
                            } else if (element instanceof ExecutableElement) {
                                if (element.getKind() == ElementKind.METHOD) {
                                    TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                                    if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                        JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                                    }
                                } else if (element.getKind() == ElementKind.CONSTRUCTOR && (element = element.getEnclosingElement()) != null) {
                                    JavaMembers.show(fileObject, new Element[]{element}, compilationController);
                                }
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Logger.getLogger(InspectMembersAtCaretAction.class.getName()).log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }
}

