/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.progress;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.core.utilities.ProgressPanel;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProgressSupport {
    private static final Logger LOGGER = Logger.getLogger(ProgressSupport.class.getName());

    private ProgressSupport() {
    }

    public static void invoke(Collection<? extends Action> collection) {
        ProgressSupport.invoke(collection, false);
    }

    public static boolean invoke(Collection<? extends Action> collection, boolean bl) {
        Parameters.notNull((CharSequence)"actions", collection);
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called in the event thread.");
        }
        return new ActionInvoker(new ArrayList<Action>(collection), bl).invoke();
    }

    public static abstract class BackgroundAction
    extends Action {
        private final boolean cancellable;

        public BackgroundAction() {
            this(false);
        }

        public BackgroundAction(boolean bl) {
            this.cancellable = bl;
        }

        public final boolean isBackground() {
            return true;
        }

        protected final boolean isCancellable() {
            return this.cancellable;
        }
    }

    public static abstract class EventThreadAction
    extends Action {
        private final boolean cancellable;

        public EventThreadAction() {
            this(false);
        }

        public EventThreadAction(boolean bl) {
            this.cancellable = bl;
        }

        public final boolean isBackground() {
            return false;
        }

        protected final boolean isCancellable() {
            return this.cancellable;
        }
    }

    public static abstract class Action {
        protected abstract boolean isBackground();

        protected boolean isEnabled() {
            return true;
        }

        protected abstract void run(Context var1);

        protected boolean isCancellable() {
            return false;
        }

        protected boolean cancel() {
            return true;
        }
    }

    public static final class Context {
        private final ProgressPanel panel;
        private final ProgressHandle handle;

        private Context(ProgressPanel progressPanel, ProgressHandle progressHandle) {
            this.panel = progressPanel;
            this.handle = progressHandle;
        }

        public void switchToDeterminate(int n) {
            this.handle.switchToDeterminate(n);
        }

        public void progress(final String string) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    Context.this.panel.setText(string);
                }
            });
            this.handle.progress(string);
        }

        public void progress(int n) {
            this.handle.progress(n);
        }

        ProgressPanel getPanel() {
            return this.panel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionInvoker
    implements ActionListener {
        private final RequestProcessor rp = new RequestProcessor("ProgressSupport", 1);
        private final List<Action> actions;
        private final boolean cancellable;
        private volatile Context actionContext;
        private AtomicInteger nextActionIndex = new AtomicInteger();
        private volatile Action currentAction;
        private volatile boolean cancelled;

        public ActionInvoker(List<Action> list, boolean bl) {
            this.actions = list;
            this.cancellable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            assert (SwingUtilities.isEventDispatchThread());
            final ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.setCancelVisible(this.cancellable);
            progressPanel.addCancelActionListener(this);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            this.actionContext = new Context(progressPanel, progressHandle);
            final AtomicReference<Throwable> atomicReference = new AtomicReference<Throwable>();
            RequestProcessor.Task task = this.rp.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ActionInvoker.this.invokeNextActionsOfSameKind();
                    }
                    catch (Throwable throwable) {
                        try {
                            atomicReference.set(throwable);
                        }
                        catch (Throwable throwable2) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    progressPanel.close();
                                }
                            });
                            throw throwable2;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            try {
                boolean bl = true;
                while (this.nextActionIndex.get() < this.actions.size() && !this.cancelled) {
                    if (bl) {
                        try {
                            this.invokeNextActionsOfSameKind();
                        }
                        catch (Throwable throwable) {
                            atomicReference.set(throwable);
                        }
                    } else {
                        task.schedule(0);
                        progressPanel.open(jComponent);
                        task.waitFinished();
                    }
                    Throwable throwable = (Throwable)atomicReference.get();
                    if (throwable != null) {
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        RuntimeException runtimeException = new RuntimeException(throwable.getMessage());
                        runtimeException.initCause(throwable);
                        throw runtimeException;
                    }
                    bl = !bl;
                }
            }
            finally {
                progressHandle.finish();
            }
            return !this.cancelled;
        }

        private void invokeNextActionsOfSameKind() {
            int n;
            boolean bl;
            boolean bl2 = bl = !SwingUtilities.isEventDispatchThread();
            while (!this.cancelled && (n = this.nextActionIndex.get()) < this.actions.size()) {
                this.currentAction = this.actions.get(n);
                if (!this.currentAction.isEnabled()) {
                    this.nextActionIndex.incrementAndGet();
                    LOGGER.log(Level.FINE, "Skipping " + this.currentAction);
                    continue;
                }
                if (this.currentAction.isBackground() != bl) break;
                LOGGER.log(Level.FINE, "Running " + this.currentAction);
                if (bl) {
                    final boolean bl3 = this.currentAction.isCancellable();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ActionInvoker.this.actionContext.getPanel().setCancelEnabled(bl3);
                        }
                    });
                }
                this.currentAction.run(this.actionContext);
                this.nextActionIndex.incrementAndGet();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.cancelled) {
                return;
            }
            Action action = this.currentAction;
            if (action == null) {
                return;
            }
            if (!(action.isEnabled() && action.isBackground() && action.isCancellable())) {
                return;
            }
            this.cancelled = action.cancel();
            if (this.cancelled) {
                this.actionContext.getPanel().setCancelEnabled(false);
            }
        }
    }
}

