/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.dev.wizard.EJBListViewChildren;
import org.netbeans.modules.websvc.core.dev.wizard.EjbChooser;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebServiceTypePanel
extends JPanel
implements HelpCtx.Provider,
ItemListener {
    private Project project;
    private Node[] sessionBeanNodes;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean isWebModule;
    WSStackUtils stackUtils;
    private ButtonGroup buttonGroup1;
    private JButton jButtonConvert;
    private JButton jButtonDelegate;
    private JLabel jLabelConvert;
    private JLabel jLabelDelegate;
    private JRadioButton jRadioButtonConvert;
    private JRadioButton jRadioButtonDelegate;
    private JRadioButton jRadioButtonScratch;
    private JTextField jTextFieldConvert;
    private JTextField jTextFieldDelegate;

    public WebServiceTypePanel(Project project) {
        this.project = project;
        this.initComponents();
        this.stackUtils = new WSStackUtils(project);
        this.jsr109Supported = this.stackUtils.isJsr109Supported();
        this.jsr109oldSupported = this.stackUtils.isJsr109OldSupported();
        this.jRadioButtonConvert.setEnabled(false);
        this.jLabelConvert.setEnabled(false);
        this.jTextFieldConvert.setEnabled(false);
        this.jButtonConvert.setEnabled(false);
        this.jRadioButtonConvert.setVisible(false);
        this.jLabelConvert.setVisible(false);
        this.jTextFieldConvert.setVisible(false);
        this.jButtonConvert.setVisible(false);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            this.isWebModule = J2eeModule.WAR.equals(j2eeModuleProvider.getJ2eeModule().getModuleType());
        }
        if (j2eeModuleProvider == null || !this.jsr109Supported && !this.jsr109oldSupported) {
            this.disableDelegateToEJB();
        }
        this.addItemListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonScratch = new JRadioButton();
        this.jRadioButtonDelegate = new JRadioButton();
        this.jLabelDelegate = new JLabel();
        this.jTextFieldDelegate = new JTextField();
        this.jButtonDelegate = new JButton();
        this.jRadioButtonConvert = new JRadioButton();
        this.jLabelConvert = new JLabel();
        this.jTextFieldConvert = new JTextField();
        this.jButtonConvert = new JButton();
        this.buttonGroup1.add(this.jRadioButtonScratch);
        this.jRadioButtonScratch.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonScratch, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EmptyWebService"));
        this.jRadioButtonScratch.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EmptyWebService"));
        this.jRadioButtonScratch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonScratch.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.jRadioButtonDelegate);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EncapsulateSessionBean"));
        this.jRadioButtonDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EnterpriseBean"));
        this.jRadioButtonDelegate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonDelegate.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelDelegate.setLabelFor(this.jTextFieldDelegate);
        Mnemonics.setLocalizedText((JLabel)this.jLabelDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EnterpriseBean"));
        this.jLabelDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_EnterpriseBean"));
        this.jTextFieldDelegate.setEditable(false);
        this.jTextFieldDelegate.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDelegate, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonDelegate.setToolTipText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"HINT_BrowseBean"));
        this.jButtonDelegate.setEnabled(false);
        this.jButtonDelegate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceTypePanel.this.jButtonDelegateActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonConvert);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButtonConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_ConvertJavaClass"));
        this.jRadioButtonConvert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonConvert.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelConvert.setLabelFor(this.jTextFieldConvert);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_JavaClass"));
        this.jTextFieldConvert.setEditable(false);
        this.jTextFieldConvert.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConvert, (String)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonConvert.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jRadioButtonScratch).addContainerGap(330, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jRadioButtonDelegate).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelConvert).add((Component)this.jLabelDelegate)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jTextFieldConvert).add((Component)this.jTextFieldDelegate)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jButtonConvert).add((Component)this.jButtonDelegate))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jRadioButtonConvert, 0, 497, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.jLabelConvert, this.jLabelDelegate}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jRadioButtonScratch).addPreferredGap(0).add((Component)this.jRadioButtonDelegate, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonDelegate).add((Component)this.jLabelDelegate).add((Component)this.jTextFieldDelegate, -2, -1, -2)).addPreferredGap(0).add((Component)this.jRadioButtonConvert).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelConvert).add((Component)this.jButtonConvert).add((Component)this.jTextFieldConvert, -2, -1, -2)).addContainerGap(184, Short.MAX_VALUE)));
    }

    private void jButtonDelegateActionPerformed(ActionEvent actionEvent) {
        Object object;
        LogicalViewProvider logicalViewProvider;
        Project[] projectArray = this.getCallableEjbProjects(this.project);
        LinkedList<2> linkedList = new LinkedList<2>();
        for (int i = 0; i < projectArray.length; ++i) {
            logicalViewProvider = (LogicalViewProvider)projectArray[i].getLookup().lookup(LogicalViewProvider.class);
            object = logicalViewProvider.createLogicalView();
            linkedList.add(new FilterNode((Node)object, (Children)new EJBListViewChildren(projectArray[i])){

                public Action[] getActions(boolean bl) {
                    return new Action[0];
                }
            });
        }
        Children.Array array = new Children.Array();
        array.add(linkedList.toArray(new Node[linkedList.size()]));
        logicalViewProvider = new AbstractNode((Children)array);
        object = new EjbChooser((Node)logicalViewProvider);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_BrowseBean_Title"));
        dialogDescriptor.setValid(false);
        ((Container)object).addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("ejbChooser_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.jTextFieldDelegate.setText(((EjbChooser)object).getSelectedEJBProjectName() + "#" + ((EjbChooser)object).getSelectedNodes()[0].getDisplayName());
            this.sessionBeanNodes = ((EjbChooser)object).getSelectedNodes();
            this.fireChange();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.getServiceType() == 1 && this.jTextFieldDelegate.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_SelectOneEJB"));
            return false;
        }
        WSStackUtils.ErrorMessage errorMessage = this.stackUtils.getErrorMessage(WSStackUtils.WizardType.WS);
        if (errorMessage != null) {
            wizardDescriptor.putProperty(errorMessage.getWizardMessageProperty(), (Object)errorMessage.getText());
            if (errorMessage.isSerious()) {
                return false;
            }
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("webServiceType", (Object)this.getServiceType());
        if (this.getServiceType() == 1) {
            wizardDescriptor.putProperty("delegateToSessionBean", (Object)this.sessionBeanNodes);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceTypePanel.class);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.jRadioButtonScratch)) {
            this.jButtonDelegate.setEnabled(false);
            this.jTextFieldDelegate.setEnabled(false);
        } else if (object.equals(this.jRadioButtonDelegate)) {
            this.jButtonDelegate.setEnabled(true);
            this.jTextFieldDelegate.setEnabled(true);
        }
        this.fireChange();
    }

    public void addItemListener(ItemListener itemListener) {
        this.jRadioButtonScratch.addItemListener(itemListener);
        this.jRadioButtonDelegate.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.jRadioButtonScratch.removeItemListener(itemListener);
        this.jRadioButtonDelegate.removeItemListener(itemListener);
    }

    public int getServiceType() {
        if (this.jRadioButtonScratch.isSelected()) {
            return 0;
        }
        return 1;
    }

    private void disableDelegateToEJB() {
        this.jRadioButtonDelegate.setEnabled(false);
        this.jLabelDelegate.setEnabled(false);
        this.jTextFieldDelegate.setEnabled(false);
        this.jButtonDelegate.setEnabled(false);
    }

    private Project[] getCallableEjbProjects(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        boolean bl = false;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            bl = true;
        }
        boolean bl2 = project.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            boolean bl3 = false;
            J2eeModuleProvider j2eeModuleProvider2 = (J2eeModuleProvider)projectArray[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider2 != null && j2eeModuleProvider2.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                bl3 = true;
            }
            if ((!bl3 || bl2) && (!bl2 || !project.equals(projectArray[i]))) continue;
            arrayList.add(projectArray[i]);
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }
}

