/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.core.jaxws.projects.J2SEProjectJAXWSClientSupport;
import org.netbeans.modules.websvc.core.jaxws.projects.J2SEProjectJaxRpcClientSupport;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportFactory;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportFactory;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class J2SEWSSupportLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup lookup) {
        final Project project = (Project)lookup.lookup(Project.class);
        J2SEProjectJAXWSClientSupport j2SEProjectJAXWSClientSupport = new J2SEProjectJAXWSClientSupport(project);
        final JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupportFactory.createJAXWSClientSupport((JAXWSClientSupportImpl)j2SEProjectJAXWSClientSupport);
        J2SEProjectJaxRpcClientSupport j2SEProjectJaxRpcClientSupport = new J2SEProjectJaxRpcClientSupport(project);
        final WebServicesClientSupport webServicesClientSupport = WebServicesClientSupportFactory.createWebServicesClientSupport((WebServicesClientSupportImpl)j2SEProjectJaxRpcClientSupport);
        ProjectOpenedHook projectOpenedHook = new ProjectOpenedHook(){

            protected void projectOpened() {
                if (webServicesClientSupport.isBroken(project)) {
                    webServicesClientSupport.showBrokenAlert(project);
                }
                if (jAXWSClientSupport.getServiceClients().size() > 0) {
                    try {
                        FileObject fileObject = jAXWSClientSupport.getWsdlFolder(true);
                        if (fileObject != null && fileObject.getParent().getFileObject("jax-ws-catalog.xml") == null) {
                            J2SEWSSupportLookupProvider.this.generateJaxWsCatalog(project, jAXWSClientSupport, fileObject);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            protected void projectClosed() {
            }
        };
        return Lookups.fixed((Object[])new Object[]{jAXWSClientSupport, webServicesClientSupport, projectOpenedHook});
    }

    private void generateJaxWsCatalog(Project project, JAXWSClientSupport jAXWSClientSupport, FileObject fileObject) throws IOException {
        JaxWsModel jaxWsModel;
        FileObject fileObject2 = WSUtils.retrieveJaxWsCatalogFromResource((FileObject)fileObject.getParent());
        FileObject fileObject3 = project.getProjectDirectory().getFileObject("catalog.xml");
        if (fileObject3 != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
            CatalogUtils.copyCatalogEntriesForAllClients((FileObject)fileObject3, (FileObject)fileObject2, (JaxWsModel)jaxWsModel);
            for (Client client : jaxWsModel.getClients()) {
                FileObject fileObject4 = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
                if (fileObject4 == null) continue;
                WSUtils.copyFiles((FileObject)fileObject4, (FileObject)fileObject);
            }
        }
    }
}

