/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model;

import com.sun.istack.NotNull;
import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.ObjectFactory;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import com.sun.xml.ws.runtime.config.TubelineMapping;
import com.sun.xml.ws.runtime.config.Tubelines;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetroConfigLoader {
    public static final String CFG_FILE_NAME = "metro.xml";
    public static final String DEFAULT_TUBELINE_NAME = "default";
    private JAXBContext jaxbContext = null;
    private ObjectFactory objFactory = null;

    public MetroConfigLoader() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)MetroConfig.class.getPackage().getName());
            this.objFactory = new ObjectFactory();
        }
        catch (JAXBException jAXBException) {
            Exceptions.printStackTrace((Throwable)jAXBException);
        }
    }

    public boolean isMetroConfigSupported(Project project) {
        if (project == null) {
            return false;
        }
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider == null || !wsitProvider.isWsitSupported()) {
            return false;
        }
        WSStackVersion wSStackVersion = WSITConfigProvider.getDefault().getHighestWSStackVersion(project);
        return wSStackVersion != null && wSStackVersion.compareTo(WSStackVersion.valueOf((int)2, (int)2, (int)0, (int)0)) >= 0;
    }

    public MetroConfig createFreshMetroConfig() {
        MetroConfig metroConfig = this.objFactory.createMetroConfig();
        metroConfig.setVersion("1.0");
        return metroConfig;
    }

    public TubelineDefinition createDefaultTubeline(MetroConfig metroConfig) {
        TubelineDefinition tubelineDefinition = this.getDefaultTubeline(metroConfig);
        if (tubelineDefinition == null) {
            Tubelines tubelines = metroConfig.getTubelines();
            if (tubelines == null) {
                tubelines = this.objFactory.createTubelines();
                metroConfig.setTubelines(tubelines);
            }
            tubelineDefinition = this.objFactory.createTubelineDefinition();
            tubelineDefinition.setName(DEFAULT_TUBELINE_NAME);
            tubelines.getTubelineDefinitions().add(tubelineDefinition);
            tubelines.setDefault("#" + tubelineDefinition.getName());
        }
        return tubelineDefinition;
    }

    public TubelineDefinition createTubeline(MetroConfig metroConfig, String string, String string2) {
        TubelineDefinition tubelineDefinition = this.getTubeline(metroConfig, string);
        if (tubelineDefinition == null) {
            Tubelines tubelines = metroConfig.getTubelines();
            if (tubelines == null) {
                tubelines = this.objFactory.createTubelines();
                metroConfig.setTubelines(tubelines);
            }
            tubelineDefinition = this.objFactory.createTubelineDefinition();
            tubelineDefinition.setName(string2);
            tubelines.getTubelineDefinitions().add(tubelineDefinition);
            List<TubelineMapping> list = tubelines.getTubelineMappings();
            TubelineMapping tubelineMapping = this.objFactory.createTubelineMapping();
            tubelineMapping.setEndpointRef(string);
            tubelineMapping.setTubelineRef("#" + string2);
            list.add(tubelineMapping);
        }
        return tubelineDefinition;
    }

    public void removeTubelineReference(MetroConfig metroConfig, String string) {
        TubelineMapping tubelineMapping = MetroConfigLoader.getTubelineMapping(metroConfig, string);
        if (tubelineMapping != null) {
            String string2 = tubelineMapping.getTubelineRef();
            Tubelines tubelines = metroConfig.getTubelines();
            tubelines.getTubelineMappings().remove(tubelineMapping);
            if (!this.isTubelineReferenced(tubelines, string2)) {
                this.removeTubeline(tubelines, string2);
            }
        }
        this.clearTubelines(metroConfig);
    }

    public void removeDefaultTubeline(MetroConfig metroConfig) {
        Tubelines tubelines = metroConfig.getTubelines();
        TubelineDefinition tubelineDefinition = this.getDefaultTubeline(metroConfig);
        if (tubelineDefinition != null) {
            tubelines.getTubelineDefinitions().remove(tubelineDefinition);
        }
        tubelines.setDefault(null);
        this.clearTubelines(metroConfig);
    }

    private void clearTubelines(MetroConfig metroConfig) {
        Tubelines tubelines = metroConfig.getTubelines();
        List<TubelineDefinition> list = tubelines.getTubelineDefinitions();
        if (list == null || list.isEmpty()) {
            metroConfig.setTubelines(null);
        }
    }

    private void removeTubeline(Tubelines tubelines, String string) {
        TubelineDefinition tubelineDefinition = this.getTubeline(tubelines, string);
        if (tubelineDefinition != null) {
            tubelines.getTubelineDefinitions().remove(tubelineDefinition);
        }
    }

    private boolean isTubelineReferenced(Tubelines tubelines, String string) {
        List<TubelineMapping> list = tubelines.getTubelineMappings();
        for (TubelineMapping tubelineMapping : list) {
            if (!string.equals(tubelineMapping.getTubelineRef())) continue;
            return true;
        }
        return false;
    }

    public MetroConfig loadDefaultMetroConfig(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
        FileObject fileObject = classPath.findResource("META-INF/metro-default.xml");
        try {
            if (fileObject != null) {
                return this.loadMetroConfig(fileObject.getURL());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public MetroConfig loadMetroConfig(Project project) {
        FileObject fileObject = this.getConfigFolder(project, false);
        if (fileObject != null && fileObject.isValid()) {
            try {
                FileObject fileObject2 = fileObject.getFileObject(CFG_FILE_NAME);
                return fileObject2 != null ? this.loadMetroConfig(fileObject2.getURL()) : null;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return null;
    }

    private MetroConfig loadMetroConfig(@NotNull URL uRL) {
        MetroConfig metroConfig = null;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement jAXBElement = unmarshaller.unmarshal(XMLInputFactory.newInstance().createXMLStreamReader(uRL.openStream()), MetroConfig.class);
            metroConfig = (MetroConfig)jAXBElement.getValue();
        }
        catch (Exception exception) {
            Logger.global.warning(String.format("Unable to unmarshall metro config file from location: '%s'", uRL.toString()));
        }
        return metroConfig;
    }

    public void saveMetroConfig(@NotNull MetroConfig metroConfig, Project project) {
        FileObject fileObject = this.getConfigFolder(project, false);
        if (fileObject != null && fileObject.isValid()) {
            File file = null;
            FileObject fileObject2 = fileObject.getFileObject(CFG_FILE_NAME);
            if (metroConfig == null) {
                if (fileObject2 != null && fileObject2.isValid()) {
                    file = FileUtil.toFile((FileObject)fileObject2);
                    file.delete();
                }
                return;
            }
            file = fileObject2 != null && fileObject2.isValid() ? FileUtil.toFile((FileObject)fileObject2) : new File(FileUtil.toFile((FileObject)fileObject), CFG_FILE_NAME);
            this.saveMetroConfig(metroConfig, file);
        }
    }

    private void saveMetroConfig(@NotNull MetroConfig metroConfig, @NotNull File file) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)metroConfig, file);
        }
        catch (Exception exception) {
            Logger.global.warning(String.format("Unable to marshall metro config to file: '%s'", file.toString()));
        }
    }

    public List<TubeFactoryConfig> createTubeFactoryConfigList(List<String> list) {
        ArrayList<TubeFactoryConfig> arrayList = new ArrayList<TubeFactoryConfig>();
        for (String string : list) {
            TubeFactoryConfig tubeFactoryConfig = this.objFactory.createTubeFactoryConfig();
            tubeFactoryConfig.setClassName(string);
            arrayList.add(tubeFactoryConfig);
        }
        return arrayList;
    }

    public TubelineDefinition getDefaultTubeline(MetroConfig metroConfig) {
        return this.getDefaultTubeline(metroConfig.getTubelines());
    }

    private TubelineDefinition getDefaultTubeline(Tubelines tubelines) {
        if (tubelines == null) {
            return null;
        }
        return this.getTubeline(tubelines, tubelines.getDefault());
    }

    private TubelineDefinition getTubeline(Tubelines tubelines, String string) {
        if (string == null) {
            return null;
        }
        List<TubelineDefinition> list = tubelines.getTubelineDefinitions();
        for (TubelineDefinition tubelineDefinition : list) {
            if (!string.equals("#" + tubelineDefinition.getName())) continue;
            return tubelineDefinition;
        }
        return null;
    }

    public TubelineDefinition getTubeline(MetroConfig metroConfig, String string) {
        Tubelines tubelines = metroConfig.getTubelines();
        TubelineMapping tubelineMapping = MetroConfigLoader.getTubelineMapping(metroConfig, string);
        if (tubelineMapping != null) {
            return this.getTubeline(tubelines, tubelineMapping.getTubelineRef());
        }
        return null;
    }

    public static TubelineMapping getTubelineMapping(MetroConfig metroConfig, String string) {
        Tubelines tubelines = metroConfig.getTubelines();
        if (tubelines != null) {
            List<TubelineMapping> list = tubelines.getTubelineMappings();
            for (TubelineMapping tubelineMapping : list) {
                if (!string.equals(tubelineMapping.getEndpointRef())) continue;
                return tubelineMapping;
            }
        }
        return null;
    }

    private FileObject getConfigFolder(Project project, boolean bl) {
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        return wsitProvider != null ? wsitProvider.getConfigFilesFolder(bl) : null;
    }
}

