/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.dataprovider;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.management.spi.PathMapper;
import org.netbeans.modules.dlight.management.spi.PathMapperProvider;
import org.netbeans.modules.dlight.perfan.dataprovider.MemoryMetric;
import org.netbeans.modules.dlight.perfan.dataprovider.TimeMetric;
import org.netbeans.modules.dlight.perfan.spi.datafilter.HotSpotFunctionsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.PerfanDataStorage;
import org.netbeans.modules.dlight.perfan.util.Computable;
import org.netbeans.modules.dlight.perfan.util.TasksCachedProcessor;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSStackDataProvider
implements StackDataProvider {
    private static final Logger log = DLightLogger.getLogger(SSStackDataProvider.class);
    private static Pattern fullInfoPattern = Pattern.compile("^(.*), line ([0-9]+) in \"(.*)\"");
    private static Pattern noLineInfoPattern = Pattern.compile("^<Function: (.*), instructions from source file (.*)>");
    private static Pattern noDebugInfoPattern = Pattern.compile("^<Function: (.*), instructions without line numbers>");
    private final Computable<HotSpotFunctionsFetcherParams, List<FunctionCall>> hotSpotFunctionsFetcher = new TasksCachedProcessor<HotSpotFunctionsFetcherParams, List<FunctionCall>>(new HotSpotFunctionsFetcher(), true);
    private final List<FunctionMetric> metricsList = Arrays.asList(TimeMetric.UserFuncTimeExclusive, TimeMetric.UserFuncTimeInclusive, TimeMetric.SyncWaitCallInclusive, TimeMetric.SyncWaitTimeInclusive, TimeMetric.SyncWaitCallExclusive, TimeMetric.SyncWaitTimeExclusive, MemoryMetric.LeakBytesMetric, MemoryMetric.LeaksCountMetric);
    private PerfanDataStorage storage;
    private volatile HotSpotFunctionsFilter filter;

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
    }

    public void dataFiltersChanged(List<DataFilter> list) {
        for (DataFilter dataFilter : list) {
            if (!(dataFilter instanceof HotSpotFunctionsFilter)) continue;
            this.filter = (HotSpotFunctionsFilter)dataFilter;
        }
    }

    public synchronized List<FunctionCall> getCallers(FunctionCall[] functionCallArray, boolean bl) {
        return this.getCallersCallees(CC_MODE.CALLERS, functionCallArray, bl);
    }

    public synchronized List<FunctionCall> getCallees(FunctionCall[] functionCallArray, boolean bl) {
        return this.getCallersCallees(CC_MODE.CALLEES, functionCallArray, bl);
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getFunctionCalls(list, list2, n));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> list) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getCallers(FunctionCallTreeTableNode.getFunctionCalls(list).toArray(new FunctionCall[0]), false));
    }

    public FunctionCallTreeTableNode getValueAt(int n) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int n) {
        return null;
    }

    private synchronized List<FunctionCall> getCallersCallees(CC_MODE cC_MODE, FunctionCall[] functionCallArray, boolean bl) {
        return Collections.emptyList();
    }

    public List<FunctionCall> getFunctionCalls(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        List<FunctionCall> list3 = Collections.emptyList();
        try {
            list3 = this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams("lines", list, list2, n, this.filter));
        }
        catch (InterruptedException interruptedException) {
            log.fine("HotSpotFunctionsFetcher interrupted");
        }
        return list3;
    }

    public List<FunctionCall> getHotSpotFunctions(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        try {
            return this.hotSpotFunctionsFetcher.compute(new HotSpotFunctionsFetcherParams("functions", list, list2, n, this.filter));
        }
        catch (InterruptedException interruptedException) {
            log.fine("HotSpotFunctionsFetcher interrupted.");
            return Collections.emptyList();
        }
    }

    private FunctionMetric getMetricInstance(String string) {
        for (FunctionMetric functionMetric : this.metricsList) {
            if (!functionMetric.getMetricID().equals(string)) continue;
            return functionMetric;
        }
        return null;
    }

    public List<FunctionMetric> getMetricsList() {
        return this.metricsList;
    }

    public void attachTo(DataStorage dataStorage) {
        if (!(dataStorage instanceof PerfanDataStorage)) {
            String string = "Attempt to attach SSStackDataProvider to storage '" + dataStorage + "'";
            throw new IllegalArgumentException(string);
        }
        this.storage = (PerfanDataStorage)dataStorage;
    }

    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Object object;
        Object object2;
        if (functionCall instanceof FunctionCallImpl && (object2 = (FunctionCallImpl)functionCall).hasOffset()) {
            if (!((FunctionCallImpl)((Object)object2)).hasSourceFileDefined() && (object = this.storage.getFunctionStatistic(functionCall)) != null) {
                ((FunctionCallImpl)((Object)object2)).setSourceFile(((FunctionStatistic)object).getSourceFile());
            }
            if (((FunctionCallImpl)((Object)object2)).hasSourceFileDefined()) {
                PathMapper pathMapper;
                object = (PathMapperProvider)Lookup.getDefault().lookup(PathMapperProvider.class);
                if (object != null && (pathMapper = object.getPathMapper(ExecutionEnvironmentFactory.fromUniqueID((String)this.storage.getValue("service.storage.execution.env.key")))) != null) {
                    return new SourceFileInfoProvider.SourceFileInfo(pathMapper.getLocalPath(((FunctionCallImpl)((Object)object2)).getSourceFile()), (int)object2.getOffset(), 0);
                }
                return new SourceFileInfoProvider.SourceFileInfo(((FunctionCallImpl)((Object)object2)).getSourceFile(), (int)object2.getOffset(), 0);
            }
        }
        object2 = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        object = object2.iterator();
        while (object.hasNext()) {
            SourceFileInfoProvider sourceFileInfoProvider = (SourceFileInfoProvider)object.next();
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.fileName(functionCall.getFunction().getName(), functionCall.getOffset(), this.storage.getInfo());
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            return sourceFileInfo;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HotSpotFunctionsFetcher
    implements Computable<HotSpotFunctionsFetcherParams, List<FunctionCall>> {
        private final DecimalFormat df = new DecimalFormat();

        public HotSpotFunctionsFetcher() {
            this.df.getDecimalFormatSymbols().setDecimalSeparator(',');
        }

        @Override
        public List<FunctionCall> compute(HotSpotFunctionsFetcherParams hotSpotFunctionsFetcherParams) throws InterruptedException {
            log.finest("Started to fetch Hot Spot Functions @ " + Thread.currentThread());
            Metrics metrics = hotSpotFunctionsFetcherParams.metrics;
            String[] stringArray = null;
            try {
                stringArray = SSStackDataProvider.this.storage.getTopFunctions(hotSpotFunctionsFetcherParams.command, metrics, hotSpotFunctionsFetcherParams.limit);
            }
            catch (InterruptedException interruptedException) {
                log.finest("Fetching Interrupted! Hot Spot Functions @ " + Thread.currentThread());
                return null;
            }
            if (stringArray == null) {
                return null;
            }
            if (stringArray.length == 0) {
                return Collections.emptyList();
            }
            int n = Math.min(stringArray.length, hotSpotFunctionsFetcherParams.limit);
            ArrayList<FunctionCall> arrayList = new ArrayList<FunctionCall>(n);
            int n2 = hotSpotFunctionsFetcherParams.columns.size();
            DataTableMetadata.Column column = (DataTableMetadata.Column)hotSpotFunctionsFetcherParams.orderBy.get(0);
            for (int i = 0; i < n; ++i) {
                Object object;
                int n3 = -1;
                String string = null;
                String[] stringArray2 = stringArray[i].split("[ \t]+", n2);
                String string2 = stringArray2[n2 - 1];
                if (!hotSpotFunctionsFetcherParams.isDefaultCommand() && "lines".equals(hotSpotFunctionsFetcherParams.command)) {
                    object = fullInfoPattern.matcher(string2);
                    if (((Matcher)object).matches()) {
                        string2 = ((Matcher)object).group(1);
                        n3 = Integer.valueOf(((Matcher)object).group(2));
                        string = ((Matcher)object).group(3);
                    } else {
                        if (SSStackDataProvider.this.filter != null && SSStackDataProvider.this.filter.getType() == HotSpotFunctionsFilter.CollectedDataType.WITHSOURCECODEONLY) continue;
                        object = noLineInfoPattern.matcher(string2);
                        if (((Matcher)object).matches()) {
                            string2 = ((Matcher)object).group(1);
                            string = ((Matcher)object).group(2);
                        } else {
                            object = noDebugInfoPattern.matcher(string2);
                            if (!((Matcher)object).matches()) continue;
                            string2 = ((Matcher)object).group(1);
                        }
                    }
                }
                object = new FunctionImpl(string2, string2.hashCode());
                HashMap<FunctionMetric, Object> hashMap = new HashMap<FunctionMetric, Object>();
                boolean bl = false;
                for (int j = 0; j < n2 - 1; ++j) {
                    DataTableMetadata.Column column2 = (DataTableMetadata.Column)hotSpotFunctionsFetcherParams.columns.get(j);
                    String string3 = column2.getColumnName();
                    Class clazz = column2.getColumnClass();
                    FunctionMetric functionMetric = SSStackDataProvider.this.getMetricInstance(string3);
                    boolean bl2 = column2.equals(column);
                    Object object2 = stringArray2[j];
                    try {
                        Number number = this.df.parse(stringArray2[j]);
                        if (Integer.class == clazz) {
                            if (bl2 && number.intValue() == 0) {
                                bl = true;
                            }
                            object2 = new Integer(number.intValue());
                        } else if (Double.class == clazz) {
                            if (bl2 && number.doubleValue() == 0.0) {
                                bl = true;
                            }
                            object2 = new Double(number.doubleValue());
                        } else if (Float.class == clazz) {
                            if (bl2 && number.floatValue() == 0.0f) {
                                bl = true;
                            }
                            object2 = new Float(number.floatValue());
                        } else if (Long.class == clazz) {
                            if (bl2 && number.longValue() == 0L) {
                                bl = true;
                            }
                            object2 = new Long(number.longValue());
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    hashMap.put(functionMetric, object2);
                }
                if (bl) continue;
                FunctionCallImpl functionCallImpl = new FunctionCallImpl((Function)object, n3, hashMap);
                if (string != null) {
                    functionCallImpl.setFileName(string);
                }
                arrayList.add(functionCallImpl);
            }
            log.fine("Done with Hot Spot Functions fetching");
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HotSpotFunctionsFetcherParams {
        private final String command;
        private final List<DataTableMetadata.Column> columns;
        private final List<DataTableMetadata.Column> orderBy;
        private final int limit;
        private final Metrics metrics;
        private final HotSpotFunctionsFilter filter;

        HotSpotFunctionsFetcherParams(String string, List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n, HotSpotFunctionsFilter hotSpotFunctionsFilter) {
            if (list == null) {
                throw new NullPointerException();
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("HotSpotFunctionsFetcherParams: empty columns list!");
            }
            this.command = string == null ? "functions" : string;
            this.columns = list;
            this.orderBy = list2 == null ? Arrays.asList(list.get(0)) : list2;
            this.limit = n;
            this.metrics = Metrics.constructFrom(list, list2);
            this.filter = hotSpotFunctionsFilter;
        }

        boolean isDefaultCommand() {
            return "functions".equals(this.command);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HotSpotFunctionsFetcherParams)) {
                throw new IllegalArgumentException();
            }
            HotSpotFunctionsFetcherParams hotSpotFunctionsFetcherParams = (HotSpotFunctionsFetcherParams)object;
            return hotSpotFunctionsFetcherParams.metrics.equals(this.metrics) && hotSpotFunctionsFetcherParams.limit == this.limit;
        }

        public int hashCode() {
            int n = 3;
            n = 71 * n + this.limit;
            n = 71 * n + (this.metrics != null ? this.metrics.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CC_MODE {
        CALLEES,
        CALLERS;

    }
}

