/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.perfan.spi.datafilter.CollectedObjectsFilter;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.perfan.storage.impl.ExperimentStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.FunctionStatistic;
import org.netbeans.modules.dlight.perfan.storage.impl.LeaksStatistics;
import org.netbeans.modules.dlight.perfan.storage.impl.Metrics;
import org.netbeans.modules.dlight.perfan.storage.impl.ThreadsStatistic;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

final class Erprint {
    private static final Pattern specPattern = Pattern.compile("[^:]*: (.*)");
    private static final Pattern sortPattern = Pattern.compile(".* \\( (.*) \\)");
    private static final Pattern choicePattern = Pattern.compile("^[ \t]+([0-9]+)\\) .* \\((.*)\\)");
    private static final String choiceMarker = "Available name list:";
    private final Logger log = DLightLogger.getLogger(Erprint.class);
    private final AtomicInteger locks = new AtomicInteger();
    private final NativeProcess process;
    private final InputStream out;
    private final InputStream err;
    private final OutputStream in;
    private final OutputProcessor outProcessor;
    private int currentLimit = -1;
    private boolean stopped = false;
    private final String logPrefix;

    Erprint(NativeProcessBuilder nativeProcessBuilder, int n) throws IOException {
        this.process = nativeProcessBuilder.call();
        this.logPrefix = "er_print [" + this.process.getPID() + "]: ";
        this.addLock();
        String string = System.getProperty("nativeexecution.support.logger.er_print");
        if (string == null) {
            this.log.setLevel(Level.INFO);
        }
        this.log.finest(this.logPrefix + "started");
        this.out = this.process.getInputStream();
        this.in = this.process.getOutputStream();
        this.err = this.process.getErrorStream();
        this.outProcessor = new OutputProcessor();
        this.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLock() throws IllegalStateException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                throw new IllegalStateException("er_print is scheduled to be stopped already!");
            }
            this.locks.incrementAndGet();
            this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock() {
        Erprint erprint = this;
        synchronized (erprint) {
            this.locks.decrementAndGet();
            this.log.finest(this.logPrefix + "locks count == " + this.locks.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                Erprint.this.log.finest(Erprint.this.logPrefix + "Scheduled for termination");
                int n = 30;
                while (Erprint.this.locks.get() != 0 && --n > 0) {
                    try {
                        Erprint.this.log.finest(Erprint.this.logPrefix + "waiting for lock release [" + Erprint.this.locks.get() + "] ...");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        Erprint.this.log.log(Level.FINEST, Erprint.this.logPrefix + "Exception while terminating", interruptedException);
                        break;
                    }
                }
                if (Erprint.this.locks.get() > 0) {
                    Erprint.this.log.finest(Erprint.this.logPrefix + "do force termination");
                } else {
                    Erprint.this.log.finest(Erprint.this.logPrefix + "do termination");
                }
                Erprint.this.process.destroy();
            }
        }, (String)("Stopping er_print " + this.logPrefix));
    }

    private void post(String string) throws IOException {
        this.in.write((string + "\n").getBytes());
        this.in.flush();
    }

    public synchronized int setLimit(int n) throws IOException {
        if (this.currentLimit == n) {
            return this.currentLimit;
        }
        int n2 = this.currentLimit;
        this.exec("limit " + n);
        this.currentLimit = n;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metrics setMetrics(Metrics metrics) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            String[] stringArray = this.exec("metrics");
            if (stringArray == null || stringArray.length != 2) {
                return null;
            }
            Matcher matcher = specPattern.matcher(stringArray[0]);
            Matcher matcher2 = sortPattern.matcher(stringArray[1]);
            Metrics metrics2 = null;
            if (matcher.matches() && matcher2.matches()) {
                metrics2 = new Metrics(matcher.group(1), matcher2.group(1));
            }
            this.exec("metrics " + metrics.mspec);
            this.exec("sort " + metrics.msort);
            return metrics2;
        }
    }

    String[] getHotFunctions(String string, int n) throws IOException {
        String[] stringArray = this.exec(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (!string2.matches("^ *[0-9]+.*")) continue;
            arrayList.add(string2.trim());
            if (--n == 0) break;
        }
        return arrayList.toArray(new String[0]);
    }

    String[] getHotFunctions(int n) throws IOException {
        return this.getHotFunctions("functions", n);
    }

    ExperimentStatistics getExperimentStatistics() throws IOException {
        String[] stringArray = this.exec("statistics");
        return new ExperimentStatistics(stringArray);
    }

    ThreadsStatistic getThreadsStatistics() throws IOException {
        this.exec("threads");
        String[] stringArray = this.exec("thread_list");
        return new ThreadsStatistic(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectObjects(CollectedObjectsFilter collectedObjectsFilter) throws IOException {
        if (this.stopped || collectedObjectsFilter == null) {
            return;
        }
        Pattern pattern = Pattern.compile(".* <(.*)>.*");
        StringBuilder stringBuilder = new StringBuilder();
        Erprint erprint = this;
        synchronized (erprint) {
            String[] stringArray = this.exec("object_list");
            Collection<String> collection = collectedObjectsFilter.selectedObjects();
            Collection<String> collection2 = collectedObjectsFilter.hiddenObjects();
            collection2.add("libcollector.so");
            collection2.add("er_heap.so");
            collection2.add("er_sync.so");
            collection2.add("Unknown");
            for (String string : stringArray) {
                String string2;
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches() || !collection.contains(string2 = matcher.group(1)) && collection2.contains(string2)) continue;
                stringBuilder.append(string2).append(",");
            }
            if (stringBuilder.length() != 0) {
                this.exec("object_select " + stringBuilder.toString());
            }
        }
    }

    LeaksStatistics getExperimentLeaks() throws IOException {
        String[] stringArray = this.exec("leaks");
        return new LeaksStatistics(stringArray);
    }

    FunctionStatistic getFunctionStatistic(String string) throws IOException {
        String[] stringArray = this.exec("fsingle \"" + string + "\" 1");
        return new FunctionStatistic(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionStatistic getFunctionStatistic(FunctionCall functionCall) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return new FunctionStatistic(new String[0]);
            }
            String string = functionCall.getFunction().getName();
            String[] stringArray = this.exec("fsingle \"" + string + "\"");
            if (stringArray != null && stringArray.length > 0 && choiceMarker.equals(stringArray[0])) {
                String string2;
                String string3 = "1";
                FunctionCallImpl functionCallImpl = functionCall instanceof FunctionCallImpl ? (FunctionCallImpl)functionCall : null;
                String string4 = string2 = functionCallImpl == null ? null : functionCallImpl.getFileName();
                if (string2 != null) {
                    for (String string5 : stringArray) {
                        Matcher matcher = choicePattern.matcher(string5);
                        if (!matcher.matches()) continue;
                        string3 = matcher.group(1);
                        String string6 = matcher.group(2);
                        if (string6.endsWith(string2)) break;
                    }
                }
                this.post(string3);
                stringArray = this.outProcessor.getOutput();
            }
            return new FunctionStatistic(stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] exec(String string) throws IOException {
        Erprint erprint = this;
        synchronized (erprint) {
            if (this.stopped) {
                return new String[0];
            }
            long l = System.currentTimeMillis();
            try {
                this.log.finest("> " + string + "'");
                this.post(string);
            }
            catch (IOException iOException) {
                this.stop();
                return new String[0];
            }
            String[] stringArray = this.outProcessor.getOutput();
            this.log.finest("Command '" + string + "' done in " + (System.currentTimeMillis() - l) / 1000L + " secs. Response is " + stringArray.length + " lines.");
            return stringArray;
        }
    }

    private class OutputProcessor {
        private final ArrayList<String> resultBuffer = new ArrayList();
        private final StringBuilder lineBuffer = new StringBuilder();
        private final char[] prompt;
        private final char[] enterSelectionPrompt = "Enter selection: ".toCharArray();
        private final InputStream pis;

        public OutputProcessor() throws IOException {
            this.pis = Erprint.this.process.getInputStream();
            this.prompt = this.getPrompt();
        }

        public String[] getOutput() throws IOException {
            int n;
            int n2 = 0;
            int n3 = 0;
            this.resultBuffer.clear();
            this.lineBuffer.setLength(0);
            while ((n = this.pis.read()) >= 0) {
                if (n == 10) {
                    this.resultBuffer.add(this.lineBuffer.toString());
                    this.lineBuffer.setLength(0);
                } else {
                    this.lineBuffer.append((char)n);
                }
                if (n2 == this.prompt.length) break;
                if (this.prompt[n2] == n) {
                    if (++n2 == this.prompt.length) {
                        break;
                    }
                } else {
                    n2 = 0;
                }
                if (this.enterSelectionPrompt[n3] == n) {
                    if (++n3 != this.enterSelectionPrompt.length) continue;
                    break;
                }
                n3 = 0;
            }
            return this.resultBuffer.toArray(new String[0]);
        }

        private char[] getPrompt() throws IOException {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            char[] cArray = new char[256];
            char[] cArray2 = null;
            try {
                int n4;
                cArray[0] = (char)Erprint.this.out.read();
                Erprint.this.post("");
                while ((n4 = Erprint.this.out.read()) >= 0) {
                    cArray[++n] = (char)n4;
                    if (cArray[n2] == cArray[n]) {
                        if (n3 == 0) {
                            n3 = n;
                        }
                        if (++n2 != n3) continue;
                        break;
                    }
                    n3 = 0;
                    n2 = 0;
                }
                cArray2 = new char[n2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.currentThread().interrupt();
                Erprint.this.stop();
                cArray2 = "<Terminated>".toCharArray();
            }
            return cArray2;
        }
    }
}

