/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanPropertyRowMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class mappedClass;
    private Constructor defaultConstruct;
    private Map mappedFields;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$lang$Number;

    protected synchronized void doSetMappedClass(Class mappedClass) {
        if (this.mappedClass == null) {
            this.initialize(mappedClass);
        } else if (!this.mappedClass.equals(mappedClass)) {
            throw new InvalidDataAccessApiUsageException("The mapped class can not be reassigned to map to " + mappedClass + " since it is already providing mapping for " + this.mappedClass);
        }
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    protected Object doMapRow(ResultSet rs, int rowNumber) throws SQLException {
        Object result;
        if (this.getMappedClass() == null) {
            throw new InvalidDataAccessApiUsageException("Target class was not specified - it is mandatory");
        }
        try {
            result = this.defaultConstruct.newInstance(null);
        }
        catch (IllegalAccessException e) {
            throw new DataAccessResourceFailureException("Failed to load class " + this.mappedClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new DataAccessResourceFailureException("Failed to load class " + this.mappedClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new DataAccessResourceFailureException("Failed to load class " + this.mappedClass.getName(), e);
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int columns = rsmd.getColumnCount();
        for (int i = 1; i <= columns; ++i) {
            String column = JdbcUtils.lookupColumnName(rsmd, i).toLowerCase();
            PersistentField fieldMeta = (PersistentField)this.mappedFields.get(column);
            if (fieldMeta == null) continue;
            BeanWrapperImpl bw = new BeanWrapperImpl(this.mappedClass);
            bw.setWrappedInstance(result);
            fieldMeta.setSqlType(rsmd.getColumnType(i));
            Object value = null;
            Class fieldType = fieldMeta.getJavaType();
            if (fieldType.equals(class$java$lang$String == null ? AbstractBeanPropertyRowMapper.class$("java.lang.String") : class$java$lang$String)) {
                value = rs.getString(column);
            } else if (fieldType.equals(Byte.TYPE) || fieldType.equals(class$java$lang$Byte == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Byte") : class$java$lang$Byte)) {
                value = new Byte(rs.getByte(column));
            } else if (fieldType.equals(Short.TYPE) || fieldType.equals(class$java$lang$Short == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Short") : class$java$lang$Short)) {
                value = new Short(rs.getShort(column));
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(class$java$lang$Integer == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Integer") : class$java$lang$Integer)) {
                value = new Integer(rs.getInt(column));
            } else if (fieldType.equals(Long.TYPE) || fieldType.equals(class$java$lang$Long == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Long") : class$java$lang$Long)) {
                value = new Long(rs.getLong(column));
            } else if (fieldType.equals(Float.TYPE) || fieldType.equals(class$java$lang$Float == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Float") : class$java$lang$Float)) {
                value = new Float(rs.getFloat(column));
            } else if (fieldType.equals(Double.TYPE) || fieldType.equals(class$java$lang$Double == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Double") : class$java$lang$Double)) {
                value = new Double(rs.getDouble(column));
            } else if (fieldType.equals(class$java$math$BigDecimal == null ? AbstractBeanPropertyRowMapper.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                value = rs.getBigDecimal(column);
            } else if (fieldType.equals(Boolean.TYPE) || fieldType.equals(class$java$lang$Boolean == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                value = rs.getBoolean(column) ? Boolean.TRUE : Boolean.FALSE;
            } else if (fieldType.equals(class$java$util$Date == null ? AbstractBeanPropertyRowMapper.class$("java.util.Date") : class$java$util$Date) || fieldType.equals(class$java$sql$Timestamp == null ? AbstractBeanPropertyRowMapper.class$("java.sql.Timestamp") : class$java$sql$Timestamp) || fieldType.equals(class$java$sql$Time == null ? AbstractBeanPropertyRowMapper.class$("java.sql.Time") : class$java$sql$Time) || fieldType.equals(class$java$lang$Number == null ? AbstractBeanPropertyRowMapper.class$("java.lang.Number") : class$java$lang$Number)) {
                value = JdbcUtils.getResultSetValue(rs, rs.findColumn(column));
            }
            if (value == null) continue;
            if (bw.isWritableProperty(fieldMeta.getFieldName())) {
                try {
                    if (this.logger.isDebugEnabled() && rowNumber == 0) {
                        this.logger.debug((Object)("Mapping column named \"" + column + "\"" + " containing values of SQL type " + fieldMeta.getSqlType() + " to property \"" + fieldMeta.getFieldName() + "\"" + " of type " + fieldMeta.getJavaType()));
                    }
                    bw.setPropertyValue(fieldMeta.getFieldName(), value);
                    continue;
                }
                catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column " + column + " to property " + fieldMeta.getFieldName(), ex);
                }
            }
            if (rowNumber != 0) continue;
            this.logger.warn((Object)("Unable to access the setter for " + fieldMeta.getFieldName() + ".  Check that " + "set" + StringUtils.capitalize(fieldMeta.getFieldName()) + " is declared and has public access."));
        }
        return result;
    }

    protected void initialize(Class mappedClass) {
        this.mappedClass = mappedClass;
        try {
            this.defaultConstruct = mappedClass.getConstructor(null);
        }
        catch (NoSuchMethodException ex) {
            throw new DataAccessResourceFailureException("Failed to access default or no-arg constructor of " + mappedClass.getName(), ex);
        }
        this.mappedFields = new HashMap();
        for (Class metaDataClass = mappedClass; metaDataClass != null; metaDataClass = metaDataClass.getSuperclass()) {
            Field[] f = metaDataClass.getDeclaredFields();
            for (int i = 0; i < f.length; ++i) {
                PersistentField pf = new PersistentField();
                pf.setFieldName(f[i].getName());
                pf.setJavaType(f[i].getType());
                this.mappedFields.put(f[i].getName().toLowerCase(), pf);
                String underscoredName = AbstractBeanPropertyRowMapper.underscoreName(f[i].getName());
                if (f[i].getName().toLowerCase().equals(underscoredName)) continue;
                this.mappedFields.put(underscoredName, pf);
            }
        }
    }

    public static String underscoreName(String name) {
        StringBuffer result = new StringBuffer();
        if (name != null && name.length() > 0) {
            result.append(name.substring(0, 1).toLowerCase());
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals(s.toUpperCase())) {
                    result.append("_");
                    result.append(s.toLowerCase());
                    continue;
                }
                result.append(s);
            }
        }
        return result.toString();
    }

    protected class PersistentField {
        private String fieldName;
        private Class javaType;
        private int sqlType;

        protected PersistentField() {
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public void setJavaType(Class javaType) {
            this.javaType = javaType;
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(int sqlType) {
            this.sqlType = sqlType;
        }
    }
}

