/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.object.MappingSqlQuery;

public class SqlFunction
extends MappingSqlQuery {
    private final SingleColumnRowMapper rowMapper = new SingleColumnRowMapper();

    public SqlFunction() {
        this.setRowsExpected(1);
    }

    public SqlFunction(DataSource ds, String sql) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public SqlFunction(DataSource ds, String sql, int[] types) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
    }

    public SqlFunction(DataSource ds, String sql, int[] types, Class resultType) {
        this.setRowsExpected(1);
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.setResultType(resultType);
    }

    public void setResultType(Class resultType) {
        this.rowMapper.setRequiredType(resultType);
    }

    protected Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        return this.rowMapper.mapRow(rs, rowNum);
    }

    public int run() {
        return this.run(null);
    }

    public int run(int parameter) {
        return this.run(new Object[]{new Integer(parameter)});
    }

    public int run(Object[] parameters) {
        Object obj = super.findObject(parameters);
        if (!(obj instanceof Number)) {
            throw new TypeMismatchDataAccessException("Couldn't convert result object [" + obj + "] to int");
        }
        return ((Number)obj).intValue();
    }

    public Object runGeneric() {
        return this.findObject((Object[])null);
    }

    public Object runGeneric(int parameter) {
        return this.findObject(parameter);
    }

    public Object runGeneric(Object[] parameters) {
        return this.findObject(parameters);
    }
}

