/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.annotate;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationBar;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TooltipWindow
implements AWTEventListener,
MouseMotionListener,
MouseListener {
    private String message;
    private String commitMessage;
    private final AnnotationBar master;
    private JTextPane textPane;
    private final AnnotateLine annotateLine;
    private int messageOffset;
    private Linker[] positions;
    private LinkedList<Linker> linkers;
    private Popup popup;

    public TooltipWindow(AnnotationBar annotationBar, AnnotateLine annotateLine) {
        this.annotateLine = annotateLine;
        this.master = annotationBar;
    }

    public void show(Point point) {
        GraphicsDevice graphicsDevice;
        GraphicsConfiguration graphicsConfiguration;
        GraphicsDevice[] graphicsDeviceArray;
        this.prepareMessage();
        Rectangle rectangle = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object object = graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = ((GraphicsDevice[])object).length;
        for (int i = 0; i < n && !(rectangle = (graphicsConfiguration = (graphicsDevice = object[i]).getDefaultConfiguration()).getBounds()).contains(point); ++i) {
        }
        object = new TooltipContentPanel(this.master.getTextComponent());
        this.popup = PopupFactory.getSharedInstance().getPopup(SwingUtilities.windowForComponent(this.master.getTextComponent()), (Component)object, (int)point.getX(), (int)point.getY());
        this.popup.show();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501 || aWTEvent.getID() == 401) {
            this.onClick(aWTEvent);
        }
    }

    private void click(Linker linker) {
        linker.provider.onClick(this.master.getCurrentFile(), this.commitMessage, linker.startOffset, linker.endOffset);
    }

    private Linker getLinkerInPosition(Point point) {
        Linker linker = null;
        int n = this.textPane.viewToModel(point) - this.messageOffset;
        if (n > -1) {
            linker = this.getLinkerInPosition(n);
        }
        return linker;
    }

    private Linker getLinkerInPosition(int n) {
        Linker linker = null;
        if (n < this.positions.length) {
            linker = this.positions[n];
        }
        return linker;
    }

    private List<Linker> getLinkers() {
        return Collections.unmodifiableList(this.linkers);
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        if (this.outsideOfTooltipWindow(component)) {
            this.shutdown();
        }
    }

    private boolean outsideOfTooltipWindow(Component component) {
        boolean bl = true;
        while (component != null) {
            if (component instanceof TooltipContentPanel) {
                bl = false;
                break;
            }
            component = component.getParent();
        }
        return bl;
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.popup != null) {
            this.popup.hide();
        }
        this.popup = null;
    }

    private void prepareMessage() {
        HyperlinkProvider hyperlinkProvider;
        int[] nArray;
        this.commitMessage = this.annotateLine.getCommitMessage();
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.annotateLine.getRevision()).append(":").append(this.annotateLine.getId()).append(" - ").append(this.annotateLine.getAuthor());
        if (this.annotateLine.getDate() != null) {
            stringBuilder.append(" ").append(DateFormat.getDateInstance().format(this.annotateLine.getDate()));
        }
        this.positions = new Linker[this.commitMessage.length()];
        this.linkers = new LinkedList();
        List<HyperlinkProvider> list = Mercurial.getInstance().getHyperlinkProviders();
        Iterator<HyperlinkProvider> iterator = list.iterator();
        while (iterator.hasNext() && (nArray = (hyperlinkProvider = iterator.next()).getSpans(this.commitMessage)) != null) {
            int n = nArray.length;
            if ((n & 1) != 0) {
                --n;
            }
            int n2 = 0;
            while (n2 < n) {
                Linker linker = new Linker();
                linker.startOffset = nArray[n2++];
                linker.endOffset = nArray[n2++];
                linker.provider = hyperlinkProvider;
                for (int i = linker.startOffset; i < linker.endOffset; ++i) {
                    this.positions[i] = linker;
                }
                this.linkers.add(linker);
            }
        }
        this.messageOffset = stringBuilder.toString().length() + 1;
        stringBuilder.append("\n").append(this.commitMessage);
        this.message = stringBuilder.toString();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.textPane)) {
            Linker linker = null;
            linker = this.getLinkerInPosition(mouseEvent.getPoint());
            if (linker != null) {
                this.textPane.setCursor(Cursor.getPredefinedCursor(12));
                this.textPane.setToolTipText(linker.provider.getTooltip(this.commitMessage, linker.startOffset, linker.endOffset));
                return;
            }
            this.textPane.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.textPane.setToolTipText("");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Linker linker;
        if (mouseEvent.getSource().equals(this.textPane) && (linker = this.getLinkerInPosition(mouseEvent.getPoint())) != null) {
            this.click(linker);
            this.shutdown();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class Linker {
        private int startOffset;
        private int endOffset;
        private HyperlinkProvider provider;

        private Linker() {
        }
    }

    private class TooltipContentPanel
    extends JComponent {
        public TooltipContentPanel(JTextComponent jTextComponent) {
            TooltipWindow.this.textPane = new JTextPane();
            TooltipWindow.this.textPane.setText(TooltipWindow.this.message);
            StyledDocument styledDocument = (StyledDocument)TooltipWindow.this.textPane.getDocument();
            Style style = TooltipWindow.this.textPane.getStyle("normal");
            Style style2 = TooltipWindow.this.textPane.addStyle("hyperlink", style);
            StyleConstants.setForeground(style2, Color.BLUE);
            StyleConstants.setUnderline(style2, true);
            TooltipWindow.this.textPane.setDocument(styledDocument);
            TooltipWindow.this.textPane.setEditable(false);
            Color color = new Color(233, 241, 255);
            TooltipWindow.this.textPane.setBackground(color);
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
            int n = element.getElementCount();
            int n2 = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).getHeight() * (n + 1);
            List list = TooltipWindow.this.getLinkers();
            for (Linker linker : list) {
                styledDocument.setCharacterAttributes(TooltipWindow.this.messageOffset + linker.startOffset, linker.endOffset - linker.startOffset, style2, true);
            }
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                String string = null;
                try {
                    string = styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                int n4 = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).stringWidth(string);
                if (n4 <= n3) continue;
                n3 = n4;
            }
            if (n3 < 50) {
                n3 = 50;
            }
            TooltipWindow.this.textPane.setPreferredSize(new Dimension(n3 * 7 / 6, n2));
            if (!TooltipWindow.this.textPane.isEditable()) {
                TooltipWindow.this.textPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
            }
            TooltipWindow.this.textPane.addMouseListener(TooltipWindow.this);
            TooltipWindow.this.textPane.addMouseMotionListener(TooltipWindow.this);
            JScrollPane jScrollPane = new JScrollPane(TooltipWindow.this.textPane);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
            this.setLayout(new BorderLayout());
            this.add(jScrollPane);
        }
    }
}

