/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.clone;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.PasswordAuthentication;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgKenaiSupport;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.clone.Clone;
import org.netbeans.modules.mercurial.ui.clone.CloneCompleted;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CloneAction
extends ContextAction {
    private final VCSContext context;
    private static final String HG_PATHS_SECTION_ENCLOSED = "[paths]";

    public CloneAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        Clone clone;
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        File file3 = HgUtils.getProjectFile(this.context);
        String string = file.getName();
        Boolean bl = true;
        if (!file.equals(file3)) {
            bl = false;
        }
        for (int i = 0; i < 10000; ++i) {
            if (new File(file2, string + "_clone" + i).exists()) continue;
            file2 = new File(file2, string + "_clone" + i);
            break;
        }
        if (!(clone = new Clone(file, file2)).showDialog()) {
            return;
        }
        CloneAction.performClone(new HgURL(file), clone.getTargetDir(), bl, file3, true, null, null);
    }

    public static RequestProcessor.Task performClone(HgURL hgURL, File file, boolean bl, File file2, HgURL hgURL2, HgURL hgURL3) {
        return CloneAction.performClone(hgURL, file, bl, file2, false, hgURL2, hgURL3);
    }

    private static RequestProcessor.Task performClone(final HgURL hgURL, final File file, final boolean bl, final File file2, final boolean bl2, final HgURL hgURL2, final HgURL hgURL3) {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(hgURL);
        final HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                OutputLogger outputLogger;
                block31: {
                    HgConfigFiles hgConfigFiles;
                    block30: {
                        block22: {
                            String string = file2 != null ? HgProjectUtils.getProjectName(file2) : null;
                            outputLogger = this.getLogger();
                            try {
                                try {
                                    CloneCompleted cloneCompleted;
                                    block23: {
                                        block25: {
                                            HgConfigFiles hgConfigFiles2;
                                            block24: {
                                                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE"));
                                                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE_SEP"));
                                                List<String> list = HgCommand.doClone(hgURL, file, outputLogger);
                                                if (list == null || list.isEmpty()) break block22;
                                                HgUtils.createIgnored(file);
                                                outputLogger.output(list);
                                                if (string != null) {
                                                    outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_FROM", (Object)string, (Object)hgURL));
                                                    outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TO", (Object)string, (Object)file));
                                                } else {
                                                    outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_FROM", (Object)hgURL));
                                                    outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_TO", (Object)file));
                                                }
                                                outputLogger.output("");
                                                if (bl2) {
                                                    File file3;
                                                    Mercurial mercurial = Mercurial.getInstance();
                                                    ProjectManager projectManager = ProjectManager.getDefault();
                                                    File file22 = FileUtil.normalizeFile((File)file);
                                                    if (!bl) {
                                                        String string2 = file2 != null ? file2.getAbsolutePath().substring(hgURL.getPath().length() + 1) : file.getAbsolutePath();
                                                        file3 = new File(file22, string2);
                                                    } else {
                                                        file3 = file22;
                                                    }
                                                    this.openProject(file3, projectManager, mercurial);
                                                    break block22;
                                                }
                                                if (!HgModuleConfig.getDefault().getShowCloneCompleted()) break block22;
                                                cloneCompleted = new CloneCompleted(file);
                                                if (!this.isCanceled()) break block23;
                                                Object var10_12 = null;
                                                hgConfigFiles2 = new HgConfigFiles(file);
                                                if (hgConfigFiles2.getException() != null) break block24;
                                                if (hgURL.isKenaiURL()) {
                                                    this.initializeDefaultPullPushUrlForKenai(hgConfigFiles2);
                                                    String string3 = this.getKenaiUserName();
                                                    if (string3 != null) {
                                                        hgConfigFiles2.setProperty("username", string3);
                                                    }
                                                    break block25;
                                                } else {
                                                    this.initializeDefaultPullPushUrl(hgConfigFiles2);
                                                }
                                                break block25;
                                            }
                                            Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set default push and pull path");
                                            Mercurial.LOG.log(Level.INFO, null, hgConfigFiles2.getException());
                                        }
                                        if (bl2) return;
                                        outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                                        outputLogger.output("");
                                        return;
                                    }
                                    cloneCompleted.scanForProjects(this);
                                }
                                catch (HgException hgException) {
                                    block27: {
                                        HgConfigFiles hgConfigFiles2;
                                        block26: {
                                            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                                            Object var10_14 = null;
                                            hgConfigFiles2 = new HgConfigFiles(file);
                                            if (hgConfigFiles2.getException() != null) break block26;
                                            if (hgURL.isKenaiURL()) {
                                                this.initializeDefaultPullPushUrlForKenai(hgConfigFiles2);
                                                string = this.getKenaiUserName();
                                                if (string != null) {
                                                    hgConfigFiles2.setProperty("username", string);
                                                }
                                                break block27;
                                            } else {
                                                this.initializeDefaultPullPushUrl(hgConfigFiles2);
                                            }
                                            break block27;
                                        }
                                        Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set default push and pull path");
                                        Mercurial.LOG.log(Level.INFO, null, hgConfigFiles2.getException());
                                    }
                                    if (bl2) return;
                                    outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                                    outputLogger.output("");
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                block29: {
                                    HgConfigFiles hgConfigFiles3;
                                    block28: {
                                        Object var10_15 = null;
                                        hgConfigFiles3 = new HgConfigFiles(file);
                                        if (hgConfigFiles3.getException() != null) break block28;
                                        if (hgURL.isKenaiURL()) {
                                            this.initializeDefaultPullPushUrlForKenai(hgConfigFiles3);
                                            String string4 = this.getKenaiUserName();
                                            if (string4 != null) {
                                                hgConfigFiles3.setProperty("username", string4);
                                            }
                                            break block29;
                                        } else {
                                            this.initializeDefaultPullPushUrl(hgConfigFiles3);
                                        }
                                        break block29;
                                    }
                                    Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set default push and pull path");
                                    Mercurial.LOG.log(Level.INFO, null, hgConfigFiles3.getException());
                                }
                                if (bl2) throw throwable;
                                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                                outputLogger.output("");
                                throw throwable;
                            }
                        }
                        Object var10_13 = null;
                        hgConfigFiles = new HgConfigFiles(file);
                        if (hgConfigFiles.getException() != null) break block30;
                        if (hgURL.isKenaiURL()) {
                            this.initializeDefaultPullPushUrlForKenai(hgConfigFiles);
                            String string = this.getKenaiUserName();
                            if (string != null) {
                                hgConfigFiles.setProperty("username", string);
                            }
                            break block31;
                        } else {
                            this.initializeDefaultPullPushUrl(hgConfigFiles);
                        }
                        break block31;
                    }
                    Mercurial.LOG.log(Level.WARNING, this.getClass().getName() + ": Cannot set default push and pull path");
                    Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
                }
                if (bl2) return;
                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                outputLogger.output("");
            }

            private void initializeDefaultPullPushUrl(HgConfigFiles hgConfigFiles) {
                if (hgURL2 == null && hgURL3 == null) {
                    String string = hgConfigFiles.getDefaultPull(false);
                    hgConfigFiles.setProperty("default-push", string);
                } else if (hgURL2 != null && hgURL3 == null) {
                    String string = hgURL2.toHgCommandUrlString();
                    hgConfigFiles.setProperty("default-pull", string);
                    hgConfigFiles.setProperty("default-push", string);
                } else if (hgURL2 == null && hgURL3 != null) {
                    String string = hgURL3.toHgCommandUrlString();
                    hgConfigFiles.setProperty("default-push", string);
                } else if (hgURL2 != null && hgURL3 != null) {
                    String string = hgURL2.toHgCommandUrlString();
                    String string2 = hgURL3.toHgCommandUrlString();
                    hgConfigFiles.setProperty("default-pull", string);
                    hgConfigFiles.setProperty("default-push", string2);
                }
            }

            private void initializeDefaultPullPushUrlForKenai(HgConfigFiles hgConfigFiles) {
                if (hgURL2 == null && hgURL3 == null) {
                    String string = hgConfigFiles.getDefaultPull(false);
                    String string2 = HgURL.stripUserInfo(string);
                    hgConfigFiles.setProperty("default-pull", string2);
                    hgConfigFiles.setProperty("default-push", string2);
                } else if (hgURL2 != null && hgURL3 == null) {
                    String string = hgURL2.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", string);
                    hgConfigFiles.setProperty("default-push", string);
                } else if (hgURL2 == null && hgURL3 != null) {
                    String string = hgConfigFiles.getDefaultPull(false);
                    String string3 = HgURL.stripUserInfo(string);
                    String string4 = hgURL3.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", string3);
                    hgConfigFiles.setProperty("default-push", string4);
                } else if (hgURL2 != null && hgURL3 != null) {
                    String string = hgURL2.toHgCommandUrlStringWithoutUserInfo();
                    String string5 = hgURL3.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", string);
                    hgConfigFiles.setProperty("default-push", string5);
                }
            }

            private String getKenaiUserName() {
                PasswordAuthentication passwordAuthentication = HgKenaiSupport.getInstance().getPasswordAuthentication(hgURL.toUrlStringWithoutUserInfo(), false);
                return passwordAuthentication != null ? passwordAuthentication.getUserName() : null;
            }

            private void openProject(final File file3, final ProjectManager projectManager, final Mercurial mercurial) throws MissingResourceException {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        OutputLogger outputLogger = this.getLogger();
                        try {
                            FileObject fileObject = FileUtil.toFileObject((File)file3);
                            Project project = null;
                            if (file3 != null && fileObject != null) {
                                project = projectManager.findProject(fileObject);
                            }
                            if (project != null) {
                                HgProjectUtils.openProject(project, this, HgModuleConfig.getDefault().getSetMainProject());
                                mercurial.versionedFilesChanged();
                                mercurial.refreshAllAnnotations();
                            } else {
                                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_PRJ_NOT_FOUND_CANT_SETASMAIN"));
                            }
                        }
                        catch (Exception exception) {
                            NotifyDescriptor.Exception exception2 = new NotifyDescriptor.Exception((Throwable)new HgException(exception.toString()));
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception2);
                        }
                        finally {
                            outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                            outputLogger.output("");
                        }
                    }
                });
            }
        };
        hgProgressSupport.setRepositoryRoot(hgURL);
        hgProgressSupport.setCancellableDelegate(new Cancellable(){

            public boolean cancel() {
                if (!Utilities.isWindows()) {
                    return true;
                }
                OutputLogger outputLogger = hgProgressSupport.getLogger();
                outputLogger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_ATTEMPT"));
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_NOT_SUPPORTED"), NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_NOT_SUPPORTED_TITLE"), 1);
                return false;
            }
        });
        return hgProgressSupport.start(requestProcessor, hgURL, NbBundle.getMessage(CloneAction.class, (String)"LBL_Clone_Progress", (Object)hgURL));
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void fixLocalPullPushPathsOnWindows(File var0) {
        block33: {
            block32: {
                block31: {
                    var1_1 = null;
                    var2_2 = null;
                    var3_3 = null;
                    var4_4 = null;
                    try {
                        try {
                            block35: {
                                block34: {
                                    var1_1 = new File(new File(var0, ".hg"), "hgrc");
                                    if (!var1_1.isFile()) break block34;
                                    if (var1_1.canWrite()) break block35;
                                }
                                var10_5 = null;
                                break block31;
                            }
                            var2_2 = new File(var1_1.getAbsolutePath() + ".tmp");
                            if (var2_2 == null) {
                                break block32;
                            }
                            var3_3 = new BufferedReader(new FileReader(var1_1));
                            var4_4 = new PrintWriter(new FileWriter(var2_2));
                            var5_15 = null;
                            var6_17 = false;
                            var7_18 = false;
                            var8_19 = false;
                            while ((var5_15 = var3_3.readLine()) != null) {
                                if (var5_15.startsWith("[paths]")) {
                                    var6_17 = true;
                                } else if (var5_15.startsWith("[")) {
                                    var6_17 = false;
                                }
                                if (var6_17 && !var7_18 && var5_15.startsWith("default") && !var5_15.startsWith("default-push")) {
                                    var4_4.println(var5_15.replace("\\", "\\\\"));
                                    var7_18 = true;
                                    continue;
                                }
                                if (var6_17 && !var7_18 && var5_15.startsWith("default-pull")) {
                                    var4_4.println(var5_15.replace("\\", "\\\\"));
                                    var7_18 = true;
                                    continue;
                                }
                                if (var6_17 && !var8_19 && var5_15.startsWith("default-push")) {
                                    var4_4.println(var5_15.replace("\\", "\\\\"));
                                    var8_19 = true;
                                    continue;
                                }
                                var4_4.println(var5_15);
                                var4_4.flush();
                            }
                            break block33;
                        }
                        catch (IOException var5_16) {
                            var10_8 = null;
                            try {
                                if (var4_4 != null) {
                                    var4_4.close();
                                }
                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                                if (var2_2 == null) return;
                                if (var2_2.isFile() == false) return;
                                if (var2_2.canWrite() == false) return;
                                if (var1_1 == null) return;
                                var1_1.delete();
                                var2_2.renameTo(var1_1);
                                return;
                            }
                            catch (IOException var11_13) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var9_20) {
                        var10_9 = null;
                        ** try [egrp 2[TRYBLOCK] [8 : 338->392)] { 
lbl70:
                        // 1 sources

                        if (var4_4 != null) {
                            var4_4.close();
                        }
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                        if (var2_2 == null) throw var9_20;
                        if (var2_2.isFile() == false) throw var9_20;
                        if (var2_2.canWrite() == false) throw var9_20;
                        if (var1_1 == null) throw var9_20;
                        var1_1.delete();
                        var2_2.renameTo(var1_1);
                        throw var9_20;
lbl83:
                        // 1 sources

                        catch (IOException var11_14) {
                            // empty catch block
                        }
                        throw var9_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 338->392)] { 
lbl88:
                // 1 sources

                if (var4_4 != null) {
                    var4_4.close();
                }
                if (var3_3 != null) {
                    var3_3.close();
                }
                if (var2_2 == null) return;
                if (var2_2.isFile() == false) return;
                if (var2_2.canWrite() == false) return;
                if (var1_1 == null) return;
                var1_1.delete();
                var2_2.renameTo(var1_1);
                return;
lbl101:
                // 1 sources

                catch (IOException var11_10) {
                    // empty catch block
                }
                return;
            }
            var10_6 = null;
            ** try [egrp 2[TRYBLOCK] [8 : 338->392)] { 
lbl107:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            if (var3_3 != null) {
                var3_3.close();
            }
            if (var2_2 == null) return;
            if (var2_2.isFile() == false) return;
            if (var2_2.canWrite() == false) return;
            if (var1_1 == null) return;
            var1_1.delete();
            var2_2.renameTo(var1_1);
            return;
lbl120:
            // 1 sources

            catch (IOException var11_11) {
                // empty catch block
            }
            return;
        }
        var10_7 = null;
        try {}
        catch (IOException var11_12) {}
        if (var4_4 != null) {
            var4_4.close();
        }
        if (var3_3 != null) {
            var3_3.close();
        }
        if (var2_2 == null) return;
        if (var2_2.isFile() == false) return;
        if (var2_2.canWrite() == false) return;
        if (var1_1 == null) return;
        var1_1.delete();
        var2_2.renameTo(var1_1);
        return;
    }
}

