/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.hooks.spi.HgHook;
import org.netbeans.modules.mercurial.hooks.spi.HgHookContext;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitPanel;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private final VCSContext context;

    public CommitAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        Set set;
        Set set2 = set = this.context != null ? this.context.getRootFiles() : null;
        return HgUtils.getRootFile(this.context) != null && set != null && set.size() != 0;
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String string = Utils.getContextDisplayName((VCSContext)this.context);
        CommitAction.commit(string, this.context);
    }

    public static void commit(String string, final VCSContext vCSContext) {
        File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        final CommitPanel commitPanel = new CommitPanel();
        final List<HgHook> list = Mercurial.getInstance().getHooks();
        commitPanel.initHooks(list, new HgHookContext(vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]), null, new HgHookContext.LogEntry[0]));
        final CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        JComponent jComponent = commitTable.getComponent();
        commitPanel.filesPanel.setLayout(new BorderLayout());
        commitPanel.filesPanel.add((Component)jComponent, "Center");
        final JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        JButton jButton2 = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)commitPanel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)string), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx(CommitAction.class), null);
        CommitAction.computeNodes(commitTable, commitPanel, vCSContext, file, jButton2);
        jButton.setEnabled(false);
        commitPanel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        commitTable.getTableModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, jButton);
            }
        });
        jButton.setEnabled(CommitAction.containsCommitable(commitTable));
        commitPanel.putClientProperty("contentTitle", string);
        commitPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), "hg.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            final Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
            final String string2 = commitPanel.messageTextArea.getText();
            Utils.insert((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)string2, (int)20);
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    CommitAction.performCommit(string2, map, vCSContext, this, outputLogger, list);
                }
            };
            hgProgressSupport.start(requestProcessor, file, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static void computeNodes(final CommitTable commitTable, final CommitPanel commitPanel, final VCSContext vCSContext, File file, JButton jButton) {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit"), jButton){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void perform() {
                block10: {
                    block9: {
                        try {
                            commitPanel.progressPanel.setVisible(true);
                            StatusAction.executeStatus(vCSContext, this);
                            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
                            File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
                            File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
                            ArrayList<File> arrayList = new ArrayList<File>();
                            for (int i = 0; i < fileArray2.length; ++i) {
                                int n;
                                File[] fileArray3;
                                boolean bl;
                                fileArray = fileArray2[i];
                                boolean bl2 = bl = i == 1;
                                if (bl) {
                                    fileArray3 = fileStatusCache.listFiles(vCSContext, 6612);
                                    for (n = 0; n < fileArray3.length; ++n) {
                                        for (int j = 0; j < fileArray.length; ++j) {
                                            if (!HgUtils.isParentOrEqual(fileArray[j], fileArray3[n]) || arrayList.contains(fileArray3[n])) continue;
                                            arrayList.add(fileArray3[n]);
                                        }
                                    }
                                    continue;
                                }
                                fileArray3 = HgUtils.flatten(fileArray, 6612);
                                for (n = 0; n < fileArray3.length; ++n) {
                                    if (arrayList.contains(fileArray3[n])) continue;
                                    arrayList.add(fileArray3[n]);
                                }
                            }
                            if (arrayList.size() == 0) {
                                Object var11_16 = null;
                                break block9;
                            }
                            ArrayList<HgFileNode> arrayList2 = new ArrayList<HgFileNode>(arrayList.size());
                            for (File file : arrayList) {
                                HgFileNode hgFileNode = new HgFileNode(file);
                                arrayList2.add(hgFileNode);
                            }
                            HgFileNode[] hgFileNodeArray = arrayList2.toArray(new HgFileNode[arrayList.size()]);
                            commitTable.setNodes(hgFileNodeArray);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var11_18 = null;
                            commitPanel.progressPanel.setVisible(false);
                            throw throwable;
                        }
                    }
                    commitPanel.progressPanel.setVisible(false);
                    return;
                }
                Object var11_17 = null;
                commitPanel.progressPanel.setVisible(false);
            }
        };
        commitPanel.progressPanel.add((Component)hgProgressSupport.getProgressComponent());
        commitPanel.progressPanel.setVisible(true);
        hgProgressSupport.start(requestProcessor);
    }

    private static boolean containsCommitable(CommitTable commitTable) {
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        for (CommitOptions commitOptions : map.values()) {
            if (commitOptions == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel commitPanel, CommitTable commitTable, JButton jButton) {
        String string;
        Object object;
        HgFileNode hgFileNode2;
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitAction.class);
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        HashSet hashSet = new HashSet();
        boolean bl = false;
        boolean bl2 = jButton.isEnabled();
        for (HgFileNode hgFileNode2 : map.keySet()) {
            int n;
            object = map.get(hgFileNode2);
            if (object == CommitOptions.EXCLUDE || ((n = hgFileNode2.getInformation().getStatus()) & 0x6A0) == 0 && n != 64) continue;
            bl2 = false;
            string = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
            commitPanel.setErrorLabel("<html><font color=\"#002080\">" + string + "</font></html>");
            bl = true;
        }
        if (hashSet.size() > 1) {
            commitTable.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            commitTable.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string2 = (String)commitPanel.getClientProperty("contentTitle");
        hgFileNode2 = (DialogDescriptor)commitPanel.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string3;
            String string4 = string3 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string3 == null) {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string2));
                object = "";
            } else {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string2, string3));
                string = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string3);
                object = "<html><font color=\"#002080\">" + string + "</font></html>";
            }
        } else {
            hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string2));
            String string5 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            object = "<html><font color=\"#CC0000\">" + string5 + "</font></html>";
        }
        if (!bl) {
            commitPanel.setErrorLabel((String)object);
            bl2 = true;
        }
        jButton.setEnabled(bl2 && CommitAction.containsCommitable(commitTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void performCommit(String string, Map<HgFileNode, CommitOptions> map, VCSContext vCSContext, HgProgressSupport hgProgressSupport, OutputLogger outputLogger, List<HgHook> list) {
        Object object2;
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File file = HgUtils.getRootFile(vCSContext);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        Iterator<HgFileNode> iterator = map.keySet().iterator();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        while (iterator.hasNext()) {
            if (hgProgressSupport.isCanceled()) {
                return;
            }
            object2 = iterator.next();
            CommitOptions object3 = map.get(object2);
            if (object3 != CommitOptions.EXCLUDE) {
                int n = fileStatusCache.getStatus(object2.getFile()).getStatus();
                if ((n & 4) != 0) {
                    arrayList.add(object2.getFile());
                } else if ((n & 0x800) != 0) {
                    arrayList2.add(object2.getFile());
                }
                arrayList3.add(object2.getFile());
                arrayList5.add(object2.getFile().getAbsolutePath());
                continue;
            }
            arrayList4.add(object2.getFile().getAbsolutePath());
        }
        if (hgProgressSupport.isCanceled()) {
            return;
        }
        if (!arrayList4.isEmpty()) {
            HgModuleConfig.getDefault().addExclusionPaths(arrayList4);
        }
        if (!arrayList5.isEmpty()) {
            HgModuleConfig.getDefault().removeExclusionPaths(arrayList5);
        }
        try {
            try {
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
                outputLogger.output(string);
                if (arrayList.size() > 0) {
                    HgCommand.doAdd(file, arrayList, outputLogger);
                    for (File file2 : arrayList) {
                        outputLogger.output("hg add " + file2.getName());
                    }
                }
                if (arrayList2.size() > 0) {
                    HgCommand.doRemove(file, arrayList2, outputLogger);
                    for (File file3 : arrayList2) {
                        outputLogger.output("hg delete " + file3.getName());
                    }
                }
                object2 = null;
                if (list.size() > 0) {
                    object2 = arrayList3.toArray(new File[arrayList3.size()]);
                }
                HgHookContext hgHookContext = new HgHookContext((File[])object2, string, new HgHookContext.LogEntry[0]);
                for (HgHook hgHook : list) {
                    try {
                        void var15_22;
                        HgHookContext hgHookContext2 = hgHook.beforeCommit((HgHookContext)var15_22);
                        if (hgHookContext2 == null) continue;
                        string = hgHookContext2.getMessage();
                    }
                    catch (IOException iOException) {}
                }
                HgCommand.doCommit(file, arrayList3, string, outputLogger);
                HgRepositoryContextCache.getInstance().setHasHistory(vCSContext);
                HgLogMessage hgLogMessage = HgCommand.doTip(file, outputLogger);
                HgHookContext hgHookContext3 = new HgHookContext((File[])object2, string, new HgHookContext.LogEntry[]{new HgHookContext.LogEntry(hgLogMessage)});
                for (HgHook hgHook : list) {
                    hgHook.afterCommit(hgHookContext3);
                }
                if (arrayList3.size() == 1) {
                    outputLogger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP_ONE", (Object)arrayList3.size()));
                } else {
                    outputLogger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP", (Object)arrayList3.size()));
                }
                for (File file4 : arrayList3) {
                    outputLogger.output("\t" + file4.getAbsolutePath());
                }
                HgUtils.logHgLog(hgLogMessage, outputLogger);
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var20_37 = null;
                fileStatusCache.refreshCached(vCSContext);
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                outputLogger.output("");
            }
            Object var20_36 = null;
            fileStatusCache.refreshCached(vCSContext);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
            outputLogger.output("");
        }
        catch (Throwable throwable) {
            Object var20_38 = null;
            fileStatusCache.refreshCached(vCSContext);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
            outputLogger.output("");
            throw throwable;
        }
    }
}

