/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.wizards.WizardStepProgressSupport;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CloneRepositoryWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel,
ChangeListener {
    private JComponent component;
    private Repository repository;
    private boolean valid;
    private String errorMessage;
    private WizardStepProgressSupport support;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public CloneRepositoryWizardPanel() {
        this.support = new RepositoryStepProgressSupport();
    }

    public Component getComponent() {
        if (this.component == null) {
            this.repository = new Repository(100, CloneRepositoryWizardPanel.getMessage("CTL_Repository_Location"), false);
            this.repository.addChangeListener(this);
            this.support = new RepositoryStepProgressSupport();
            this.component = new JPanel(new BorderLayout());
            this.component.add((Component)this.repository.getPanel(), "Center");
            this.component.add((Component)this.support.getProgressComponent(), "South");
            this.component.setName(CloneRepositoryWizardPanel.getMessage("repositoryPanel.Name"));
            this.valid();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(CloneRepositoryWizardPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.repository.isValid()) {
            this.valid(this.repository.getMessage());
        } else {
            this.invalid(this.repository.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    protected final void valid() {
        this.setValid(true, null);
    }

    protected final void valid(String string) {
        this.setValid(true, string);
    }

    protected final void invalid(String string) {
        this.setValid(false, string);
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private void displayErrorMessage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("<null> message");
        }
        if (!string.equals(this.errorMessage)) {
            this.errorMessage = string;
            this.fireChangeEvent();
        }
    }

    private void setValid(boolean bl, String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        boolean bl2 = this.valid != bl;
        boolean bl3 = string != null && !string.equals(this.errorMessage);
        this.valid = bl;
        this.errorMessage = string;
        if (bl2 |= bl3) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() throws WizardValidationException {
        try {
            HgURL hgURL;
            try {
                hgURL = this.repository.getUrl();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WizardValidationException(this.component, uRISyntaxException.getMessage(), uRISyntaxException.getLocalizedMessage());
            }
            if (this.support == null) {
                this.support = new RepositoryStepProgressSupport();
                this.component.add((Component)this.support.getProgressComponent(), "South");
            }
            this.support.setRepositoryRoot(hgURL);
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(hgURL);
            RequestProcessor.Task task = this.support.start(requestProcessor, hgURL, NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"BK2012"));
            task.waitFinished();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.component.remove(this.support.getProgressComponent());
            this.support = null;
            throw throwable;
        }
        this.component.remove(this.support.getProgressComponent());
        this.support = null;
    }

    public final void validate() throws WizardValidationException {
        this.validateBeforeNext();
        if (!this.isValid() || this.errorMessage != null) {
            throw new WizardValidationException(this.component, this.errorMessage, this.errorMessage);
        }
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
        if (object instanceof WizardDescriptor) {
            try {
                ((WizardDescriptor)object).putProperty("repository", (Object)this.repository.getUrl());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "storeSettings", uRISyntaxException);
            }
        }
    }

    public void prepareValidation() {
        this.errorMessage = null;
        this.repository.setEditable(false);
    }

    private void storeHistory() {
        RepositoryConnection repositoryConnection = this.getRepositoryConnection();
        if (repositoryConnection != null) {
            HgModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
    }

    private RepositoryConnection getRepositoryConnection() {
        try {
            return this.repository.getRepositoryConnection();
        }
        catch (Exception exception) {
            this.displayErrorMessage(exception.getLocalizedMessage());
            return null;
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform() {
            HttpURLConnection httpURLConnection;
            String string;
            block32: {
                block35: {
                    block33: {
                        RepositoryConnection repositoryConnection = CloneRepositoryWizardPanel.this.getRepositoryConnection();
                        if (repositoryConnection == null) {
                            return;
                        }
                        string = null;
                        httpURLConnection = null;
                        try {
                            block34: {
                                try {
                                    boolean bl;
                                    URL uRL;
                                    HgURL hgURL = this.getRepositoryRoot();
                                    HgURL.Scheme scheme = hgURL.getScheme();
                                    if (scheme == HgURL.Scheme.FILE) {
                                        File file = HgURL.getFile(hgURL);
                                        if (file.exists() && file.canRead()) break block32;
                                        string = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                                        Object var10_12 = null;
                                        if (httpURLConnection == null) break block33;
                                        break block34;
                                    }
                                    if (scheme != HgURL.Scheme.HTTP && scheme != HgURL.Scheme.HTTPS || (httpURLConnection = (HttpURLConnection)(uRL = hgURL.toURL()).openConnection()) == null) break block32;
                                    String string2 = uRL.getUserInfo();
                                    boolean bl2 = bl = string2 == null;
                                    if (scheme == HgURL.Scheme.HTTPS) {
                                        this.setupHttpsConnection(httpURLConnection);
                                    }
                                    if (bl && httpURLConnection.getResponseCode() != 200) {
                                        string = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                                        httpURLConnection.disconnect();
                                        break block35;
                                    }
                                    if (string2 != null) {
                                        Mercurial.LOG.log(Level.FINE, "RepositoryStepProgressSupport.perform(): UserInfo - {0}", new Object[]{string2});
                                    }
                                    break block32;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    Mercurial.LOG.log(Level.INFO, illegalArgumentException.getMessage(), illegalArgumentException);
                                    string = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_InvalidURL_Err");
                                    Object var10_15 = null;
                                    if (httpURLConnection != null) {
                                        httpURLConnection.disconnect();
                                    }
                                    if (this.isCanceled()) {
                                        CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                                        return;
                                    }
                                    if (string == null) {
                                        CloneRepositoryWizardPanel.this.storeHistory();
                                        return;
                                    }
                                    CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                                    return;
                                }
                                catch (IOException iOException) {
                                    Mercurial.LOG.log(Level.INFO, iOException.getMessage(), iOException);
                                    string = CloneRepositoryWizardPanel.getMessage("MSG_Progress_Clone_CannotAccess_Err");
                                    Object var10_16 = null;
                                    if (httpURLConnection != null) {
                                        httpURLConnection.disconnect();
                                    }
                                    if (this.isCanceled()) {
                                        CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                                        return;
                                    }
                                    if (string == null) {
                                        CloneRepositoryWizardPanel.this.storeHistory();
                                        return;
                                    }
                                    CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                                    return;
                                }
                                catch (RuntimeException runtimeException) {
                                    Throwable throwable = runtimeException.getCause();
                                    string = throwable != null ? throwable.getLocalizedMessage() : runtimeException.getLocalizedMessage();
                                    Mercurial.LOG.log(Level.INFO, string, runtimeException);
                                    Object var10_17 = null;
                                    if (httpURLConnection != null) {
                                        httpURLConnection.disconnect();
                                    }
                                    if (this.isCanceled()) {
                                        CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                                        return;
                                    }
                                    if (string == null) {
                                        CloneRepositoryWizardPanel.this.storeHistory();
                                        return;
                                    }
                                    CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                                    return;
                                }
                            }
                            httpURLConnection.disconnect();
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            if (httpURLConnection != null) {
                                httpURLConnection.disconnect();
                            }
                            if (this.isCanceled()) {
                                CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                                throw throwable;
                            }
                            if (string == null) {
                                CloneRepositoryWizardPanel.this.storeHistory();
                                throw throwable;
                            }
                            CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                            throw throwable;
                        }
                    }
                    if (this.isCanceled()) {
                        CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                        return;
                    }
                    if (string == null) {
                        CloneRepositoryWizardPanel.this.storeHistory();
                        return;
                    }
                    CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                    return;
                }
                Object var10_13 = null;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                if (this.isCanceled()) {
                    CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                    return;
                }
                if (string == null) {
                    CloneRepositoryWizardPanel.this.storeHistory();
                    return;
                }
                CloneRepositoryWizardPanel.this.displayErrorMessage(string);
                return;
            }
            Object var10_14 = null;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            if (this.isCanceled()) {
                CloneRepositoryWizardPanel.this.displayErrorMessage(CloneRepositoryWizardPanel.getMessage("CTL_Repository_Canceled"));
                return;
            }
            if (string == null) {
                CloneRepositoryWizardPanel.this.storeHistory();
                return;
            }
            CloneRepositoryWizardPanel.this.displayErrorMessage(string);
        }

        public void setEditable(boolean bl) {
            CloneRepositoryWizardPanel.this.repository.setEditable(bl);
        }

        private void setupHttpsConnection(HttpURLConnection httpURLConnection) {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            try {
                SSLContext sSLContext = SSLContext.getInstance("SSLv3");
                TrustManager[] trustManagerArray = new TrustManager[]{x509TrustManager};
                sSLContext.init(null, trustManagerArray, null);
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                httpsURLConnection.setHostnameVerifier(hostnameVerifier);
            }
            catch (KeyManagementException keyManagementException) {
                Mercurial.LOG.log(Level.INFO, keyManagementException.getMessage(), keyManagementException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Mercurial.LOG.log(Level.INFO, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
        }
    }
}

