/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgRepositoryContextCache {
    private static boolean hasHistory;
    private static String pushDefault;
    private static String pullDefault;
    private static File root;
    private static VCSContext rootCtx;
    private static Set<File> historyCtxRootFiles;
    private static Set<File> pushCtxRootFiles;
    private static Set<File> pullCtxRootFiles;
    private static Map<File, DefaultPaths> rootToDefaultPaths;
    private static HgRepositoryContextCache instance;

    private HgRepositoryContextCache() {
    }

    public static HgRepositoryContextCache getInstance() {
        if (instance == null) {
            instance = new HgRepositoryContextCache();
        }
        return instance;
    }

    public boolean hasHistory(VCSContext vCSContext) {
        if (vCSContext == null) {
            return false;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(historyCtxRootFiles)) {
            return hasHistory;
        }
        root = this.getRoot(vCSContext);
        hasHistory = HgCommand.hasHistory(root);
        historyCtxRootFiles = vCSContext.getRootFiles();
        return hasHistory;
    }

    public void setHasHistory(VCSContext vCSContext) {
        historyCtxRootFiles = vCSContext.getRootFiles();
        hasHistory = true;
    }

    public synchronized String getPullDefault(VCSContext vCSContext) {
        if (vCSContext == null) {
            return null;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(pullCtxRootFiles)) {
            return pullDefault;
        }
        root = this.getRoot(vCSContext);
        pullDefault = new HgConfigFiles(root).getDefaultPull(true);
        pullCtxRootFiles = vCSContext.getRootFiles();
        return pullDefault;
    }

    public synchronized void reset() {
        pushCtxRootFiles = null;
        pullCtxRootFiles = null;
        this.getRootToDefaultPaths().clear();
    }

    public synchronized String getPushDefault(VCSContext vCSContext) {
        if (vCSContext == null) {
            return null;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(pushCtxRootFiles)) {
            return pushDefault;
        }
        root = this.getRoot(vCSContext);
        pushDefault = new HgConfigFiles(root).getDefaultPush(true);
        pushCtxRootFiles = vCSContext.getRootFiles();
        return pushDefault;
    }

    private File getRoot(VCSContext vCSContext) {
        if (vCSContext == rootCtx && root != null) {
            return root;
        }
        root = HgUtils.getRootFile(vCSContext);
        rootCtx = vCSContext;
        return root;
    }

    public synchronized String getPullDefault(File file) {
        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
        if (file2 == null) {
            return null;
        }
        DefaultPaths defaultPaths = this.getDefaultPaths(file2);
        return defaultPaths.pull;
    }

    public synchronized String getPushDefault(File file) {
        File file2 = Mercurial.getInstance().getRepositoryRoot(file);
        if (file2 == null) {
            return null;
        }
        DefaultPaths defaultPaths = this.getDefaultPaths(file2);
        return defaultPaths.push;
    }

    private DefaultPaths getDefaultPaths(File file) {
        Map<File, DefaultPaths> map = this.getRootToDefaultPaths();
        DefaultPaths defaultPaths = map.get(file);
        if (defaultPaths == null) {
            HgConfigFiles hgConfigFiles = new HgConfigFiles(file);
            String string = hgConfigFiles.getDefaultPull(true);
            String string2 = hgConfigFiles.getDefaultPush(true);
            defaultPaths = new DefaultPaths(string, string2);
            map.put(root, defaultPaths);
        }
        return defaultPaths;
    }

    private Map<File, DefaultPaths> getRootToDefaultPaths() {
        if (rootToDefaultPaths == null) {
            rootToDefaultPaths = new HashMap<File, DefaultPaths>();
        }
        return rootToDefaultPaths;
    }

    private static class DefaultPaths {
        String pull;
        String push;

        public DefaultPaths(String string, String string2) {
            this.pull = string;
            this.push = string2;
        }
    }
}

