/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.modules.uihandler.VisualData;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UINode
extends AbstractNode
implements VisualData,
Decorable {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();
    private LogRecord log;
    private String htmlKey;

    private UINode(LogRecord logRecord, Children children) {
        super(children, Lookups.fixed((Object[])new Object[]{logRecord}));
        this.log = logRecord;
        LogRecords.decorate((LogRecord)logRecord, (Decorable)this);
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put(UINode.createPropertyDate(this));
        set.put(UINode.createPropertyLogger(this));
        set.put(UINode.createPropertyMessage(this));
        this.getSheet().put(set);
        if (logRecord.getParameters() != null && logRecord.getParameters().length > 0) {
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("parameters");
            set2.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_DisplayNameParameters"));
            for (int i = 0; i < logRecord.getParameters().length; ++i) {
                set2.put(this.createProperty(i, UINode.getParam(logRecord, i, Object.class)));
            }
            this.getSheet().put(set2);
        }
    }

    @Override
    public long getMillis() {
        return this.log.getMillis();
    }

    @Override
    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    @Override
    public String getMessage() {
        return FORMATTER.format(this.log);
    }

    public String getHtmlDisplayName() {
        if (this.htmlKey == null) {
            return null;
        }
        return NbBundle.getMessage(UINode.class, (String)this.htmlKey, (Object)this.getDisplayName());
    }

    static String getParam(LogRecord logRecord, int n) {
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length <= n || !(objectArray[n] instanceof String)) {
            return "";
        }
        return (String)objectArray[n];
    }

    static Node create(LogRecord logRecord) {
        Children.Keys keys = logRecord.getThrown() != null ? new StackTraceChildren(logRecord.getThrown()) : ("UI_ENABLED_MODULES".equals(logRecord.getMessage()) || "UI_DISABLED_MODULES".equals(logRecord.getMessage()) ? new ModulesChildren(logRecord.getParameters()) : Children.LEAF);
        return new UINode(logRecord, (Children)keys);
    }

    static Node.Property createPropertyDate(VisualData visualData) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NP
        extends PropertySupport.ReadOnly<Date> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("date", Date.class, NbBundle.getMessage(UINode.class, (String)"MSG_DateDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_DateShortDescription"));
            }

            public Date getValue() throws IllegalAccessException, InvocationTargetException {
                return this.val$source == null ? null : new Date(this.val$source.getMillis());
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && object.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(visualData);
    }

    static Node.Property createPropertyLogger(VisualData visualData) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NP
        extends PropertySupport.ReadOnly<String> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("logger", String.class, NbBundle.getMessage(UINode.class, (String)"MSG_LoggerDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_LoggerShortDescription"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                if (this.val$source == null) {
                    return null;
                }
                String string = this.val$source.getLoggerName();
                if (string == null) {
                    return null;
                }
                if (string.startsWith("org.netbeans.ui")) {
                    if (string.equals("org.netbeans.ui")) {
                        return "UI General";
                    }
                    return string.substring("org.netbeans.ui.".length());
                }
                return string;
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && object.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(visualData);
    }

    static Node.Property createPropertyMessage(VisualData visualData) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NP
        extends PropertySupport.ReadOnly<String> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("message", String.class, NbBundle.getMessage(UINode.class, (String)"MSG_MessageDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_MessageShortDescription"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return this.val$source == null ? null : this.val$source.getMessage();
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object object) {
                return object != null && object.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(visualData);
    }

    private Node.Property<?> createProperty(final int n, final Object object) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NP
        extends PropertySupport.ReadOnly<String> {
            public NP() {
                super("param #" + n2, String.class, NbBundle.getMessage(UINode.class, (String)"MSG_ParameterDisplayName", (Object)n2, (Object)object2), NbBundle.getMessage(UINode.class, (String)"MSG_ParameterShortDescription", (Object)n2, (Object)object2));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return object == null ? null : object.toString();
            }

            private int getIndex() {
                return n;
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object object2) {
                if (object2 == null || !object2.getClass().equals(((Object)((Object)this)).getClass())) {
                    return false;
                }
                NP nP = (NP)((Object)object2);
                return this.getIndex() == nP.getIndex();
            }
        }
        return new NP();
    }

    private static String afterLastDot(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static <T> T getParam(LogRecord logRecord, int n, Class<T> clazz) {
        if (logRecord == null || logRecord.getParameters() == null || logRecord.getParameters().length <= n) {
            return null;
        }
        Object object = logRecord.getParameters()[n];
        return clazz.isInstance(object) ? (T)clazz.cast(object) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ModulesChildren
    extends Children.Keys<Object> {
        private Object[] modules;

        public ModulesChildren(Object[] objectArray) {
            this.modules = objectArray;
        }

        protected void addNotify() {
            this.setKeys(this.modules);
        }

        protected Node[] createNodes(Object object) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName((String)object);
            abstractNode.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            return new Node[]{abstractNode};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StackTraceChildren
    extends Children.Keys<StackTraceElement> {
        private Throwable throwable;

        public StackTraceChildren(Throwable throwable) {
            this.throwable = throwable;
        }

        protected void addNotify() {
            this.setKeys(this.throwable.getStackTrace());
        }

        protected Node[] createNodes(StackTraceElement stackTraceElement) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setName(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
            abstractNode.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_StackTraceElement", (Object[])new Object[]{stackTraceElement.getFileName(), stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), UINode.afterLastDot(stackTraceElement.getClassName())}));
            abstractNode.setIconBaseWithExtension("org/netbeans/modules/uihandler/stackframe.gif");
            return new Node[]{abstractNode};
        }
    }
}

