/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.remote;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.Lookup;

public abstract class RemoteSyncFactory {
    public abstract RemoteSyncWorker createNew(File var1, ExecutionEnvironment var2, PrintWriter var3, PrintWriter var4);

    public abstract boolean isApplicable(ExecutionEnvironment var1);

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract String getID();

    public static RemoteSyncFactory fromID(String string) {
        assert (string != null);
        for (RemoteSyncFactory remoteSyncFactory : RemoteSyncFactory.getFactories()) {
            if (!string.equals(remoteSyncFactory.getID())) continue;
            return remoteSyncFactory;
        }
        Logger.global.severe("No RemoteSyncFactory found by with ID " + string);
        return null;
    }

    public static RemoteSyncFactory[] getFactories() {
        Collection collection = Lookup.getDefault().lookupAll(RemoteSyncFactory.class);
        return collection.toArray(new RemoteSyncFactory[collection.size()]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static RemoteSyncFactory getDefault() {
        RemoteSyncFactory[] remoteSyncFactoryArray = RemoteSyncFactory.getFactories();
        assert (remoteSyncFactoryArray.length > 0);
        return remoteSyncFactoryArray[0];
    }
}

